/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.export;

import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.ExpComponent;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ExpContainer
extends ExpComponent {
    List<ExpComponent> _comps;

    public ExpContainer() {
        this(new ArrayList<ExpComponent>());
    }

    public ExpContainer(List<ExpComponent> args) {
        this._comps = args;
        for (ExpComponent comp : args) {
            comp.setContainer(this);
        }
    }

    public int size() {
        return this._comps.size();
    }

    public ExpComponent get(int idx) {
        return this._comps.get(idx);
    }

    public void add(ExpComponent comp) {
        this._comps.add(comp);
        comp.setContainer(this);
    }

    protected void sectionIncrement() {
        this.getBook().sectionIncrement();
    }

    protected void sectionDecrement() {
        this.getBook().sectionDecrement();
    }

    @Override
    public void writeDocbook(DBKOutput output) throws IOException {
        this.sectionIncrement();
        for (ExpComponent expComponent : this._comps) {
            expComponent.writeDocbook(output);
        }
        this.sectionDecrement();
    }

    @Override
    public void writeScribe(SrbInputStream scribe) throws IOException {
        this.sectionIncrement();
        for (ExpComponent expComponent : this._comps) {
            expComponent.writeScribe(scribe);
        }
        this.sectionDecrement();
    }
}

