/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.export;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.export.ExpComponent;
import com.dassault.cecilia.core.cecilia.export.ExpContainer;
import com.dassault.cecilia.core.cecilia.export.ExpSection;
import com.dassault.cecilia.core.cecilia.export.ExpTableAttributes;
import com.dassault.cecilia.core.cecilia.export.ExpTableBTPFolders;
import com.dassault.cecilia.core.cecilia.export.ExpTableBTPModelLaws;
import com.dassault.cecilia.core.cecilia.export.ExpTableBTPSustantiation;
import com.dassault.cecilia.core.cecilia.export.ExpTableCCFs;
import com.dassault.cecilia.core.cecilia.export.ExpTableParameters;
import com.dassault.cecilia.core.cecilia.export.XPortConfig;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.faulttree.ft.export.XPortCfgTree;
import com.dassault.cecilia.dbobj.mbsa.export.XPortCfgComponent;
import com.dassault.cecilia.dbobj.mbsa.export.XPortCfgEquipment;
import com.dassault.cecilia.dbobj.mbsa.export.XPortCfgOperator;
import com.dassault.cecilia.dbobj.mbsa.export.XPortCfgSystem;
import com.dassault.cecilia.dbobj.mbsa.export.XPortCfgTypeEnum;
import com.dassault.cecilia.dbobj.mbsa.export.XPortCfgTypeRecord;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ExpDetailOfDependencies
extends ExpSection {
    private static Logger _LOG = Logger.getLogger(ExpDetailOfDependencies.class.getPackage().getName());

    @Override
    public String getTitle() {
        return ResMsgCore.getString("DBK_DEPENDENCIES_DETAIL");
    }

    public static void construct(ExpContainer container, Map<DBFolder.Family, List<DBFolder>> dependencies) {
        ArrayList<DBFolder.Family> families = new ArrayList<DBFolder.Family>(dependencies.keySet());
        Collections.reverse(families);
        for (DBFolder.Family family : families) {
            List<DBFolder> folders = dependencies.get((Object)family);
            Collections.sort(folders);
            switch (family) {
                case EQUIPMENT: {
                    ExpDetailOfDependencies.addRake(container, ResMsgVoc.getString("VOC_EQUIPMENTS"), new XPortCfgEquipment(), folders);
                    break;
                }
                case COMPONENT: {
                    ExpDetailOfDependencies.addRake(container, ResMsgVoc.getString("VOC_COMPONENTS"), new XPortCfgComponent(), folders);
                    break;
                }
                case OPERATOR: {
                    ExpDetailOfDependencies.addRake(container, ResMsgVoc.getString("VOC_OPERATORS"), new XPortCfgOperator(), folders);
                    break;
                }
                case TYPE: {
                    ExpDetailOfDependencies.addRake(container, ResMsgVoc.getString("VOC_TYPES") + " [" + ResMsgVoc.getString("VOC_ENUM") + "]", new XPortCfgTypeEnum(), ExpDetailOfDependencies.filterSubFamily(folders, (short)1));
                    ExpDetailOfDependencies.addRake(container, ResMsgVoc.getString("VOC_TYPES") + " [" + ResMsgVoc.getString("VOC_RECORD") + "]", new XPortCfgTypeRecord(), ExpDetailOfDependencies.filterSubFamily(folders, (short)2));
                    break;
                }
                case PROJECT: {
                    ExpDetailOfDependencies.addRake(container, ResMsgVoc.getString("VOC_MODELS"), new XPortCfgSystem(), ExpDetailOfDependencies.filterSubFamily(folders, (short)1));
                    ExpDetailOfDependencies.addRake(container, ResMsgVoc.getString("VOC_BEQS"), new XPortCfgTree(), ExpDetailOfDependencies.filterSubFamily(folders, (short)5));
                    ExpDetailOfDependencies.addRake(container, ResMsgVoc.getString("VOC_TREES"), new XPortCfgTree(), ExpDetailOfDependencies.filterSubFamily(folders, (short)2));
                    break;
                }
                case ATTRIBUTE: {
                    ExpDetailOfDependencies.addTable(container, ResMsgVoc.getString("VOC_ATTRIBUTES"), new ExpTableAttributes(folders));
                    break;
                }
                case PARAMETER: {
                    ExpDetailOfDependencies.addTable(container, ResMsgVoc.getString("VOC_PARAMETERS"), new ExpTableParameters(folders));
                    break;
                }
                case BTP_MODEL: {
                    ExpDetailOfDependencies.addTable(container, ResMsgVoc.getString("VOC_EVENTS_MODELS"), new ExpTableBTPModelLaws(folders));
                    break;
                }
                case BTP_APPLICATION: {
                    ExpDetailOfDependencies.addTable(container, ResMsgVoc.getString("VOC_APPLICATIONS"), new ExpTableBTPFolders(folders));
                    break;
                }
                case BTP_AUTHOR: {
                    ExpDetailOfDependencies.addTable(container, ResMsgVoc.getString("VOC_AUTHORS"), new ExpTableBTPFolders(folders));
                    break;
                }
                case BTP_SUBSTANTIATION: {
                    ExpDetailOfDependencies.addTable(container, ResMsgVoc.getString("VOC_SUBSTANTIATIONS"), new ExpTableBTPSustantiation(folders));
                    break;
                }
                case CCF_MODEL: {
                    ExpDetailOfDependencies.addTable(container, ResMsgVoc.getString("VOC_CCF_MODELS"), new ExpTableCCFs(folders));
                }
            }
        }
    }

    private static List<DBFolder> filterSubFamily(List<DBFolder> folders, short familyFlag) {
        ArrayList<DBFolder> result = new ArrayList<DBFolder>(folders.size());
        for (DBFolder dbFolder : folders) {
            if (dbFolder.getFamilyFlag() != familyFlag) continue;
            result.add(dbFolder);
        }
        return result;
    }

    protected static void addRake(ExpContainer container, final String title, XPortConfig xportCfg, List<DBFolder> folders) {
        if (folders == null) {
            return;
        }
        if (folders.isEmpty()) {
            return;
        }
        ExpSection subSection = new ExpSection(){

            @Override
            public String getTitle() {
                return title;
            }
        };
        container.add(subSection);
        for (DBFolder dbFolder : folders) {
            DBWrap dbWrap = container.getBook().getDAOFactory().findOrCreateWrap(dbFolder);
            if (dbWrap == null) {
                _LOG.info("Impossible de creer l'objet technique se referant au dossier : " + dbFolder.getRefPath());
                continue;
            }
            xportCfg.addInto(subSection, dbWrap);
        }
    }

    private static void addTable(ExpContainer container, final String title, ExpComponent expChild) {
        ExpSection subSection = new ExpSection(){

            @Override
            public String getTitle() {
                return title;
            }
        };
        container.add(subSection);
        subSection.add(expChild);
    }
}

