/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.export;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.ExpSection;
import com.dassault.cecilia.core.cecilia.folder.DBFolderResources;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjProperty;
import java.io.IOException;

public class ExpGeneral
extends ExpSection {
    DBFolder _dbFolder;

    public ExpGeneral(DBFolder dbFolder) {
        this._dbFolder = dbFolder;
    }

    @Override
    public String getTitle() {
        return ResMsgVoc.getString("VOC_IDENTIFICATION");
    }

    @Override
    protected void writeContentDocbook(DBKOutput output) throws IOException {
        DBFolder dbModel = this._dbFolder;
        if (this._dbFolder.isVersion()) {
            dbModel = dbModel.getParent();
        }
        StringBuilder sb = new StringBuilder();
        dbModel.getParent().getPathUntilSystem(sb);
        this.writeDBKSimpleParamKey(output, ResMsgVoc.getString("VOC_PATH"), sb.toString());
        this.writeDBKSimpleParamKey(output, ResMsgVoc.getString("VOC_NAME"), DBFolderResources.getName(dbModel));
        if (this._dbFolder.isVersion()) {
            this.writeDBKSimpleParamKey(output, ResMsgVoc.getString("VOC_VERSION"), DBFolderResources.getName(this._dbFolder));
        }
        this.writeDBKSimpleParamKey(output, ResMsgVoc.getString("VOC_TYPE"), DBFolderResources.getTypeName(dbModel));
        DBObjProperty dbObjProp = null;
        if (this._dbFolder.isVersion() && this._dbFolder.getObject() != null) {
            dbObjProp = this._dbFolder.getObject().getProperty("object.creator");
        }
        if (dbObjProp != null) {
            this.writeDBKSimpleParamKey(output, ResMsgVoc.getString("VOC_CREATION"), ResMsgCore.msgFormat("MSG_DATE_BY_USER", this.dateToString(this._dbFolder.getDateCreate()), dbObjProp.getValue()));
        } else {
            this.writeDBKSimpleParamKey(output, ResMsgVoc.getString("VOC_CREATION"), this.dateToString(this._dbFolder.getDateCreate()));
        }
        sb = new StringBuilder();
        sb.append(ResMsgCore.msgFormat("MSG_DATE_BY_USER", this.dateToString(this._dbFolder.getDateModify()), this._dbFolder.getUserModify().getLogin()));
        if (this._dbFolder.isFreeze()) {
            sb.append(" [").append(ResMsgVoc.getString("VOC_FREEZE")).append("]");
        }
        this.writeDBKSimpleParamKey(output, ResMsgVoc.getString("VOC_MODIFICATION"), sb.toString());
        this.writeDBKComments(output);
    }

    protected void writeDBKComments(DBKOutput output) throws IOException {
        if (!this._dbFolder.isVersion()) {
            String desc = this._dbFolder.getDescription();
            if (desc.isEmpty()) {
                return;
            }
            this.writeDBKSimpleParamKey(output, ResMsgVoc.getString("VOC_COMMENT"), desc);
        } else {
            String descM = this._dbFolder.getParent().getDescription();
            String descV = this._dbFolder.getDescription();
            if (descM == null) {
                descM = "";
            }
            if (descV == null) {
                descV = "";
            }
            if (!descM.isEmpty() && !descV.isEmpty()) {
                this.writeDBKSimpleParamKey(output, ResMsgVoc.msgFormat("FRM_COMMENT_OF", DBFolderResources.getTypeName(this._dbFolder.getParent())), descM);
                this.writeDBKSimpleParamKey(output, ResMsgVoc.msgFormat("FRM_COMMENT_OF", DBFolderResources.getTypeName(this._dbFolder)), descV);
            } else if (!descM.isEmpty()) {
                this.writeDBKSimpleParamKey(output, ResMsgVoc.getString("VOC_COMMENT"), descM);
            } else if (!descV.isEmpty()) {
                this.writeDBKSimpleParamKey(output, ResMsgVoc.getString("VOC_COMMENT"), descV);
            }
        }
    }

    @Override
    protected void writeContentScribe(SrbInputStream scribe) throws IOException {
        DBFolder dbModel = this._dbFolder;
        if (this._dbFolder.isVersion()) {
            dbModel = dbModel.getParent();
        }
        scribe.concat("<UL>\n");
        StringBuilder sb = new StringBuilder();
        dbModel.getParent().getPathUntilSystem(sb);
        this.writeSRBSimpleParamKey(scribe, ResMsgVoc.getString("VOC_PATH"), sb.toString());
        this.writeSRBSimpleParamKey(scribe, ResMsgVoc.getString("VOC_NAME"), DBFolderResources.getName(dbModel));
        if (this._dbFolder.isVersion()) {
            this.writeSRBSimpleParamKey(scribe, ResMsgVoc.getString("VOC_VERSION"), DBFolderResources.getName(this._dbFolder));
        }
        this.writeSRBSimpleParamKey(scribe, ResMsgVoc.getString("VOC_TYPE"), DBFolderResources.getTypeName(dbModel));
        DBObjProperty dbObjProp = null;
        if (this._dbFolder.isVersion() && this._dbFolder.getObject() != null) {
            dbObjProp = this._dbFolder.getObject().getProperty("object.creator");
        }
        if (dbObjProp != null) {
            this.writeSRBSimpleParamKey(scribe, ResMsgVoc.getString("VOC_CREATION"), ResMsgCore.msgFormat("MSG_DATE_BY_USER", this.dateToString(this._dbFolder.getDateCreate()), dbObjProp.getValue()));
        } else {
            this.writeSRBSimpleParamKey(scribe, ResMsgVoc.getString("VOC_CREATION"), this.dateToString(this._dbFolder.getDateCreate()));
        }
        sb = new StringBuilder();
        sb.append(ResMsgCore.msgFormat("MSG_DATE_BY_USER", this.dateToString(this._dbFolder.getDateModify()), this._dbFolder.getUserModify().getLogin()));
        if (this._dbFolder.isFreeze()) {
            sb.append(" [").append(ResMsgVoc.getString("VOC_FREEZE")).append("]");
        }
        this.writeSRBSimpleParamKey(scribe, ResMsgVoc.getString("VOC_MODIFICATION"), sb.toString());
        scribe.concat("<EUL>\n");
        this.writeScribeComments(scribe);
    }

    protected void writeScribeComments(SrbInputStream scribe) {
        String comment;
        if (this._dbFolder.isVersion() && (comment = this._dbFolder.getParent().getDescription()) != null && comment.length() > 0) {
            scribe.concat("@@");
            this.exportScribeComment(scribe, comment, "\n.br \n@@");
            scribe.concat("\n");
            scribe.concat(".br \n");
        }
        if ((comment = this._dbFolder.getDescription()) != null && comment.length() > 0) {
            scribe.concat("@@");
            this.exportScribeComment(scribe, comment, "\n.br \n@@");
            scribe.concat("\n");
            scribe.concat(".br \n");
        }
    }
}

