/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.export;

import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.ExpComponent;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import java.io.IOException;
import java.util.logging.Level;

public abstract class ExpTable
extends ExpComponent {
    protected String getTitle() {
        return null;
    }

    protected abstract int getColumnCount();

    protected abstract String getColumnName(int var1);

    protected ExpAlign getColumnAlign(int col) {
        return ExpAlign.CENTER;
    }

    protected int getColumnWidth(int col) {
        return 5;
    }

    protected abstract int getRowCount();

    protected int getNbrRowsForValueAt(int col, int row) {
        return 1;
    }

    @Override
    public void writeDocbook(DBKOutput output) throws IOException {
        int nbCol = this.getColumnCount();
        int nbRow = this.getRowCount();
        output.write("<informaltable frame=\"all\">\n", false);
        output.addIndent(1);
        output.write("<tgroup cols=\"" + nbCol + "\"> \n", false);
        output.addIndent(1);
        if (this.getColumnName(0) != null) {
            output.write("<thead><row>\n", false);
            output.addIndent(1);
            for (int i = 0; i < nbCol; ++i) {
                output.write("<entry align=\"", false);
                output.write(ExpAlign.CENTER.getDocbookCode(), true);
                output.write("\">", false);
                output.write(this.getColumnName(i), true);
                output.write("</entry>\n", false);
            }
            output.addIndent(-1);
            output.write("</row></thead>\n", false);
        }
        output.write("<tbody>\n", false);
        output.addIndent(1);
        for (int row = 0; row < nbRow; ++row) {
            output.write("<row>\n", false);
            output.addIndent(1);
            for (int col = 0; col < nbCol; ++col) {
                int nbrRows = this.getNbrRowsForValueAt(row, col);
                if (nbrRows == 1) {
                    output.write("<entry align=\"", false);
                    output.write(this.getColumnAlign(col).getDocbookCode(), true);
                    output.write("\">", false);
                    this.writeDocbookEntryAt(output, col, row);
                    output.write("</entry>\n", false);
                    continue;
                }
                if (nbrRows <= 1) continue;
                output.write("<entry morerows=\"" + (nbrRows - 1) + "\">", false);
                this.writeDocbookEntryAt(output, row, col);
                output.write("</entry>\n", false);
            }
            output.addIndent(-1);
            output.write("</row>\n", false);
        }
        output.addIndent(-1);
        output.write("</tbody>\n", false);
        output.addIndent(-1);
        output.write("</tgroup>\n", false);
        output.addIndent(-1);
        output.write("</informaltable>\n", false);
    }

    protected abstract void writeDocbookEntryAt(DBKOutput var1, int var2, int var3) throws IOException;

    @Override
    public void writeScribe(SrbInputStream scribe) throws IOException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<TABLEAU>\n");
        String title = this.getTitle();
        if (title != null && !title.isEmpty()) {
            buffer.append("<TABTIT>").append(title).append("\n");
        }
        this.exportToScribe(buffer);
        buffer.append("<ETABLEAU>\n");
        scribe.concat(buffer.toString());
    }

    private void exportToScribe(StringBuilder b) {
        for (int col = 0; col < this.getColumnCount(); ++col) {
            b.append("<TABCOL>" + this.getColumnName(col) + "\n");
        }
        StringBuilder cwidth = new StringBuilder();
        StringBuilder align = new StringBuilder();
        for (int col = 0; col < this.getColumnCount(); ++col) {
            cwidth.append(this.getColumnWidth(col) * 5 / 3);
            cwidth.append(" ");
            align.append(this.getColumnAlign(col).getScribeCode());
            align.append(" ");
        }
        cwidth.deleteCharAt(cwidth.length() - 1);
        align.deleteCharAt(align.length() - 1);
        b.append("<TABDEF CWIDTH = '");
        b.append((CharSequence)cwidth);
        b.append("' ALIGN = '");
        b.append((CharSequence)align);
        b.append("'>\n");
        this.logMsg(Level.FINEST, "ExpTable.Rules.Align = '" + align + "'");
        this.logMsg(Level.FINEST, "ExpTable.Rules.Width = '" + cwidth + "'");
        for (int row = 0; row < this.getRowCount(); ++row) {
            int maxSubCell = 1;
            for (int col = 0; col < this.getColumnCount(); ++col) {
                maxSubCell = Math.max(maxSubCell, this.getNbrRowsForValueAt(row, col));
            }
            for (int idxSubCell = 0; idxSubCell < maxSubCell; ++idxSubCell) {
                for (int col = 0; col < this.getColumnCount(); ++col) {
                    b.append("<C>");
                    this.exportToScribeEntryAt(b, col, row, idxSubCell);
                    b.append("\n");
                }
            }
        }
    }

    protected abstract void exportToScribeEntryAt(StringBuilder var1, int var2, int var3, int var4);

    public static enum ExpAlign {
        LEFT,
        CENTER,
        RIGHT;


        public String getDocbookCode() {
            return this.toString().toLowerCase();
        }

        public String getScribeCode() {
            return this.toString().substring(0, 1);
        }
    }
}

