/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.export;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import java.io.File;
import javax.swing.JFileChooser;

public class JChooserFileUtility {
    private JChooserFileUtility() {
    }

    public static void configureFileFilter(JFileChooser dlg, Type type) {
        dlg.resetChoosableFileFilters();
        FileFilterExtention defaultFilter = new FileFilterExtention(type._label, type._extension);
        dlg.addChoosableFileFilter(defaultFilter);
        dlg.setFileFilter(defaultFilter);
    }

    public static void configureCurrentDirectory(JFileChooser dlg, Plugable plugable) {
        File pdir;
        String property;
        File dir = new File(".");
        if (plugable != null && (property = plugable.getOption("plugable.option.path")) != null && !(pdir = new File(property)).isDirectory()) {
            dir = pdir;
        }
        dlg.setCurrentDirectory(dir);
    }

    public static enum Type {
        DOCBOOK(ResMsgCore.getString("FILE_TYPE_DOCBOOK"), ".docbook.xml"),
        WORD(ResMsgCore.getString("FILE_TYPE_WORDXML"), ".word.xml"),
        XML(ResMsgCore.getString("FILE_TYPE_XML"), ".xml"),
        TXT(ResMsgCore.getString("FILE_TYPE_TXT"), ".txt"),
        H2(ResMsgCore.getString("FILE_TYPE_H2"), ".mv.db");

        String _label;
        String _extension;

        private Type(String lbl, String ext) {
            this._label = lbl;
            this._extension = ext;
        }

        public String getExtension() {
            return this._extension;
        }
    }
}

