/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.export;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.dependencies.GenerateDepFolders;
import com.dassault.cecilia.core.cecilia.export.ExpBook;
import com.dassault.cecilia.core.cecilia.export.ExpContainer;
import com.dassault.cecilia.core.cecilia.export.ExpDetailOfDependencies;
import com.dassault.cecilia.core.cecilia.export.ExpListOfDependencies;
import com.dassault.cecilia.core.cecilia.export.ExpSection;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldsCategory;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.dbobj.general.pref.DependenciesPrintPreferencies;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class XPortCfgDependencies {
    boolean _bWithLoDeps = false;
    boolean _bWithDeps = false;
    boolean _bWithDepsSection = false;

    protected void addDependencies(ExpBook expBook, DBWrap item) {
        this.addDependencies(expBook, item.getDBFolder(), item.getUseRelations());
    }

    private void addDependencies(ExpBook expBook, DBFolder dbFolder, Collection<DBRelation> dbRelations) {
        this.readPreferencies(expBook);
        Set<DBFolder> dependencies = null;
        if (this.withListOfDependencies() || this.withDependencies()) {
            GenerateDepFolders generate = new GenerateDepFolders(expBook.getDAOFactory());
            generate.prepare(dbFolder, dbFolder, dbRelations);
            dependencies = generate.getDepends(false);
            dependencies.remove(dbFolder);
        }
        if (this.withDependencies()) {
            this.addDetailOfDependencies(expBook, dependencies);
        }
        if (this.withListOfDependencies()) {
            this.addListOfDependencies(expBook, dependencies);
        }
    }

    protected boolean withListOfDependencies() {
        return this._bWithLoDeps;
    }

    protected boolean withDependencies() {
        return this._bWithDeps;
    }

    private void readPreferencies(ExpBook expBook) {
        PluginWithOptions opts = expBook.getPreferencies().getOptions(DependenciesPrintPreferencies.PREF_KEY);
        if (opts == null || !(opts instanceof DependenciesPrintPreferencies)) {
            opts = new DependenciesPrintPreferencies();
            expBook.getPreferencies().addOptions(opts);
        }
        PrefFieldsCategory prefs = (PrefFieldsCategory)opts;
        this._bWithDeps = prefs.getPref("Define").isSelected();
        this._bWithDepsSection = prefs.getPref("Define.WithSection").isSelected();
        this._bWithLoDeps = prefs.getPref("ListOf").isSelected();
    }

    protected void addListOfDependencies(ExpContainer expContainer, Set<DBFolder> dependencies) {
        if (dependencies.isEmpty()) {
            return;
        }
        ExpSection sectionDef = new ExpSection(){

            @Override
            public String getTitle() {
                return ResMsgCore.getString("DBK_DEPENDENCIES_LIST");
            }
        };
        expContainer.add(sectionDef);
        sectionDef.add(new ExpListOfDependencies(dependencies));
    }

    protected void addDetailOfDependencies(ExpContainer expContainer, Set<DBFolder> dependencies) {
        if (dependencies.isEmpty()) {
            return;
        }
        Map<DBFolder.Family, List<DBFolder>> map = this.createFamilyMap(dependencies);
        if ((map = this.filterFamilyMap(map)).isEmpty()) {
            return;
        }
        if (this._bWithDepsSection) {
            ExpDetailOfDependencies sectionDef = new ExpDetailOfDependencies();
            expContainer.add(sectionDef);
            ExpDetailOfDependencies.construct(sectionDef, map);
        } else {
            ExpDetailOfDependencies.construct(expContainer, map);
        }
    }

    private Map<DBFolder.Family, List<DBFolder>> filterFamilyMap(Map<DBFolder.Family, List<DBFolder>> map) {
        return map;
    }

    private Map<DBFolder.Family, List<DBFolder>> createFamilyMap(Set<DBFolder> dependencies) {
        TreeMap<DBFolder.Family, List<DBFolder>> map = new TreeMap<DBFolder.Family, List<DBFolder>>(DBFolder.Family.getComparator());
        for (DBFolder depFolder : dependencies) {
            ArrayList<DBFolder> lst = (ArrayList<DBFolder>)map.get((Object)depFolder.getFamily());
            if (lst == null) {
                lst = new ArrayList<DBFolder>();
                map.put(depFolder.getFamily(), lst);
            }
            lst.add(depFolder);
        }
        return map;
    }
}

