/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.folder;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CApplInit;
import com.dassault.cecilia.core.cecilia.dependencies.Generate;
import com.dassault.cecilia.core.cecilia.dependencies.GenerateDepFolders;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeModel;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeNode;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeRenderer;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderDlgDepend;
import com.dassault.cecilia.core.cecilia.folder.gui.DBObjectDlgDebug;
import com.dassault.cecilia.core.plugin.PlugableAppl;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.dbobj.CeciliaFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.dbobj.wrap.compareConflict.DBComparaisons;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.CeciliaGUI;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class DBFolderTree
extends JTree {
    private static Logger _LOG = Logger.getLogger(DBFolderTree.class.getPackage().getName());
    private List<DBTreeActionListener> _llisteners = new ArrayList<DBTreeActionListener>();
    protected DBFolderTreeModel _model;
    private PlugableAppl _application;
    public static final String ACTION_DEBUG = "ACTION_DEBUG";
    public static final String ACTION_DEPEND_DOWN = "ACTION_DEPEND_DOWN";
    public static final String ACTION_DEPEND_UP = "ACTION_DEPENDED_UP";
    public static final String ACTION_EXPAND = "ACTION_EXPAND";
    public static final String ACTION_COLLAPSE = "ACTION_COLLAPSE";
    public static final String ACTION_REFRESH = "ACTION_REFRESH";
    public static final String ACTION_COMPARE = "ACTION_COMPARE";
    protected CeciliaAction _ctrlDebug;
    protected CeciliaAction _ctrlDependDown;
    protected CeciliaAction _ctrlDependUp;
    protected CeciliaAction _ctrlCompareObjects;
    protected CeciliaAction _ctrlExpand;
    protected CeciliaAction _ctrlCollapse;
    protected CeciliaAction _ctrlRefresh;
    protected Map<String, CeciliaAction> _mapActions;
    protected JPopupMenu _popupList;

    public void addDBTreeActionListener(DBTreeActionListener listener) {
        if (!this._llisteners.contains(listener)) {
            this._llisteners.add(listener);
        }
    }

    public void removeDBTreeActionListener(DBTreeActionListener listener) {
        this._llisteners.remove(listener);
    }

    protected void fireDBTreeActionPerformed(DBFolderTreeNode selectNode, MouseEvent e) {
        for (int i = this._llisteners.size() - 1; i >= 0; --i) {
            this._llisteners.get(i).actionPerformed(selectNode, e);
        }
    }

    protected PlugableAppl getAppl() {
        return this._application;
    }

    public DBFolderTree(PlugableAppl application, DBFolderTreeModel model, boolean init) {
        super(model);
        this._application = application;
        this._model = model;
        if (init) {
            this.initialize();
        }
    }

    @Override
    public DBFolderTreeModel getModel() {
        return this._model;
    }

    public DBFolderTree initialize() {
        this.setCellRenderer(new DBFolderTreeRenderer());
        this.setRootVisible(false);
        this.createActions();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                TreePath path = DBFolderTree.this.getPathForLocation(e.getX(), e.getY());
                if (path == null) {
                    return;
                }
                if (DBFolderTree.this.getSelectionModel().isPathSelected(path)) {
                    return;
                }
                DBFolderTree.this.setSelectionPath(path);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                TreePath path = DBFolderTree.this.getPathForLocation(e.getX(), e.getY());
                if (path == null) {
                    return;
                }
                DBFolderTreeNode selectNode = (DBFolderTreeNode)path.getLastPathComponent();
                if (selectNode == null) {
                    return;
                }
                DBFolder dbFolder = selectNode.getDBFolder();
                if (dbFolder == null) {
                    return;
                }
                if (dbFolder.getObject() == null) {
                    return;
                }
                DBFolderTree.this.fireDBTreeActionPerformed(selectNode, e);
            }
        });
        this.getSelectionModel().setSelectionMode(4);
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DBFolderTree.this.refreshActions();
            }
        });
        this.createPopupMenu();
        this.setComponentPopupMenu(this._popupList);
        this.setRowHeight(ResIcoAbstract.getIconSize());
        return this;
    }

    protected void createActions() {
        this._mapActions = new HashMap<String, CeciliaAction>();
        this._ctrlDebug = new CeciliaAction("Debug"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DBFolderTree.this.getSelectionCount() == 0) {
                    return;
                }
                DBFolderTreeNode selectNode = (DBFolderTreeNode)DBFolderTree.this.getSelectionPath().getLastPathComponent();
                DBFolder folder = selectNode.getSource();
                DBFolderTree.this.doDebug(folder);
            }
        }.setDesc("Affiche une fen\u00eatre d'affichage d'information sur l'\u00e9l\u00e9ment courant");
        this._ctrlDebug.setEnabled(false);
        this._mapActions.put(ACTION_DEBUG, this._ctrlDebug);
        this._ctrlDependDown = new CeciliaAction("Depend (Descendants)"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DBFolderTree.this.getSelectionCount() == 0) {
                    return;
                }
                DBFolderTreeNode selectNode = (DBFolderTreeNode)DBFolderTree.this.getSelectionPath().getLastPathComponent();
                DBFolder folder = selectNode.getSource();
                DBFolderTree.this.doDependDescendant(folder);
            }
        }.setDesc("Affiche la liste tous les dossiers dependants (Descendants)");
        this._ctrlDependDown.setEnabled(false);
        this._mapActions.put(ACTION_DEPEND_DOWN, this._ctrlDependDown);
        this._ctrlDependUp = new CeciliaAction("Depend (Ancestors)"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DBFolderTree.this.getSelectionCount() == 0) {
                    return;
                }
                DBFolderTreeNode selectNode = (DBFolderTreeNode)DBFolderTree.this.getSelectionPath().getLastPathComponent();
                DBFolder folder = selectNode.getSource();
                DBFolderTree.this.doDependAncestor(folder);
            }
        }.setDesc("Affiche la liste tous les dossiers qui d\u00e9pendent de la s\u00e9lection (Anc\u00eatres)");
        this._ctrlDependUp.setEnabled(false);
        this._mapActions.put(ACTION_DEPEND_UP, this._ctrlDependUp);
        this._ctrlExpand = new CeciliaAction(ResMsgObj.getString("ACTION_EXPAND_MENU")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DBFolderTree.this.getSelectionCount() == 0) {
                    return;
                }
                TreePath[] selPaths = DBFolderTree.this.getSelectionPaths();
                ArrayList<DBFolder> selFolders = new ArrayList<DBFolder>();
                for (int i = 0; i < selPaths.length; ++i) {
                    DBFolderTreeNode selectNode = (DBFolderTreeNode)selPaths[i].getLastPathComponent();
                    DBFolder folder = selectNode.getSource();
                    if (folder.isVersion()) continue;
                    selFolders.add(folder);
                }
                if (selFolders.size() > 0) {
                    DBFolderTree.this.doExpand(selFolders, -1);
                }
            }
        }.setDesc(ResMsgObj.getString("ACTION_EXPAND_TTIP"));
        this._ctrlExpand.setEnabled(false);
        this._mapActions.put(ACTION_EXPAND, this._ctrlExpand);
        this._ctrlCollapse = new CeciliaAction(ResMsgObj.getString("ACTION_COLLAPSE_MENU")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DBFolderTree.this.getSelectionCount() == 0) {
                    return;
                }
                TreePath[] selPaths = DBFolderTree.this.getSelectionPaths();
                ArrayList<DBFolder> selFolders = new ArrayList<DBFolder>();
                for (int i = 0; i < selPaths.length; ++i) {
                    DBFolderTreeNode selectNode = (DBFolderTreeNode)selPaths[i].getLastPathComponent();
                    DBFolder folder = selectNode.getSource();
                    if (folder.isVersion()) continue;
                    selFolders.add(folder);
                }
                if (selFolders.size() > 0) {
                    DBFolderTree.this.doCollapse(selFolders);
                }
            }
        }.setDesc(ResMsgObj.getString("ACTION_COLLAPSE_TTIP"));
        this._ctrlCollapse.setEnabled(false);
        this._mapActions.put(ACTION_COLLAPSE, this._ctrlCollapse);
        this._ctrlRefresh = new CeciliaAction(ResIcoCore.getImageIcon("BUT_REFRESH"), ResMsgVoc.getString("VOC_REFRESH"), ResMsgObj.getString("ACTION_REFRESH_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBFolderTree.this.doRefresh();
            }
        };
        this._mapActions.put(ACTION_REFRESH, this._ctrlRefresh);
        this._ctrlCompareObjects = new CeciliaAction(ResIcoCore.getImageIcon("COMPARISON_FRAME"), ResMsgObj.getString("ACTION_COMPARE_TWO_OBJECTS"), null){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath[] selPaths = DBFolderTree.this.getSelectionPaths();
                if (selPaths.length != 2) {
                    return;
                }
                ArrayList<DBFolder> selFolders = new ArrayList<DBFolder>();
                for (int i = 0; i < selPaths.length; ++i) {
                    DBFolderTreeNode selectNode = (DBFolderTreeNode)selPaths[i].getLastPathComponent();
                    DBFolder folder = selectNode.getSource();
                    selFolders.add(folder);
                }
                CeciliaFactory folderDAO = (CeciliaFactory)DBFolderTree.this._application.getDAOFactory();
                DBFolder folder1 = (DBFolder)selFolders.get(0);
                DBFolder folder2 = (DBFolder)selFolders.get(1);
                DBWrap wrap1 = folderDAO.findOrCreateWrap(folder1);
                DBWrap wrap2 = folderDAO.findOrCreateWrap(folder2);
                DBComparaisons result = wrap1 == null || wrap2 == null ? folder1.getCompareConflict((DAOFactory)folderDAO, folder2, false) : wrap1.getCompareConflict((DAOFactory)folderDAO, wrap2, false);
                CeciliaGUI gui = ((CeciliaAppl)CApplInit.getInstance()).getTopWindow();
                gui.displayComparatorManager(result, wrap1.getRefPath(), wrap2.getRefPath());
            }
        };
        this._mapActions.put(ACTION_COMPARE, this._ctrlCompareObjects);
    }

    protected void refreshActions() {
        int nbrSel;
        TreePath[] selPaths = this.getSelectionPaths();
        DBFolderTreeNode[] selFolders = null;
        if (selPaths != null) {
            selFolders = new DBFolderTreeNode[selPaths.length];
            for (int i = 0; i < selPaths.length; ++i) {
                selFolders[i] = (DBFolderTreeNode)selPaths[i].getLastPathComponent();
            }
        }
        int n = nbrSel = selFolders == null ? 0 : selFolders.length;
        if (nbrSel == 1) {
            DBFolder folder = selFolders[0].getSource();
            this._ctrlDebug.setEnabled(folder.getObject() != null);
            this._ctrlDependDown.setEnabled(folder.isVersion());
            this._ctrlDependUp.setEnabled(folder.isVersion());
        } else {
            this._ctrlDebug.setEnabled(false);
            this._ctrlDependDown.setEnabled(false);
            this._ctrlDependUp.setEnabled(false);
        }
        boolean oneIsNotVersion = false;
        for (int i = 0; i < nbrSel; ++i) {
            boolean bl = oneIsNotVersion = !selFolders[i].getSource().isVersion();
            if (oneIsNotVersion) break;
        }
        this._ctrlExpand.setEnabled(oneIsNotVersion);
        this._ctrlCollapse.setEnabled(oneIsNotVersion);
    }

    public CeciliaAction getAction(String key) {
        return this._mapActions.get(key);
    }

    protected void createPopupMenu() {
        this._popupList = new JPopupMenu();
        this._popupList = this.createMenuActions(this._popupList);
    }

    protected JPopupMenu createMenuActions(JPopupMenu popupList) {
        popupList.add(this._ctrlExpand);
        popupList.add(this._ctrlCollapse);
        popupList.add(this._ctrlRefresh);
        if (this._application.isDebugMode()) {
            popupList.addSeparator();
            popupList.add(this._ctrlDebug);
            popupList.add(this._ctrlDependDown);
            popupList.add(this._ctrlDependUp);
        }
        return popupList;
    }

    public void doExpand(List<DBFolder> dbFolders, int depth) {
        DBFolderTreeNode.expandTree(this, this._model, dbFolders, depth);
    }

    public void doRefresh() {
        TreePath[] selPaths = this.getSelectionPaths();
        final ArrayList<DBFolder> selectFolders = new ArrayList<DBFolder>(selPaths.length);
        for (int i = 0; i < selPaths.length; ++i) {
            selectFolders.add(((DBFolderTreeNode)selPaths[i].getLastPathComponent()).getDBFolder());
        }
        this.getModel().refreshAll();
        if (selPaths.length > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DBFolderTree.this.doSelect(selectFolders);
                }
            });
        }
    }

    public void doCollapse(List<DBFolder> dbFolders) {
        DBFolderTreeNode.collapseTree(this, this._model, dbFolders);
    }

    public void doSelect(List<DBFolder> lFolders) {
        if (lFolders == null) {
            this.clearSelection();
            return;
        }
        boolean onlyFirst = lFolders.size() == 1 || this.getSelectionModel().getSelectionMode() == 1;
        boolean first = false;
        for (int i = 0; i < lFolders.size(); ++i) {
            DBFolder dbFolder = lFolders.get(i);
            DBFolderTreeNode folderNode = this._model.constructPath(dbFolder);
            if (folderNode == null) {
                _LOG.info("doSelect: Le DBFolderTreeNode n'a pas ete trouve pour le folder : " + dbFolder.toString());
                continue;
            }
            Object[] pathNodes = this._model.getPathToRoot(folderNode);
            if (pathNodes == null || pathNodes.length == 0) {
                _LOG.severe("doSelect: Pas de chemin vers root pour le folder : " + dbFolder);
                continue;
            }
            TreePath treePath = new TreePath(pathNodes);
            TreePath treeParentPath = treePath.getParentPath();
            if (!this.isExpanded(treeParentPath)) {
                this.expandPath(treeParentPath);
            }
            if (onlyFirst) {
                if (first) continue;
                this.clearSelection();
                this.setSelectionPath(treePath);
                first = true;
                final TreePath treePathScroll = treePath;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DBFolderTree.this.scrollPathToVisible(treePathScroll);
                    }
                });
                continue;
            }
            if (!first) {
                this.clearSelection();
                first = true;
            }
            this.addSelectionPath(treePath);
        }
    }

    public void doDebug(DBFolder folder) {
        if (folder.getObject() == null) {
            return;
        }
        DBObjectDlgDebug dlg = new DBObjectDlgDebug(SwingUtilities.getWindowAncestor(this));
        dlg.setTitle("Debug - " + this._application.getTitle());
        dlg.setDAOFactory(this._application.getDAOFactory());
        dlg.setSelect(folder);
        dlg.setModal(true);
        dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
        dlg.setVisible(true);
    }

    public void doDependDescendant(DBFolder folder) {
        if (folder.getObject() == null) {
            return;
        }
        GenerateDepFolders generate = new GenerateDepFolders(this._application.getDAOFactory());
        if (!generate.prepare(folder, folder, null)) {
            return;
        }
        DBFolderDlgDepend dlg = new DBFolderDlgDepend(SwingUtilities.getWindowAncestor(this), this._application.getDAOFactory());
        if (this._application.isDebugMode()) {
            dlg.setDebugMode(true);
        }
        dlg.setTitle("Descendants - " + this._application.getTitle());
        dlg.setSelect(folder, generate.getDepends(true), this._application.getDBUser());
        dlg.setModal(true);
        dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
        dlg.setVisible(true);
    }

    public void doDependAncestor(DBFolder folder) {
        if (folder.getObject() == null) {
            return;
        }
        GenerateDepFolders generate = new GenerateDepFolders(this._application.getDAOFactory());
        generate.setDirection(Generate.Direction.UP);
        if (!generate.prepare(folder, folder, null)) {
            return;
        }
        DBFolderDlgDepend dlg = new DBFolderDlgDepend(SwingUtilities.getWindowAncestor(this), this._application.getDAOFactory());
        if (this._application.isDebugMode()) {
            dlg.setDebugMode(true);
        }
        dlg.setTitle("Ancestors - " + this._application.getTitle());
        dlg.setSelect(folder, generate.getDepends(true), this._application.getDBUser());
        dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
        dlg.setVisible(true);
    }

    public static interface DBTreeActionListener {
        public void actionPerformed(DBFolderTreeNode var1, MouseEvent var2);
    }
}

