/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.folder;

import com.dassault.cecilia.core.cecilia.folder.DBFolderResources;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeNodeFile;
import com.dassault.cecilia.db.IFolder;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class DBFolderTreeRenderer
extends DefaultTreeCellRenderer {
    protected void prepareTreeCellRenderer(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, focus);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
        this.prepareTreeCellRenderer(tree, value, sel, expanded, leaf, row, focus);
        if (value instanceof DBFolderTreeNodeFile) {
            DBFolderTreeNodeFile ff = (DBFolderTreeNodeFile)value;
            this.setText(ff.getName());
            this.setIcon(ff.getIcon());
        } else if (value instanceof IFolder) {
            ImageIcon icon;
            IFolder folder = (IFolder)value;
            String text = DBFolderResources.getName(folder);
            if (folder.isSystem()) {
                StringBuffer sb = new StringBuffer();
                sb.append("<html><i>").append(text).append("</i></html>");
                this.setText(sb.toString());
            } else {
                this.setText(text);
            }
            if (folder.isReadOnly() && !sel) {
                this.setForeground(Color.magenta);
            }
            if ((icon = DBFolderResources.getIcon(folder, expanded, leaf, false, false)) != null) {
                this.setIcon(icon);
            }
        }
        return this;
    }
}

