/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.folder;

import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeModel;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeModelInterface;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeNode;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.db.dao.DAOUser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.tree.TreeNode;

public class DBFolderVirtualTreeModel
extends DBFolderTreeModel {
    private static Logger _LOG = Logger.getLogger(DBFolderVirtualTreeModel.class.getPackage().getName());
    protected static Comparator<? super DBFolderTreeNode> __DBFolderVirtualTreeNodeComparator = new Comparator<DBFolderTreeNode>(){

        @Override
        public int compare(DBFolderTreeNode o1, DBFolderTreeNode o2) {
            return ((DBFolderVirtualTreeNode)o1).getFamilyFlag() - ((DBFolderVirtualTreeNode)o2).getFamilyFlag();
        }
    };

    public DBFolderVirtualTreeModel(DAOFolder daoFolder, DAOUser daoUser, DBUser dbUser, DBFolder.Family family, String identifier) {
        super(daoFolder, daoUser, dbUser, family, identifier);
    }

    @Override
    protected boolean isGoodParent(TreeNode parent, DBFolder dbFolder) {
        if (dbFolder.isModel()) {
            if (!(parent instanceof DBFolderVirtualTreeNode)) {
                return false;
            }
            DBFolderVirtualTreeNode parentPrj = (DBFolderVirtualTreeNode)parent;
            if (parentPrj.getFamilyFlag() != dbFolder.getFamilyFlag()) {
                return false;
            }
            return parentPrj.getDBFolder() == dbFolder.getParent();
        }
        return super.isGoodParent(parent, dbFolder);
    }

    @Override
    protected void updateTreeNode(DBFolder dbFolder, DBFolderTreeNode trNode, TreeNode parent) {
        super.updateTreeNode(dbFolder, trNode, parent);
        if (!(trNode instanceof DBFolderVirtualTreeNode)) {
            return;
        }
        DBFolderVirtualTreeNode nodePrj = (DBFolderVirtualTreeNode)trNode;
        if (!nodePrj.isFolderSystem()) {
            return;
        }
        for (int i = nodePrj.getChildCount() - 1; i >= 0; --i) {
            int idx;
            DBFolderVirtualTreeNode virtualTreeNode = (DBFolderVirtualTreeNode)nodePrj.getChildAt(i);
            if (virtualTreeNode.getChildCount() != 0 || (idx = nodePrj.remove(virtualTreeNode)) < 0) continue;
            this.fireTreeNodesRemoved(this, this.getPathToRoot(nodePrj), new int[]{idx}, new Object[]{virtualTreeNode});
        }
    }

    @Override
    protected TreeNode getParentNode(TreeNode nodeFolder) {
        if (!(nodeFolder instanceof DBFolderTreeNode)) {
            return super.getParentNode(nodeFolder);
        }
        DBFolder dbFolder = ((DBFolderTreeNode)nodeFolder).getDBFolder();
        if (nodeFolder instanceof DBFolderVirtualTreeNode && ((DBFolderVirtualTreeNode)nodeFolder).getFamilyFlag() != 0) {
            return this.getTreeNode(dbFolder);
        }
        if (dbFolder.isModel()) {
            DBFolderVirtualTreeNode virtualParent;
            DBFolderTreeNode realParent = this.getTreeNode(dbFolder.getParent());
            if (realParent != null && realParent instanceof DBFolderVirtualTreeNode && (virtualParent = ((DBFolderVirtualTreeNode)realParent).findVirtualNode(dbFolder.getFamilyFlag())) != null) {
                return virtualParent;
            }
            _LOG.warning("Impossible de trouver le noeud virtuel parent de : " + dbFolder);
        }
        return nodeFolder.getParent();
    }

    private TreeNode[] getPathToRoot_rec(TreeNode nodeFolder, int depth) {
        TreeNode[] result;
        if (nodeFolder == null) {
            if (depth == 0) {
                return null;
            }
            result = new DBFolderTreeNode[depth];
        } else {
            result = nodeFolder == this.getRoot() ? new TreeNode[depth] : this.getPathToRoot_rec(this.getParentNode(nodeFolder), ++depth);
            result[result.length - depth] = nodeFolder;
        }
        return result;
    }

    @Override
    public TreeNode[] getPathToRoot(TreeNode aNode) {
        if (aNode instanceof DBFolderVirtualTreeNode) {
            return this.getPathToRoot_rec(aNode, 0);
        }
        return super.getPathToRoot(aNode);
    }

    @Override
    protected DBFolderTreeNode createTreeNode(DBFolder dbFolder) {
        return new DBFolderVirtualTreeNode((DBFolderTreeModelInterface)this, dbFolder);
    }

    public class DBFolderVirtualTreeNode
    extends DBFolderTreeModel.DBFolderFilterTreeNode {
        boolean _isSystem;
        short _familyFlag;

        protected DBFolderVirtualTreeNode(DBFolderTreeModelInterface model, DBFolder dbFolder) {
            super(model, dbFolder);
            this._isSystem = false;
            this._familyFlag = 0;
        }

        public boolean isFolderSystem() {
            return this._isSystem;
        }

        @Override
        public short getVirtualFamilyFlag() {
            if (this._familyFlag != 0) {
                return this._familyFlag;
            }
            return super.getVirtualFamilyFlag();
        }

        public short getFamilyFlag() {
            return this._familyFlag;
        }

        @Override
        public boolean isReadOnly() {
            DBFolderTreeNode parent;
            if (this._familyFlag != 0 && (parent = this.getParent()) != null && parent instanceof DBFolderTreeNode) {
                return parent.isReadOnly();
            }
            return super.isReadOnly();
        }

        private DBFolderVirtualTreeNode findVirtualNode(short familyFlag) {
            DBFolderVirtualTreeNode result = null;
            for (int i = 0; result == null && i < this._nodeChildren.size(); ++i) {
                DBFolderTreeNode nodeChild = (DBFolderTreeNode)this._nodeChildren.get(i);
                if (!(nodeChild instanceof DBFolderVirtualTreeNode)) {
                    _LOG.warning("Un noeud enfant d'un systeme n'est pas de type ProjectFolderTreeNode : " + nodeChild.getName());
                    continue;
                }
                if (((DBFolderVirtualTreeNode)nodeChild).getFamilyFlag() != familyFlag) continue;
                result = (DBFolderVirtualTreeNode)nodeChild;
            }
            return result;
        }

        private DBFolderVirtualTreeNode createVirtualNode(short familyFlag) {
            DBFolderVirtualTreeNode result = (DBFolderVirtualTreeNode)DBFolderVirtualTreeModel.this.createTreeNode(this.getDBFolder());
            result._familyFlag = familyFlag;
            result._nodeChildren = new ArrayList(3);
            return result;
        }

        @Override
        public synchronized void createNodeChildren() {
            List<DBFolder> children = this.getDBFolder().getChildren();
            if (children == null) {
                children = this.getModel().findChildren(this.getDBFolder());
            }
            if (children == null || children.isEmpty()) {
                this._nodeChildren = this.getDBFolder().isVersion() && this.getModel().withNodeFiles() ? this.createNodeFiles() : new ArrayList(0);
                return;
            }
            this._nodeChildren = new ArrayList(children.size());
            for (DBFolder dbFolder : children) {
                DBAccess.Right right;
                if (dbFolder.getAccesses() == null) {
                    DBFolderVirtualTreeModel.this.getDAOFolder().findAccesses(dbFolder);
                }
                if ((right = dbFolder.getAccessRight(DBFolderVirtualTreeModel.this.getDBUser())).equals((Object)DBAccess.Right.NONE) || right.equals((Object)DBAccess.Right.INTEGRATE) || !this.getModel().acceptFolder(dbFolder)) continue;
                DBFolderTreeNode trNode = this.getModel().getTreeNode(dbFolder);
                if (trNode == null) {
                    trNode = DBFolderVirtualTreeModel.this.createTreeNode(dbFolder);
                    this.getModel().putTreeNode(dbFolder, trNode);
                }
                trNode.setReadOnly(right.equals((Object)DBAccess.Right.READ));
                if (dbFolder.isModel()) {
                    this._isSystem |= true;
                    short familyFlag = dbFolder.getFamilyFlag();
                    DBFolderVirtualTreeNode virtualTreeNode = this.findVirtualNode(familyFlag);
                    if (virtualTreeNode == null) {
                        virtualTreeNode = this.createVirtualNode(familyFlag);
                        this._nodeChildren.add(virtualTreeNode);
                        virtualTreeNode.setParent(this);
                    }
                    virtualTreeNode._nodeChildren.add(trNode);
                    trNode.setParent(virtualTreeNode);
                    continue;
                }
                this._nodeChildren.add(trNode);
                trNode.setParent(this);
            }
            if (this._isSystem) {
                for (int i = 0; i < this._nodeChildren.size(); ++i) {
                    DBFolderTreeNode dbFolderTreeNode = (DBFolderTreeNode)this._nodeChildren.get(i);
                    DBFolderVirtualTreeNode virtualTreeNode = (DBFolderVirtualTreeNode)dbFolderTreeNode;
                    if (virtualTreeNode == null) {
                        _LOG.severe("Fils n\u00b0" + i + " du dossier systeme '" + this.getDBFolder().getRefPath() + "' est null !!");
                        continue;
                    }
                    if (virtualTreeNode._nodeChildren == null) {
                        _LOG.severe("Les enfants du Fils n\u00b0" + i + "du dossier systeme '" + this.getDBFolder().getRefPath() + "' sont null !!");
                        continue;
                    }
                    if (__DBFolderTreeNodeComparator == null) {
                        _LOG.severe("Le comparateur de TreeNode est null !!");
                        continue;
                    }
                    Collections.sort(virtualTreeNode._nodeChildren, __DBFolderTreeNodeComparator);
                }
                Collections.sort(this._nodeChildren, __DBFolderVirtualTreeNodeComparator);
            } else {
                Collections.sort(this._nodeChildren, __DBFolderTreeNodeComparator);
            }
        }

        @Override
        public int remove(DBFolderTreeNode trNode) {
            DBFolderVirtualTreeNode virtual;
            if (this._isSystem && (virtual = this.findVirtualNode(trNode.getDBFolder().getFamilyFlag())) != null) {
                return virtual.remove(trNode);
            }
            return super.remove(trNode);
        }

        @Override
        public int insert(DBFolderTreeNode trNode) {
            DBFolder dbFolder = trNode.getDBFolder();
            if (this._familyFlag == 0 && !this._isSystem && dbFolder.isModel()) {
                this._isSystem = true;
            }
            if (this._isSystem) {
                short familyFlag = dbFolder.getFamilyFlag();
                if (this._nodeChildren == null) {
                    this.createNodeChildren();
                    return this._nodeChildren.indexOf(this.findVirtualNode(familyFlag));
                }
                if (this._nodeChildren.size() == 0) {
                    DBFolderVirtualTreeNode virtual = this.createVirtualNode(familyFlag);
                    virtual._nodeChildren.add(trNode);
                    trNode.setParent(virtual);
                    this._nodeChildren.add(virtual);
                    virtual.setParent(this);
                    return 0;
                }
                DBFolderVirtualTreeNode virtual = this.findVirtualNode(familyFlag);
                boolean create = false;
                if (virtual == null) {
                    create = true;
                    virtual = this.createVirtualNode(familyFlag);
                    this._nodeChildren.add(virtual);
                    virtual.setParent(this);
                    Collections.sort(this._nodeChildren, __DBFolderVirtualTreeNodeComparator);
                }
                virtual.insert(trNode);
                return create ? this._nodeChildren.indexOf(virtual) : -1;
            }
            return super.insert(trNode);
        }
    }
}

