/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.folder;

import com.dassault.cecilia.core.cecilia.folder.DBFolderResources;
import com.dassault.cecilia.db.DBFolder;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;

public class FolderRenderer
extends DefaultTableCellRenderer
implements ListCellRenderer {
    boolean _withPath = false;
    boolean _withIcon = true;

    public FolderRenderer setDisplayPath(boolean value) {
        this._withPath = value;
        return this;
    }

    public boolean isDisplayPath() {
        return this._withPath;
    }

    public FolderRenderer setDisplayIcon(boolean value) {
        this._withIcon = value;
        return this;
    }

    public boolean isDisplayIcon() {
        return this._withIcon;
    }

    protected Icon convertFolderToIcon(DBFolder folder) {
        if (this._withIcon) {
            return DBFolderResources.getIcon(folder, true, folder.isVersion(), true, false);
        }
        return null;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setEnabled(list.isEnabled());
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setFont(list.getFont());
        if (value != null) {
            if (value instanceof DBFolder) {
                DBFolder folder = (DBFolder)value;
                this.setText(this.convertFolderToText(folder));
                this.setToolTipText(this.convertFolderToTooltip(folder));
                Icon icon = this.convertFolderToIcon(folder);
                if (icon != null) {
                    this.setIcon(icon);
                }
            } else {
                this.setText("<html><b>Error...</b></html>");
            }
        } else {
            this.setText("");
        }
        return this;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setEnabled(table.isEnabled());
        if (value instanceof DBFolder) {
            DBFolder folder = (DBFolder)value;
            String text = this.convertFolderToText(folder);
            if (folder.isSystem()) {
                StringBuffer sb = new StringBuffer();
                sb.append("<html><i>").append(text.replaceAll(" ", "&nbsp;")).append("</i></html>");
                this.setText(sb.toString());
            } else {
                this.setText(text);
            }
            this.setToolTipText(this.convertFolderToTooltip(folder));
            Icon icon = this.convertFolderToIcon(folder);
            if (icon != null) {
                this.setIcon(icon);
            }
        } else {
            this.setText("");
        }
        return this;
    }

    protected String convertFolderToText(DBFolder folder) {
        return FolderRenderer.convertFolderToText(folder, this._withPath ? DBFolderName.SYSTEMPATH : DBFolderName.NAME);
    }

    protected String convertFolderToTooltip(DBFolder folder) {
        if (folder.getID() >= 0L) {
            String tip = folder.getRefPath();
            if (tip != null && tip.isEmpty()) {
                return null;
            }
            return tip;
        }
        return null;
    }

    public static String convertFolderToText(DBFolder folder, DBFolderName folderName) {
        if (folder.isSystem()) {
            return DBFolderResources.getName(folder);
        }
        if (folderName == null) {
            return null;
        }
        switch (folderName) {
            case NAME: {
                return folder.getName();
            }
            case REFPATH: {
                return folder.getRefPath();
            }
            case SYSTEMPATH: {
                StringBuilder sb = new StringBuilder();
                folder.getPathUntilSystem(sb);
                return sb.toString();
            }
        }
        return null;
    }

    public static enum DBFolderName {
        NAME,
        REFPATH,
        SYSTEMPATH;

    }
}

