/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.folder.dnd;

import com.dassault.cecilia.db.DBFolder;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBFolderTransferable
implements Transferable {
    private static Logger _LOG = Logger.getLogger(DBFolderTransferable.class.getPackage().getName());
    public static DataFlavor DB_FLAVOR;
    private DBFolder _data;
    private DataFlavor[] _flavors;

    public DBFolderTransferable(DBFolder data) {
        this._data = data;
        this._flavors = new DataFlavor[]{DB_FLAVOR, DataFlavor.stringFlavor};
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this._flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor df) {
        return df.equals(DB_FLAVOR) || df.equals(DataFlavor.stringFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
        if (df == null) {
            throw new IOException();
        }
        if (df.equals(DB_FLAVOR)) {
            return this._data;
        }
        if (df.equals(DataFlavor.stringFlavor)) {
            return this._data.getRefPath();
        }
        throw new UnsupportedFlavorException(df);
    }

    static {
        try {
            DB_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref;class=" + DBFolder.class.getName());
        }
        catch (ClassNotFoundException e) {
            _LOG.log(Level.SEVERE, "Probleme d'initialisation du presse-papier", e);
        }
    }
}

