/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.folder.gui;

import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeNode;
import com.dassault.cecilia.core.cecilia.folder.FolderTreeTable;
import com.dassault.cecilia.core.cecilia.folder.FolderTreeTableModel;
import com.dassault.cecilia.core.cecilia.user.UserRenderer;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.db.dao.DAOUser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DBFolderDlgDepend
extends JDialogCecilia {
    DAOFactory _daoFactory;
    DBFolder _selectFolder;
    DBUser _dbUser;
    Map<DBFolder, DBAccess.Right> _depends;
    boolean _bCreate = false;
    boolean _isDebugMode = false;
    JScrollPane _scrollPanel;
    FolderTreeTableModel _modelTree;
    FolderTreeTable _ctrlTree;
    JLabel _lblFolder;
    JLabel _lblError;
    JComboBox _ctrlUser;

    public DBFolderDlgDepend(Window owner, DAOFactory daoFactory) {
        super(owner, false);
        this._daoFactory = daoFactory;
        this._scrollPanel = new JScrollPane();
        this._scrollPanel.setPreferredSize(new Dimension(600, 400));
        this._scrollPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.createHeader(), "North");
        this.getContentPane().add((Component)this._scrollPanel, "Center");
        this.getContentPane().add((Component)this.createButPanelClose(false), "South");
        this.init();
        this.pack();
    }

    public void setDebugMode(boolean value) {
        this._isDebugMode = value;
    }

    public DBFolderDlgDepend setSelect(DBFolder dbRoot, Set<DBFolder> depends, DBUser dbUser) {
        this._selectFolder = dbRoot;
        this._lblFolder.setText("Selected: " + dbRoot.getRefPath());
        this._depends = new HashMap<DBFolder, DBAccess.Right>();
        this._dbUser = dbUser;
        this.changeUser(dbUser, depends);
        return this;
    }

    protected void changeUser(DBUser dbUser, Collection<DBFolder> depends) {
        int nbrError = 0;
        for (DBFolder dbFolder : depends) {
            DBAccess.Right right = this._daoFactory.createFolderDAO().getAccessRight(dbFolder, dbUser);
            if (right == DBAccess.Right.NONE) {
                ++nbrError;
            }
            this._depends.put(dbFolder, right);
        }
        this._lblError.setText("Error: " + nbrError);
    }

    @Override
    public void setVisible(boolean b) {
        if (!this._bCreate) {
            this.create();
        }
        super.setVisible(b);
    }

    private synchronized void create() {
        if (this._bCreate) {
            return;
        }
        this._bCreate = true;
        this.init();
        this._scrollPanel.setViewportView(this.createTreeTable());
        this._ctrlUser.setSelectedItem(this._dbUser);
    }

    private Component createHeader() {
        this._lblFolder = new JLabel("Depends: folder/folder/model;version");
        this._lblError = new JLabel("Error: 0");
        DAOUser daoUser = this._daoFactory.createUserDAO();
        this._ctrlUser = new JComboBox<DBUser>(new Vector<DBUser>(daoUser.findAll()));
        this._ctrlUser.setRenderer(new UserRenderer());
        this._ctrlUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DBFolderDlgDepend.this._ctrlUser.getSelectedIndex() == -1) {
                    return;
                }
                DBUser dbuser = (DBUser)DBFolderDlgDepend.this._ctrlUser.getSelectedItem();
                DBFolderDlgDepend.this.changeUser(dbuser, DBFolderDlgDepend.this._depends.keySet());
                DBFolderDlgDepend.this._ctrlTree.repaint();
            }
        });
        JPanel header = new JPanel(new GridBagLayout());
        header.add((Component)this._lblFolder, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        header.add((Component)this._lblError, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        header.add((Component)new JLabel("User"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        header.add((Component)this._ctrlUser, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        return header;
    }

    private Component createTreeTable() {
        DAOFolder daoFolder = this._daoFactory.createFolderDAO();
        DBFolder dbRoot = daoFolder.getRootID("ROOT");
        this._modelTree = new FolderTreeTableModel(daoFolder, dbRoot){

            @Override
            public boolean acceptFolder(DBFolder dbFolder) {
                if (!DBFolderDlgDepend.this._depends.containsKey(dbFolder)) {
                    return false;
                }
                return super.acceptFolder(dbFolder);
            }

            @Override
            public int getColumnCount() {
                return DBFolderDlgDepend.this._isDebugMode ? 8 : 7;
            }

            @Override
            protected FolderTreeTableModel.IDCol convertColIndexToColID(int column) {
                switch (column) {
                    case 0: {
                        return FolderTreeTableModel.IDCol.NAME;
                    }
                    case 1: {
                        return FolderTreeTableModel.IDCol.OWNER;
                    }
                    case 2: {
                        return FolderTreeTableModel.IDCol.GROUP;
                    }
                    case 3: {
                        return FolderTreeTableModel.IDCol.ACCESS_GROUP;
                    }
                    case 4: {
                        return FolderTreeTableModel.IDCol.ACCESS_OTHER;
                    }
                    case 5: {
                        return FolderTreeTableModel.IDCol.SPECIFIC1;
                    }
                    case 6: {
                        return FolderTreeTableModel.IDCol.SPECIFIC2;
                    }
                    case 7: {
                        return FolderTreeTableModel.IDCol.TIME_UPT;
                    }
                }
                return FolderTreeTableModel.IDCol.ERROR;
            }

            @Override
            protected String getColumnName(FolderTreeTableModel.IDCol colID) {
                if (colID == FolderTreeTableModel.IDCol.SPECIFIC1) {
                    return "Specific.Rights";
                }
                if (colID == FolderTreeTableModel.IDCol.SPECIFIC2) {
                    return "User";
                }
                return super.getColumnName(colID);
            }

            @Override
            protected Class getColumnClass(FolderTreeTableModel.IDCol colID) {
                if (colID == FolderTreeTableModel.IDCol.SPECIFIC1) {
                    return String.class;
                }
                if (colID == FolderTreeTableModel.IDCol.SPECIFIC2) {
                    return DBAccess.Right.class;
                }
                return super.getColumnClass(colID);
            }

            @Override
            protected Object getValueAt(DBFolderTreeNode node, FolderTreeTableModel.IDCol colID) {
                if (colID == FolderTreeTableModel.IDCol.SPECIFIC1) {
                    List<DBAccess> accesses = node.getDBFolder().getAccesses();
                    if (accesses == null) {
                        accesses = this._daoFolder.findAccesses(node.getDBFolder());
                    }
                    if (accesses == null) {
                        return "???";
                    }
                    if (accesses.isEmpty()) {
                        return "";
                    }
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < accesses.size(); ++i) {
                        if (i > 0) {
                            sb.append(", ");
                        }
                        DBAccess access = accesses.get(i);
                        sb.append(access.getGroup().getName()).append("[").append(access.getRight().getChar()).append("]");
                    }
                    return sb.toString();
                }
                if (colID == FolderTreeTableModel.IDCol.SPECIFIC2) {
                    return DBFolderDlgDepend.this._depends.get(node.getDBFolder());
                }
                return super.getValueAt(node, colID);
            }
        };
        this._ctrlTree = new FolderTreeTable(this._modelTree){

            @Override
            protected int definePreferredWidth(FolderTreeTableModel.IDCol colID) {
                if (colID == FolderTreeTableModel.IDCol.NAME) {
                    return 250;
                }
                if (colID == FolderTreeTableModel.IDCol.SPECIFIC1) {
                    return 150;
                }
                return super.definePreferredWidth(colID);
            }
        };
        this._ctrlTree.getTree().setRootVisible(false);
        this._ctrlTree.setPreferredScrollableViewportSize(new Dimension(300, 400));
        DBFolderTreeNode.expandTree(this._ctrlTree.getTree(), this._modelTree, dbRoot.getChildren(), -1);
        return this._ctrlTree;
    }
}

