/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.folder.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObjProperty;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOObjModel;
import com.dassault.cecilia.db.dao.DAORelation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class DBObjectDlgDebug
extends JDialogCecilia {
    DAOFactory _daoFactory;
    DBFolder _selectFolder;
    DBObject _selectObject;
    ArrayList<DBObjProperty> _properties = new ArrayList();
    ArrayList<DBObjModel> _models = new ArrayList();
    ArrayList<DBRelation> _srcRelations = new ArrayList();
    ArrayList<DBRelation> _destRelations = new ArrayList();
    JLabel _lblPath;
    JLabel _lblComment;
    JLabel _lblOwner;
    JLabel _lblGroup;
    JLabel _lblCreate;
    JLabel _lblModif;
    JLabel _lblIDFol;
    JLabel _lblIDObj;
    JLabel _lblFamily;
    JLabel _lblFlagFamily;
    JLabel _lblFlagUser;
    JCheckBox _cbxFreeze;
    JCheckBox _cbxLocked;
    JTable _ctrlTableRelationHasUsed;
    JTable _ctrlTableRelationUse;
    JTable _ctrlTableProperties;
    JTable _ctrlTableModels;
    JTextArea _ctrlViewModel;

    public DBObjectDlgDebug(Window owner) {
        super(owner);
        this.create();
    }

    public DBObjectDlgDebug setSelect(DBFolder dbFolder) {
        this._selectFolder = dbFolder;
        this._selectObject = dbFolder.getObject();
        this._properties.clear();
        this._properties.addAll(this._selectObject.getProperties());
        this._models.clear();
        this._models.addAll(this._selectObject.getModels());
        this._srcRelations.clear();
        this._destRelations.clear();
        if (this._daoFactory != null) {
            DAORelation daoRelation = this._daoFactory.createRelationDAO();
            this._srcRelations.addAll(daoRelation.getSourceRelations(dbFolder));
            this._destRelations.addAll(daoRelation.getDestinationRelations(dbFolder));
        }
        this.refreshHeaderInformations();
        return this;
    }

    public void setDAOFactory(DAOFactory daoFactory) {
        this._daoFactory = daoFactory;
    }

    private void create() {
        this.init();
        JSplitPane top = new JSplitPane(0, this.createHeaderPanel(), this.createRelationsPanel());
        JSplitPane but = new JSplitPane(0, this.createPropertiesPanel(), this.createModelsPanel());
        JSplitPane leftSplit = new JSplitPane(0, top, but);
        Component rightSplit = this.createViewModelPanel();
        JSplitPane content = new JSplitPane(1, leftSplit, rightSplit);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)content, "Center");
        this.getContentPane().add((Component)this.createButPanelClose(false), "South");
        this.pack();
    }

    private Component createHeaderPanel() {
        this._lblPath = new JLabel("0123456789012345678901234567890123456789");
        this._lblComment = new JLabel("0123456789012345678901234567890123456789");
        this._lblOwner = new JLabel("012345678901234");
        this._lblGroup = new JLabel("012345678901234");
        this._lblCreate = new JLabel("012345678901234");
        this._lblModif = new JLabel("012345678901234");
        this._lblIDFol = new JLabel("Fol:0123");
        this._lblIDObj = new JLabel("Obj:0123");
        this._lblFamily = new JLabel("Fam:0123");
        this._lblFlagFamily = new JLabel("FF:3");
        this._lblFlagUser = new JLabel("FU:3");
        this._cbxFreeze = new JCheckBox(ResMsgVoc.getString("VOC_FREEZE"));
        this._cbxFreeze.setEnabled(false);
        this._cbxLocked = new JCheckBox(ResMsgVoc.getString("VOC_LOCKED"));
        this._cbxLocked.setEnabled(false);
        JPanel panel = new JPanel(new GridBagLayout());
        int posY = 0;
        panel.add((Component)new JLabel(ResMsgVoc.getString("VOC_PATH")), new GridBagConstraints(0, posY++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 2, 5, 2), 0, 0));
        panel.add((Component)new JLabel(ResMsgVoc.getString("VOC_COMMENTS")), new GridBagConstraints(0, posY++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 2, 5, 2), 0, 0));
        panel.add((Component)new JLabel(ResMsgVoc.getString("VOC_OWNER")), new GridBagConstraints(0, posY++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 2, 5, 2), 0, 0));
        panel.add((Component)new JLabel(ResMsgVoc.getString("VOC_GROUP")), new GridBagConstraints(0, posY++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 2, 5, 2), 0, 0));
        panel.add((Component)new JLabel(ResMsgVoc.getString("VOC_DATE_CREATE")), new GridBagConstraints(0, posY++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 2, 5, 2), 0, 0));
        panel.add((Component)new JLabel(ResMsgVoc.getString("VOC_DATE_MODIF")), new GridBagConstraints(0, posY++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 2, 5, 2), 0, 0));
        posY = 0;
        panel.add((Component)this._lblPath, new GridBagConstraints(1, posY, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 2, 5, 2), 0, 0));
        panel.add((Component)this._lblComment, new GridBagConstraints(1, ++posY, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 2, 5, 2), 0, 0));
        panel.add((Component)this._lblOwner, new GridBagConstraints(1, ++posY, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 2, 5, 2), 0, 0));
        panel.add((Component)this._cbxLocked, new GridBagConstraints(3, posY, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        panel.add((Component)this._lblGroup, new GridBagConstraints(1, ++posY, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 2, 5, 2), 0, 0));
        panel.add((Component)this._cbxFreeze, new GridBagConstraints(3, posY, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        panel.add((Component)this._lblCreate, new GridBagConstraints(1, ++posY, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 2, 5, 2), 0, 0));
        panel.add((Component)this._lblIDFol, new GridBagConstraints(3, posY, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        panel.add((Component)this._lblModif, new GridBagConstraints(1, ++posY, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 2, 5, 2), 0, 0));
        panel.add((Component)this._lblIDObj, new GridBagConstraints(3, posY, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        panel.add((Component)this._lblFamily, new GridBagConstraints(1, ++posY, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 2, 5, 2), 0, 0));
        panel.add((Component)this._lblFlagFamily, new GridBagConstraints(2, posY, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        panel.add((Component)this._lblFlagUser, new GridBagConstraints(3, posY, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResMsgVoc.getString("VOC_INFORMATIONS"))));
        return panel;
    }

    private void refreshHeaderInformations() {
        StringBuilder sb = new StringBuilder();
        this._selectFolder.getPathUntilSystem(sb);
        String path = sb.toString();
        if (path.length() < 80) {
            this._lblPath.setText(path);
        } else {
            this._lblPath.setText(path.substring(0, 80) + "...");
            this._lblPath.setToolTipText(path);
        }
        String comment = this._selectFolder.getDescription();
        if (comment == null) {
            this._lblComment.setText("");
        } else if (comment.length() < 80) {
            this._lblComment.setText(comment);
        } else {
            this._lblComment.setText(comment.substring(0, 80) + "...");
            StringBuilder buffer = new StringBuilder();
            buffer.append("<html>");
            while (comment.length() >= 80) {
                buffer.append(comment.substring(0, 80));
                buffer.append("<br/>");
                comment = comment.substring(80);
            }
            buffer.append(comment);
            buffer.append("</html>");
            this._lblComment.setToolTipText(buffer.toString());
        }
        this._lblOwner.setText(this._selectFolder.getUserOwner().getLogin());
        this._lblGroup.setText(this._selectFolder.getGroupOwner().getName());
        this._lblCreate.setText(this._selectFolder.getDateCreate().toString());
        this._lblModif.setText(this._selectFolder.getDateModify().toString() + " (" + this._selectFolder.getUserModify().getLogin() + ")");
        this._cbxFreeze.setSelected(this._selectObject.isFreeze());
        this._cbxLocked.setSelected(this._selectObject.isLocked());
        this._lblIDFol.setText("Fol:" + this._selectFolder.getID());
        this._lblIDObj.setText("Obj:" + this._selectObject.getID());
        this._lblFamily.setText("Fam:" + this._selectFolder.getFamily().toString().toLowerCase());
        this._lblFlagFamily.setText("FF:" + this._selectFolder.getFamilyFlag());
        this._lblFlagUser.setText("UF:" + this._selectFolder.getUserFlag());
    }

    JTable createRelationsTable(ArrayList<DBRelation> relations, boolean src) {
        RelationsTableModel model = new RelationsTableModel(relations);
        JTable ctrlTable = new JTable(model);
        TableColumn column = null;
        block5: for (int i = 0; i < model.getColumnCount(); ++i) {
            column = ctrlTable.getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    column.setPreferredWidth(src ? 150 : 50);
                    continue block5;
                }
                case 2: {
                    column.setPreferredWidth(src ? 50 : 150);
                    continue block5;
                }
                case 1: 
                case 3: {
                    column.setPreferredWidth(50);
                }
            }
        }
        ctrlTable.setPreferredScrollableViewportSize(new Dimension(200, 50));
        ctrlTable.setDefaultRenderer(DBFolder.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value instanceof DBFolder) {
                    DBFolder dbFolder = (DBFolder)value;
                    if (dbFolder.equals(DBObjectDlgDebug.this._selectFolder)) {
                        this.setText("<html><i>this</i></html>");
                        this.setToolTipText(dbFolder.getRefPath());
                    } else {
                        this.setText(dbFolder.getRefPath());
                        this.setToolTipText(Long.toString(dbFolder.getID()));
                    }
                }
                return this;
            }
        });
        return ctrlTable;
    }

    private Component createRelationsPanel() {
        this._ctrlTableRelationHasUsed = this.createRelationsTable(this._srcRelations, true);
        JScrollPane scroll1 = new JScrollPane(this._ctrlTableRelationHasUsed);
        scroll1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Est utilis\u00e9")));
        this._ctrlTableRelationUse = this.createRelationsTable(this._destRelations, false);
        JScrollPane scroll2 = new JScrollPane(this._ctrlTableRelationUse);
        scroll2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Utilise")));
        return new JSplitPane(0, scroll1, scroll2);
    }

    private Component createPropertiesPanel() {
        PropertiesTableModel model = new PropertiesTableModel();
        this._ctrlTableProperties = new JTable(model);
        TableColumn column = null;
        block6: for (int i = 0; i < model.getColumnCount(); ++i) {
            column = this._ctrlTableProperties.getColumnModel().getColumn(i);
            switch (i) {
                case 1: {
                    column.setPreferredWidth(300);
                    continue block6;
                }
                case 2: {
                    column.setPreferredWidth(100);
                    continue block6;
                }
                case 3: {
                    column.setPreferredWidth(200);
                    continue block6;
                }
                case 0: {
                    column.setPreferredWidth(50);
                }
            }
        }
        this._ctrlTableProperties.setPreferredScrollableViewportSize(new Dimension(400, 50));
        JScrollPane scroll = new JScrollPane(this._ctrlTableProperties);
        scroll.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResMsgVoc.getString("VOC_PROPERTIES"))));
        return scroll;
    }

    private Component createModelsPanel() {
        ModelsTableModel model = new ModelsTableModel();
        this._ctrlTableModels = new JTable(model);
        this._ctrlTableModels.setSelectionMode(1);
        TableColumn column = null;
        block8: for (int i = 0; i < model.getColumnCount(); ++i) {
            column = this._ctrlTableModels.getColumnModel().getColumn(i);
            switch (i) {
                case 1: {
                    column.setPreferredWidth(300);
                    continue block8;
                }
                case 2: {
                    column.setPreferredWidth(100);
                    continue block8;
                }
                case 3: {
                    column.setPreferredWidth(100);
                    continue block8;
                }
                case 4: {
                    column.setPreferredWidth(120);
                    continue block8;
                }
                case 5: {
                    column.setPreferredWidth(100);
                    continue block8;
                }
                case 0: {
                    column.setPreferredWidth(50);
                }
            }
        }
        this._ctrlTableModels.setPreferredScrollableViewportSize(new Dimension(500, 150));
        this._ctrlTableModels.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (DBObjectDlgDebug.this._ctrlViewModel == null) {
                    return;
                }
                if (e.getClickCount() != 2) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                if (DBObjectDlgDebug.this._ctrlTableModels.getSelectedRows().length != 1) {
                    return;
                }
                int tableIdx = DBObjectDlgDebug.this._ctrlTableModels.getSelectedRow();
                if (tableIdx >= 0) {
                    int modelIdx = DBObjectDlgDebug.this._ctrlTableModels.convertRowIndexToModel(tableIdx);
                    DBObjModel dbObjModel = DBObjectDlgDebug.this._models.get(modelIdx);
                    if (e.isControlDown() && e.isAltDown() && e.isShiftDown()) {
                        byte[] ibyte;
                        DAOObjModel daoModel = DBObjectDlgDebug.this._daoFactory.createObjModelDAO();
                        String istr = null;
                        String encoding = dbObjModel.getEncoding();
                        InputStream istream = daoModel.getBinaryStream(dbObjModel);
                        if (istream != null && (ibyte = DAOObjModel.convertFromCompressedByte(istream)) != null) {
                            String buffer = null;
                            if (encoding != null && !encoding.isEmpty()) {
                                if (encoding.equals("ISO-8859-1")) {
                                    buffer = new String(ibyte, DBObjModel.getOcasCharset());
                                } else if (encoding.equals("UTF-8")) {
                                    buffer = new String(ibyte, StandardCharsets.UTF_8);
                                }
                            }
                            if (buffer == null) {
                                buffer = new String(ibyte);
                            }
                            istr = buffer;
                        }
                        if (istr != null) {
                            String stream;
                            byte[] ibyte2;
                            EditModelDlg dlg = new EditModelDlg((Window)DBObjectDlgDebug.this, "Edit model : " + dbObjModel.toString(), istr);
                            dlg.setVisible(true);
                            if (dlg.getResult() && (ibyte2 = DAOObjModel.convertToCompressedByte(new ByteArrayInputStream((stream = dlg.getStream()).getBytes(StandardCharsets.UTF_8)))) != null) {
                                dbObjModel.setEncoding("UTF-8");
                                dbObjModel.setSize(ibyte2.length);
                                dbObjModel.setStreamToSave(new ByteArrayInputStream(ibyte2));
                                daoModel.update(dbObjModel);
                            }
                        }
                    } else {
                        String istr = DAOObjModel.readToString(DBObjectDlgDebug.this._daoFactory.createObjModelDAO(), dbObjModel);
                        if (istr != null) {
                            DBObjectDlgDebug.this._ctrlViewModel.setText(istr);
                            DBObjectDlgDebug.this._ctrlViewModel.select(0, 0);
                        } else {
                            DBObjectDlgDebug.this._ctrlViewModel.setText("Si vous voyez ce message, c'est qu'il y a eu un probl\u00e8me !!");
                        }
                    }
                }
            }
        });
        JScrollPane scroll = new JScrollPane(this._ctrlTableModels);
        scroll.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResMsgVoc.getString("VOC_MODELS"))));
        return scroll;
    }

    private Component createViewModelPanel() {
        this._ctrlViewModel = new JTextArea(30, 80);
        this._ctrlViewModel.setLineWrap(true);
        this._ctrlViewModel.setEditable(false);
        return new JScrollPane(this._ctrlViewModel);
    }

    static class RelationsTableModel
    implements TableModel {
        ArrayList<DBRelation> _relations;
        ArrayList<TableModelListener> _listener = new ArrayList();

        RelationsTableModel(ArrayList<DBRelation> relations) {
            this._relations = relations;
        }

        @Override
        public int getRowCount() {
            if (this._relations == null) {
                return 0;
            }
            return this._relations.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Src ID";
                }
                case 1: {
                    return "Src Type";
                }
                case 2: {
                    return "Dst ID";
                }
                case 3: {
                    return "Dst Type";
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: 
                case 2: {
                    return DBFolder.class;
                }
                case 1: 
                case 3: {
                    return String.class;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this._relations.get(rowIndex).getSource();
                }
                case 1: {
                    return this._relations.get(rowIndex).getTypeSource();
                }
                case 2: {
                    return this._relations.get(rowIndex).getDestination();
                }
                case 3: {
                    return this._relations.get(rowIndex).getTypeDestination();
                }
            }
            return null;
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            if (!this._listener.contains(l)) {
                this._listener.add(l);
            }
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this._listener.remove(l);
        }
    }

    class PropertiesTableModel
    implements TableModel {
        ArrayList<TableModelListener> _listener = new ArrayList();

        PropertiesTableModel() {
        }

        @Override
        public int getRowCount() {
            if (DBObjectDlgDebug.this._properties == null) {
                return 0;
            }
            return DBObjectDlgDebug.this._properties.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 1: {
                    return ResMsgVoc.getString("VOC_NAME");
                }
                case 2: {
                    return ResMsgVoc.getString("VOC_TYPE");
                }
                case 3: {
                    return ResMsgVoc.getString("VOC_VALUE");
                }
                case 0: {
                    return "ID";
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 1: 
                case 2: 
                case 3: {
                    return String.class;
                }
                case 0: {
                    return Long.class;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 1: {
                    return DBObjectDlgDebug.this._properties.get(rowIndex).getName();
                }
                case 2: {
                    return DBObjectDlgDebug.this._properties.get(rowIndex).getType();
                }
                case 3: {
                    return DBObjectDlgDebug.this._properties.get(rowIndex).getValue();
                }
                case 0: {
                    return DBObjectDlgDebug.this._properties.get(rowIndex).getID();
                }
            }
            return null;
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            if (!this._listener.contains(l)) {
                this._listener.add(l);
            }
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this._listener.remove(l);
        }
    }

    class ModelsTableModel
    implements TableModel {
        ArrayList<TableModelListener> _listener = new ArrayList();

        ModelsTableModel() {
        }

        @Override
        public int getRowCount() {
            if (DBObjectDlgDebug.this._models == null) {
                return 0;
            }
            return DBObjectDlgDebug.this._models.size();
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 1: {
                    return "Nature";
                }
                case 2: {
                    return "Format";
                }
                case 3: {
                    return "Encoding";
                }
                case 4: {
                    return "CRC";
                }
                case 5: {
                    return "Size";
                }
                case 0: {
                    return "ID";
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return String.class;
                }
                case 0: 
                case 5: {
                    return Long.class;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 1: {
                    return DBObjectDlgDebug.this._models.get(rowIndex).getNature();
                }
                case 2: {
                    return DBObjectDlgDebug.this._models.get(rowIndex).getFormat();
                }
                case 3: {
                    return DBObjectDlgDebug.this._models.get(rowIndex).getEncoding();
                }
                case 4: {
                    return DBObjectDlgDebug.this._models.get(rowIndex).getCRC();
                }
                case 5: {
                    return DBObjectDlgDebug.this._models.get(rowIndex).getSize();
                }
                case 0: {
                    return DBObjectDlgDebug.this._models.get(rowIndex).getID();
                }
            }
            return null;
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            if (!this._listener.contains(l)) {
                this._listener.add(l);
            }
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this._listener.remove(l);
        }
    }

    static class EditModelDlg
    extends JDialogCecilia {
        JTextArea _ctrlModel = new JTextArea(30, 80);
        String _oldStream;

        EditModelDlg(Window owner, String title, String stream) {
            super(owner, title, true);
            this._ctrlModel.setLineWrap(true);
            this._ctrlModel.setEditable(true);
            this._ctrlModel.setText(stream);
            this._oldStream = stream;
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)new JScrollPane(this._ctrlModel), "Center");
            this.getContentPane().add((Component)this.createButPanel(), "South");
            this.pack();
            this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(owner));
        }

        @Override
        protected boolean verifyParameters() {
            if (this._oldStream.equals(this._ctrlModel.getText())) {
                return false;
            }
            return JOptionPane.showConfirmDialog(JOptionCecilia.getTopContainerOf(this), "Voulez-vous \u00e9craser le flux de donn\u00e9es courant ?") == 0;
        }

        public String getStream() {
            return this._ctrlModel.getText();
        }
    }
}

