/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.pref;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldBoolean;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldsFactory;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public abstract class PrefFieldsCategory
implements PluginWithOptions,
PlugPanel {
    private static Logger _LOG = Logger.getLogger(PrefFieldsCategory.class.getPackage().getName());
    protected List<PrefFieldBoolean> _listBooleanPrefs = this.createFields();
    protected Map<String, PrefFieldBoolean> _mapBooleanPrefs = new LinkedHashMap<String, PrefFieldBoolean>();
    private JPanel _perfFieldsPanel;

    public PrefFieldsCategory() {
        for (PrefFieldBoolean pref : this._listBooleanPrefs) {
            this._mapBooleanPrefs.put(pref.getCode(), pref);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Fields={");
        for (PrefFieldBoolean pref : this._listBooleanPrefs) {
            if (sb.length() > 8) {
                sb.append(", ");
            }
            sb.append(pref.toString());
        }
        sb.append("}");
        return sb.toString();
    }

    public List<PrefFieldBoolean> getBooleanFields() {
        return Collections.unmodifiableList(this._listBooleanPrefs);
    }

    public PrefFieldBoolean getPref(String keyPref) {
        return this._mapBooleanPrefs.get(keyPref);
    }

    protected abstract List<PrefFieldBoolean> createFields();

    protected abstract String getKey();

    protected JPanel makeContent(List<PrefFieldBoolean> fields) {
        return this.makeContent(fields, ResMsgVoc.getString("VOC_FIELDS"));
    }

    protected JPanel makeContent(List<PrefFieldBoolean> fields, String title) {
        JPanel fieldsPanel = new JPanel();
        fieldsPanel.setLayout(new GridBagLayout());
        fieldsPanel.setBorder(BorderFactory.createTitledBorder(title));
        fieldsPanel.add((Component)PrefFieldsFactory.createPanel(fields), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(2, 5, 2, 10), 0, 0));
        return fieldsPanel;
    }

    protected JPanel encapsuleContent(Component fieldsPanel) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add(fieldsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
        panel.add((Component)new JPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 5, 5, 5), 0, 0));
        return panel;
    }

    protected JPanel makeContent() {
        if (this._perfFieldsPanel == null) {
            this._perfFieldsPanel = this.encapsuleContent(this.makeContent(this._listBooleanPrefs));
        }
        return this._perfFieldsPanel;
    }

    @Override
    public void trash() {
    }

    @Override
    public boolean withOption(Plugable plugable) {
        return true;
    }

    protected void load(Plugable launcher) {
        String opt = launcher.getOption(this.getKey());
        if (opt == null || opt.isEmpty()) {
            return;
        }
        for (PrefFieldBoolean pref : this._listBooleanPrefs) {
            pref.setSelected(false);
        }
        StringTokenizer st = new StringTokenizer(opt, ",");
        while (st.hasMoreTokens()) {
            String keyField = st.nextToken();
            PrefFieldBoolean pref = this.getPref(keyField);
            if (pref == null) {
                _LOG.warning("PrefFieldsCategory::refreshFrom(...) - field inconnu: " + keyField);
                continue;
            }
            pref.setSelected(true);
        }
    }

    protected void save(Plugable launcher) {
        StringBuilder sb = new StringBuilder();
        for (PrefFieldBoolean pref : this._listBooleanPrefs) {
            if (!pref.isSelected()) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(pref.getCode());
        }
        sb.append(",");
        launcher.setOption(this.getKey(), sb.toString());
    }

    @Override
    public PlugPanel displayOption(Plugable launcher) {
        this.load(launcher);
        return this;
    }

    @Override
    public void refreshOptions(Plugable launcher) {
        this.load(launcher);
    }

    @Override
    public boolean validOptions(Plugable launcher) {
        this.save(launcher);
        return true;
    }

    public final PrefFieldsCategory getCopy() {
        Class<?> cl = this.getClass();
        try {
            Constructor<?> constructor = cl.getDeclaredConstructor(new Class[0]);
            PrefFieldsCategory instance = (PrefFieldsCategory)constructor.newInstance(new Object[0]);
            instance.copy(this);
            return instance;
        }
        catch (Exception e) {
            _LOG.severe(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    protected void copy(PrefFieldsCategory src) {
        this._mapBooleanPrefs.clear();
        this._listBooleanPrefs.clear();
        for (Map.Entry<String, PrefFieldBoolean> entry : src._mapBooleanPrefs.entrySet()) {
            PrefFieldBoolean copyField = entry.getValue().getCopy();
            this._mapBooleanPrefs.put(entry.getKey(), copyField);
            this._listBooleanPrefs.add(copyField);
        }
    }
}

