/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.print;

import com.dassault.cecilia.core.cecilia.print.PrintableWordGroup;
import java.awt.Color;
import java.awt.Font;
import java.awt.print.PageFormat;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class PrintableLine
extends JLabel {
    public static final int LINE_LEFT = 0;
    public static final int LINE_CENTER = 1;
    public static final int LINE_RIGHT = 2;
    private Vector _groups = new Vector();
    private int _fontSize;
    private int _alignment;
    private boolean _isTabLine = false;
    private int _headerSize = 0;
    private boolean _isTabSeparatorLine = false;
    private boolean _isBeginTabLine = false;
    private boolean _isColumnHeaderTabLine = false;
    private boolean _isHeaderTabLine = false;
    private boolean _isEmptyTabLine = false;
    private boolean _isEndTabLine = false;
    private boolean _isNewPageLine = false;
    private boolean _addBlankBetweenGroup = true;
    private int _tabColumnCount = 0;
    private int _compareColumnIndex = 0;
    private int _resetColumnIndex = 0;
    private Vector _tabLine = new Vector();
    private Object _styleRtf = null;
    private PageFormat _format;

    public PrintableLine(String line, int fontSize, int alignment) {
        this(line, fontSize);
        this._alignment = alignment;
    }

    public PrintableLine(String line, int fontSize) {
        this._groups.addElement(new PrintableWordGroup(line));
        this._fontSize = fontSize;
        this._alignment = 0;
    }

    public void addLine(PrintableLine line) {
        this._tabLine.addElement(line);
    }

    public int getLineCount() {
        return this._tabLine.size() + 1;
    }

    public Enumeration getLines() {
        return this._tabLine.elements();
    }

    public void setHeaderSize(int size) {
        this._headerSize = size;
    }

    public int getHeaderSize() {
        return this._headerSize;
    }

    public void setTabLine(boolean tab) {
        this._isTabLine = tab;
    }

    public boolean isTabLine() {
        return this._isTabLine;
    }

    public void setTabSeparatorLine() {
        this._isTabSeparatorLine = true;
    }

    public boolean isTabSeparatorLine() {
        return this._isTabSeparatorLine;
    }

    public void setBeginTabLine(boolean tab) {
        this._isBeginTabLine = tab;
    }

    public boolean isBeginTabLine() {
        return this._isBeginTabLine;
    }

    public void setNewPageLine(boolean state) {
        this._isNewPageLine = state;
    }

    public boolean isNewPageLine() {
        return this._isNewPageLine;
    }

    public void setBoldAt(int index, boolean bold) {
        if (index < this._groups.size()) {
            this.getGroupAt(index).setBold(bold);
        }
    }

    public void setColorAt(int index, Color color) {
        if (index < this._groups.size()) {
            this.getGroupAt(index).setColor(color);
        }
    }

    public void setUnderlineAt(int index, boolean underline) {
        if (index < this._groups.size()) {
            this.getGroupAt(index).setUnderline(underline);
        }
    }

    @Override
    public Font getFont() {
        return new Font("Courier New", 0, this._fontSize);
    }

    public PrintableWordGroup getGroupAt(int index) {
        if (index < this._groups.size()) {
            return (PrintableWordGroup)this._groups.elementAt(index);
        }
        return null;
    }

    public PrintableWordGroup addGroup(String string) {
        PrintableWordGroup group = new PrintableWordGroup(string);
        this._groups.addElement(group);
        return group;
    }

    public PrintableWordGroup addGroup(PrintableWordGroup group) {
        this._groups.addElement(group);
        return group;
    }

    public void addGroup(String string, boolean bold) {
        this._groups.addElement(new PrintableWordGroup(string));
        ((PrintableWordGroup)this._groups.lastElement()).setBold(bold);
    }

    public void setPageFormat(PageFormat format) {
        this._format = format;
    }

    public int getWidthAt(int index) {
        PrintableWordGroup group = this.getGroupAt(index);
        return this.getWidth(group);
    }

    public int getWidth(String string) {
        return this.getFontMetrics(this.getFont()).stringWidth(string);
    }

    public int getWidth(PrintableWordGroup group) {
        if (group != null) {
            if (this._addBlankBetweenGroup) {
                return this.getFontMetrics(this.getFont(group)).stringWidth(group.getString());
            }
            return this.getFontMetrics(this.getFont(group)).stringWidth(group.getString());
        }
        return 0;
    }

    public Object getStyleRtf() {
        return this._styleRtf;
    }

    public void setStyleRtf(Object style) {
        this._styleRtf = style;
    }

    public Font getFont(PrintableWordGroup group) {
        if (group != null) {
            if (group.isBold()) {
                return new Font("Courier New", 1, this._fontSize);
            }
            return new Font("Courier New", 0, this._fontSize);
        }
        return null;
    }

    public Font getFontAt(int index) {
        PrintableWordGroup group = this.getGroupAt(index);
        return this.getFont(group);
    }

    public int getOffsetForText() {
        int height = this.getHeight();
        if (height != this.getFontMetrics(this.getFont()).getHeight()) {
            return height;
        }
        return 0;
    }

    public int getNominalHeight() {
        int height = this.getFontMetrics(this.getFont()).getHeight();
        return height;
    }

    @Override
    public int getHeight() {
        Enumeration en = this.getGroups();
        while (en.hasMoreElements()) {
            int h;
            PrintableWordGroup group = (PrintableWordGroup)en.nextElement();
            if (group.getImage() == null || this._format == null) continue;
            ImageIcon imageIcon = group.getImage();
            double width = this._format.getImageableWidth();
            double imgWidth = imageIcon.getIconWidth();
            double imgHeight = imageIcon.getIconHeight();
            if (imgWidth > width) {
                double ratio = width == 0.0 ? 1.0 : width / imgWidth;
                double height = imgHeight * ratio;
                h = (int)height;
            } else {
                h = imageIcon.getIconHeight();
            }
            return h;
        }
        return this.getFontMetrics(this.getFont()).getHeight();
    }

    public int getLength() {
        int length = 0;
        Enumeration en = this.getGroups();
        while (en.hasMoreElements()) {
            PrintableWordGroup group = (PrintableWordGroup)en.nextElement();
            length += group.getString().length();
        }
        return length;
    }

    @Override
    public int getWidth() {
        int width = 0;
        for (int i = 0; i < this._groups.size(); ++i) {
            width += this.getWidthAt(i);
        }
        return width;
    }

    public Enumeration getGroups() {
        return this._groups.elements();
    }

    public int getFontSize() {
        return this._fontSize;
    }

    public int getAlignment() {
        return this._alignment;
    }

    public void setAlignment(int alignment) {
        this._alignment = alignment;
    }

    public int groupCount() {
        return this._groups.size();
    }

    public void setHeaderTabLine(boolean state) {
        this._isHeaderTabLine = state;
    }

    public void setColumnHeaderTabLine(boolean state) {
        this._isColumnHeaderTabLine = state;
    }

    public boolean isColumnHeaderTabLine() {
        return this._isColumnHeaderTabLine;
    }

    public boolean isHeaderTabLine() {
        return this._isHeaderTabLine;
    }

    public void setEmptyTabLine(boolean state) {
        this._isEmptyTabLine = state;
    }

    public boolean isEmptyTabLine() {
        return this._isEmptyTabLine;
    }

    public void setEndTabLine(boolean state) {
        this._isEndTabLine = state;
    }

    public boolean isEndTabLine() {
        return this._isEndTabLine;
    }

    public void setBlankBetweenGroup(boolean state) {
        this._addBlankBetweenGroup = state;
    }

    public boolean addBlankBetweenGroup() {
        return this._addBlankBetweenGroup;
    }

    public void setTabColumnCount(int n) {
        this._tabColumnCount = n;
    }

    public int getTabColumnCount() {
        return this._tabColumnCount;
    }

    public void setCompareColumnIndex(int i) {
        this._compareColumnIndex = i;
    }

    public int getCompareColumnIndex() {
        return this._compareColumnIndex;
    }

    public void setResetColumnIndex(int i) {
        this._resetColumnIndex = i;
    }

    public int getResetColumnIndex() {
        return this._resetColumnIndex;
    }

    @Override
    public String toString() {
        String wordsGroup = "";
        Enumeration en = this.getGroups();
        while (en.hasMoreElements()) {
            PrintableWordGroup group = (PrintableWordGroup)en.nextElement();
            if (group.getWordsOfGroup() != null) {
                Vector groups = group.getWordsOfGroup();
                for (int g = 0; g < groups.size(); ++g) {
                    wordsGroup = wordsGroup.concat(((PrintableWordGroup)groups.elementAt(g)).getString());
                }
                continue;
            }
            wordsGroup = wordsGroup.concat(group.getString());
        }
        return wordsGroup;
    }
}

