/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.print;

import com.dassault.cecilia.core.cecilia.print.ListProcessorJava;
import java.awt.Color;
import java.awt.Font;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class PrintableWordGroup
extends JLabel {
    public static final int emptyBullet = 111;
    public static final int fillBullet = 183;
    public static final int emptyLozenge = 161;
    public static final int fillLozenge = 105;
    private static int ALIGN_LEFT = 0;
    private static int ALIGN_CENTER = 1;
    private static int ALIGN_RIGHT = 2;
    private String _string = "";
    private int[] _glyphs = null;
    private boolean _useGlyphs = false;
    private ImageIcon _image = null;
    private int _alignment;
    private int _width;
    private boolean _isBold;
    private boolean _isUnderline;
    private boolean _isStrike;
    private Color _color = Color.black;
    private boolean _compareToPreview = false;
    private String _fontName = null;
    private Vector _wordsOfGroup = null;
    private Object _fontRtf = null;
    private String _tabRtf = "";

    public PrintableWordGroup(String string) {
        this._string = string;
    }

    public PrintableWordGroup(int[] glyphs) {
        this._useGlyphs = true;
        this._glyphs = glyphs;
    }

    public static PrintableWordGroup getFillLozengeMark() {
        int[] glyphs = new int[]{105};
        PrintableWordGroup wordGroup = new PrintableWordGroup(glyphs);
        wordGroup.setString("i ");
        wordGroup.setFontName("Symbol");
        return wordGroup;
    }

    public static PrintableWordGroup getRtfFillLozengeMark() {
        PrintableWordGroup wordGroup = new PrintableWordGroup("i ");
        wordGroup.setRtfFont(ListProcessorJava.getFont("COURIER_7"));
        return wordGroup;
    }

    public void compareToPreview(boolean compare) {
        this._compareToPreview = compare;
    }

    public boolean compareToPreview() {
        return this._compareToPreview;
    }

    public void setWidth(int width) {
        this._width = width;
    }

    @Override
    public int getWidth() {
        return this._width;
    }

    public int getAlignment() {
        return this._alignment;
    }

    public void setAlignment(char alignment) {
        switch (alignment) {
            case 'L': 
            case 'l': {
                this._alignment = ALIGN_LEFT;
                break;
            }
            case 'R': 
            case 'r': {
                this._alignment = ALIGN_RIGHT;
                break;
            }
            default: {
                this._alignment = ALIGN_CENTER;
            }
        }
    }

    public void setColor(Color color) {
        this._color = color;
    }

    public Color getColor() {
        return this._color;
    }

    public void setFontName(String fontName) {
        this._fontName = fontName;
    }

    public String getFontName() {
        return this._fontName;
    }

    public Font getFont(int fontSize) {
        return new Font(this._fontName, 0, fontSize);
    }

    public void setRtfFont(Object font) {
        this._fontRtf = font;
    }

    public Object getRtfFont() {
        return this._fontRtf;
    }

    public void setRtfTab(String tab) {
        this._tabRtf = tab;
    }

    public String getRtfTab() {
        return this._tabRtf;
    }

    public void setBold(boolean bold) {
        this._isBold = bold;
    }

    public boolean isBold() {
        return this._isBold;
    }

    public void setUnderline(boolean underline) {
        this._isUnderline = underline;
    }

    public boolean isUnderline() {
        return this._isUnderline;
    }

    public void setStrike(boolean strike) {
        this._isStrike = strike;
    }

    public boolean isStrike() {
        return this._isStrike;
    }

    public void setString(String s) {
        this._string = s;
    }

    public String getString() {
        return this._string;
    }

    public void setImage(ImageIcon image) {
        this._image = image;
    }

    public ImageIcon getImage() {
        return this._image;
    }

    public void setWordsOfGroup(Vector wordsOfGroup) {
        this._wordsOfGroup = wordsOfGroup;
    }

    public Vector getWordsOfGroup() {
        return this._wordsOfGroup;
    }

    public int[] getGlyphs() {
        return this._glyphs;
    }

    public boolean useGlyphs() {
        return this._useGlyphs;
    }
}

