/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.stepper;

import com.dassault.cecilia.core.cecilia.stepper.SimStepper;
import com.dassault.cecilia.core.cecilia.stepper.ViewNode;
import javax.swing.tree.TreePath;

public abstract class ViewData
implements ViewNode {
    private int _id;
    private String _name;
    private String _path;
    private ViewData _parent;
    private TreePath _treePath;
    private int _nbrValid;
    private boolean _changeStep;
    private boolean _previousChangeStep;

    public ViewData(String name) {
        this._id = -1;
        this.setName(name);
        this._nbrValid = 0;
    }

    public ViewData(int id, String name) {
        this._id = id;
        this.setName(name);
        this._nbrValid = 0;
    }

    protected void setName(String name) {
        int pos = name.lastIndexOf(46);
        if (pos > 0) {
            this._name = name.substring(pos + 1);
            this._path = name.substring(0, pos);
        } else {
            this._name = name;
            this._path = "";
        }
    }

    public int getId() {
        return this._id;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public String getFinalName() {
        if (this._path.length() == 0) {
            return this._name;
        }
        return this._path + "." + this._name;
    }

    public String getPath() {
        return this._path;
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public ViewNode getChildAt(int idx) {
        return null;
    }

    protected void setParent(ViewData parent) {
        this._parent = parent;
    }

    public ViewData getParent() {
        return this._parent;
    }

    public int getNbrValid() {
        return this._nbrValid;
    }

    protected void changeNbrValid(int incValid) {
        this._changeStep = true;
        this._nbrValid += incValid;
        if (this._parent != null) {
            this._parent.changeNbrValid(incValid);
        }
    }

    public boolean isChanged() {
        return this._changeStep;
    }

    public boolean isPreviousChanged() {
        return this._previousChangeStep;
    }

    protected void change() {
        if (this._changeStep) {
            return;
        }
        this._changeStep = true;
        if (this._parent != null) {
            this._parent.change();
        }
    }

    public void setPreviousChanged() {
        this._previousChangeStep = this._changeStep;
        this._changeStep = false;
    }

    public abstract void refreshChanged(SimStepper var1, boolean var2);

    public TreePath getTreePath() {
        if (this._treePath == null) {
            this._treePath = this.createTreePath();
        }
        return this._treePath;
    }

    public TreePath getTreePathUntil(ViewData parent) {
        int cpt = 0;
        ViewData current = this;
        while (current != parent) {
            if (current == null) {
                return null;
            }
            current = current._parent;
            ++cpt;
        }
        Object[] currentPath = new Object[cpt + 1];
        current = this;
        while (cpt > 0) {
            currentPath[cpt] = current;
            current = current._parent;
            --cpt;
        }
        currentPath[0] = parent;
        return new TreePath(currentPath);
    }

    private TreePath createTreePath() {
        if (this._parent != null) {
            int cpt = 0;
            ViewData current = this;
            while (current != null) {
                current = current._parent;
                ++cpt;
            }
            Object[] currentPath = new Object[cpt];
            current = this;
            while (cpt > 0) {
                currentPath[cpt - 1] = current;
                current = current._parent;
                --cpt;
            }
            return new TreePath(currentPath);
        }
        return new TreePath(this);
    }

    public void sortChild() {
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean findWithInstance(Class type) {
        return type.isInstance(this);
    }
}

