/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.stepper;

import com.dassault.cecilia.core.cecilia.stepper.SimStepper;
import com.dassault.cecilia.core.cecilia.stepper.ViewData;
import com.dassault.cecilia.core.cecilia.stepper.ViewNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class ViewFolder
extends ViewData {
    private int _depth = 1;
    private ArrayList<ViewData> _children = new ArrayList();
    static Comparator __compareNode = null;

    public ViewFolder(String name) {
        super(name);
    }

    @Override
    public int getDepth() {
        return this._depth;
    }

    public void setDepth(int depth) {
        this._depth = depth;
    }

    @Override
    public int getChildCount() {
        return this._children.size();
    }

    @Override
    public ViewNode getChildAt(int idx) {
        return this._children.get(idx);
    }

    public void addChild(ViewData child) {
        this._children.add(child);
        child.setParent(this);
    }

    public ViewNode getChild(String name, boolean nofolder) {
        for (int i = 0; i < this._children.size(); ++i) {
            ViewNode child = this.getChildAt(i);
            if (!child.getName().equals(name) || nofolder && child instanceof ViewFolder) continue;
            return child;
        }
        return null;
    }

    public ViewFolder getChildFolder(String name) {
        for (int i = 0; i < this._children.size(); ++i) {
            ViewNode child = this.getChildAt(i);
            if (!child.getName().equals(name) || !(child instanceof ViewFolder)) continue;
            return (ViewFolder)child;
        }
        return null;
    }

    @Override
    public void sortChild() {
        if (this._children == null) {
            return;
        }
        if (this._children.size() < 2) {
            return;
        }
        if (__compareNode == null) {
            __compareNode = new Comparator(){

                public int compare(Object o1, Object o2) {
                    ViewData n1 = (ViewData)o1;
                    ViewData n2 = (ViewData)o2;
                    int diffDepth = n2.getDepth() - n1.getDepth();
                    if (diffDepth != 0) {
                        return diffDepth;
                    }
                    return n1.getName().compareTo(n2.getName());
                }
            };
        }
        Collections.sort(this._children, __compareNode);
        Iterator<ViewData> i = this._children.iterator();
        while (i.hasNext()) {
            i.next().sortChild();
        }
    }

    public ViewFolder createPath(String path) {
        if (path.length() == 0) {
            return this;
        }
        int pos = path.indexOf(46);
        if (pos >= 0) {
            assert (pos > 0) : path;
            ViewFolder nde = this.getChildFolder(path.substring(0, pos));
            if (nde == null) {
                nde = new ViewFolder(path.substring(0, pos));
                this.addChild(nde);
            }
            nde.setDepth(2);
            return nde.createPath(path.substring(pos + 1));
        }
        ViewFolder nde = this.getChildFolder(path);
        if (nde == null) {
            nde = new ViewFolder(path);
            this.addChild(nde);
        }
        return nde;
    }

    public ViewData getData(String path, boolean nofolder) {
        if (path.length() == 0) {
            return this;
        }
        int pos = path.indexOf(46);
        if (pos >= 0) {
            assert (pos > 0) : path;
            ViewNode nde = this.getChild(path.substring(0, pos), false);
            if (nde == null || !(nde instanceof ViewFolder)) {
                return null;
            }
            return ((ViewFolder)nde).getData(path.substring(pos + 1), nofolder);
        }
        ViewNode nde = this.getChild(path, nofolder);
        if (nde == null || !(nde instanceof ViewData)) {
            return null;
        }
        return (ViewData)nde;
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public void setPreviousChanged() {
        super.setPreviousChanged();
        for (int i = 0; i < this._children.size(); ++i) {
            this._children.get(i).setPreviousChanged();
        }
    }

    @Override
    public void refreshChanged(SimStepper stepper, boolean razChange) {
        for (int i = 0; i < this._children.size(); ++i) {
            this._children.get(i).refreshChanged(stepper, razChange);
        }
    }

    @Override
    public boolean findWithInstance(Class type) {
        if (super.findWithInstance(type)) {
            return true;
        }
        for (int i = 0; i < this._children.size(); ++i) {
            ViewData data = this._children.get(i);
            if (!data.findWithInstance(type)) continue;
            return true;
        }
        return false;
    }
}

