/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.stepper.view;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.cecilia.stepper.ViewNode;
import com.dassault.cecilia.core.cecilia.stepper.ViewTransition;
import com.dassault.cecilia.core.cecilia.stepper.ViewVariable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class TreeRenderedNode
extends DefaultTreeCellRenderer {
    private Font plainFont = null;
    private Font boldFont = null;
    private HashMap<Integer, Icon> _icons = null;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
        int depth;
        Icon icon;
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, focus);
        if (this.plainFont == null) {
            this.plainFont = this.getFont();
            if (this.plainFont != null) {
                this.boldFont = this.plainFont.deriveFont(1);
            }
        }
        if (this._icons == null) {
            this._icons = new HashMap();
            this._icons.put(3, ResIcoCore.getImageIcon("FOLDER_GRAPH_"));
            this._icons.put(2, ResIcoCore.getImageIcon("FOLDER_EQUIPMENT_"));
            this._icons.put(1, ResIcoCore.getImageIcon("FOLDER_COMPONENT_"));
            this._icons.put(0, ResIcoCore.getImageIcon("MBSA_VALUE"));
            this._icons.put(-1, ResIcoCore.getImageIcon("MBSA_EVENT"));
            this._icons.put(-2, ResIcoCore.getImageIcon("MBSA_STATE"));
            this._icons.put(-3, ResIcoCore.getImageIcon("MBSA_FLOW"));
        }
        if (value instanceof ViewTransition) {
            ViewTransition tr = (ViewTransition)value;
            this.setFont(tr.isValid() ? this.boldFont : this.plainFont);
        } else {
            this.setFont(this.plainFont);
        }
        if (value instanceof ViewNode && (icon = this._icons.get(depth = ((ViewNode)value).getDepth())) != null) {
            this.setIcon(icon);
        }
        if (value instanceof ViewVariable) {
            ViewVariable var = (ViewVariable)value;
            this.setForeground(var.isChanged() ? Color.blue : Color.black);
            StringBuffer sb = new StringBuffer(32);
            sb.append(value);
            sb.append("\t= ");
            sb.append(var.getSValue());
            this.setText(sb.toString());
        }
        return this;
    }
}

