/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.user;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.cecilia.user.User;
import com.dassault.cecilia.db.DBUser;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;

public class UserRenderer
extends DefaultTableCellRenderer
implements ListCellRenderer {
    boolean _bWithIcon = true;

    public UserRenderer setWithIcon(boolean with) {
        this._bWithIcon = with;
        return this;
    }

    private void setIconAndText(Object value) {
        if (value == null) {
            this.setIcon(null);
            this.setText(null);
            return;
        }
        if (value instanceof User) {
            this.setText(((User)value).getName());
        } else if (value instanceof DBUser) {
            this.setText(((DBUser)value).getLogin());
        } else {
            this.setText(value.toString());
        }
        if (value instanceof User) {
            String tt = ((User)value).getDescription();
            if (tt != null && tt.length() == 0) {
                tt = null;
            }
            this.setToolTipText(tt);
            if (this._bWithIcon) {
                if (((User)value).isAdmin()) {
                    this.setIcon(ResIcoCore.getImageIcon("SES_ADMIN"));
                } else {
                    this.setIcon(ResIcoCore.getImageIcon("SES_USER"));
                }
            }
        } else if (value instanceof DBUser) {
            DBUser user = (DBUser)value;
            StringBuffer tt = new StringBuffer();
            tt.append(user.getName());
            String desc = user.getDescription();
            if (desc != null && desc.length() > 0) {
                tt.append(" - ").append(desc);
            }
            this.setToolTipText(tt.toString());
            if (this._bWithIcon) {
                if (user.isAdmin()) {
                    this.setIcon(ResIcoCore.getImageIcon("SES_ADMIN"));
                } else {
                    this.setIcon(ResIcoCore.getImageIcon("SES_USER"));
                }
            }
        } else if (this._bWithIcon) {
            this.setIcon(null);
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setEnabled(list.isEnabled());
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setFont(list.getFont());
        this.setIconAndText(value);
        return this;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setEnabled(table.isEnabled());
        this.setIconAndText(value);
        return this;
    }
}

