/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.plugin;

import com.dassault.cecilia.core.plugin.InfoDatum;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public abstract class AbstractInfoDatum
implements InfoDatum {
    private static Logger _LOG = Logger.getLogger(AbstractInfoDatum.class.getPackage().getName());
    protected String _key;
    protected Map<String, String> _parameters;
    protected Map<String, File> _files;
    protected Map<String, Object> _objects;

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append(this.getKey()).append("[");
        sb.append("files:").append(this._files.size());
        sb.append("params:").append(this._parameters.size());
        sb.append("]@");
        sb.append(Integer.toHexString(this.hashCode()));
        return sb.toString();
    }

    protected AbstractInfoDatum() {
        this._parameters = new LinkedHashMap<String, String>();
        this._files = new LinkedHashMap<String, File>();
        this._objects = Collections.emptyMap();
        this._key = null;
    }

    public AbstractInfoDatum(InfoDatum isource) {
        this._parameters = new LinkedHashMap<String, String>(isource.getParameters());
        this._files = new LinkedHashMap<String, File>(isource.getInputFiles());
        this._objects = Collections.emptyMap();
        this._key = isource.getKey();
    }

    public AbstractInfoDatum(String key) {
        this();
        this._key = key;
        this._parameters.put("Key", key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractInfoDatum(InputStream stream) throws IOException {
        this._parameters = new LinkedHashMap<String, String>();
        this._files = new LinkedHashMap<String, File>();
        this._objects = Collections.emptyMap();
        this._key = null;
        ZipInputStream zipStream = new ZipInputStream(stream);
        ZipEntry entry = null;
        while ((entry = zipStream.getNextEntry()) != null) {
            if (entry.getName().equals("Information")) {
                DataInputStream input = new DataInputStream(zipStream);
                try {
                    try {
                        while (true) {
                            String key = input.readUTF();
                            String value = input.readUTF();
                            this._parameters.put(key, value);
                            if (this._key != null || !key.equals("Key")) continue;
                            this._key = value;
                        }
                    }
                    catch (EOFException key) {
                        zipStream.closeEntry();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    zipStream.closeEntry();
                    throw throwable;
                }
            }
            String name = entry.getName();
            File file = File.createTempFile((this._key.startsWith("<?xml") ? "Tree." : this._key) + name, ".aid");
            file.deleteOnExit();
            OutputStream outStream = null;
            try {
                outStream = new BufferedOutputStream(new FileOutputStream(file));
                BufferedInputStream in = new BufferedInputStream(zipStream);
                byte[] read = new byte[1024];
                int len = 1024;
                while ((len = in.read(read)) > 0) {
                    outStream.write(read, 0, len);
                }
                outStream.flush();
            }
            finally {
                if (outStream != null) {
                    outStream.close();
                }
                zipStream.closeEntry();
            }
            this._files.put(name, file);
        }
        if (this._key == null) {
            throw new IOException("Il n'y a sans doute pas d'entre de type 'Information' dans le fichier zip");
        }
    }

    @Override
    public String getKey() {
        return this._key;
    }

    @Override
    public Map<String, String> getParameters() {
        return this._parameters;
    }

    @Override
    public Map<String, File> getInputFiles() {
        return this._files;
    }

    @Override
    public Map<String, Object> getObjects() {
        return this._objects;
    }

    protected abstract boolean fileException(String var1);

    public void clean() {
        for (Map.Entry<String, File> entry : this._files.entrySet()) {
            if (this.fileException(entry.getKey())) continue;
            entry.getValue().delete();
        }
    }

    protected boolean verifyInformations(Map<String, String> params) {
        if (params.get("CRC") == null) {
            return false;
        }
        return params.get("Key") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generateData() {
        Map<String, String> params = this.getParameters();
        if (!this.verifyInformations(params)) {
            return null;
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(4096);
        ZipOutputStream zipStream = new ZipOutputStream(outStream);
        try {
            ZipEntry infoEntry = new ZipEntry("Information");
            zipStream.putNextEntry(infoEntry);
            DataOutputStream dataOutputStream = new DataOutputStream(zipStream);
            try {
                for (Map.Entry<String, String> param : params.entrySet()) {
                    dataOutputStream.writeUTF(param.getKey());
                    dataOutputStream.writeUTF(param.getValue());
                }
            }
            finally {
                zipStream.closeEntry();
            }
            for (Map.Entry entry : this.getInputFiles().entrySet()) {
                if (this.fileException((String)entry.getKey())) continue;
                ZipEntry infoEntry2 = new ZipEntry((String)entry.getKey());
                zipStream.putNextEntry(infoEntry2);
                InputStream in = null;
                try {
                    BufferedOutputStream out = new BufferedOutputStream(zipStream);
                    in = new BufferedInputStream(new FileInputStream((File)entry.getValue()));
                    byte[] read = new byte[1024];
                    int len = 1024;
                    while ((len = in.read(read)) > 0) {
                        out.write(read, 0, len);
                    }
                    out.flush();
                }
                finally {
                    zipStream.closeEntry();
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        catch (IOException ioe) {
            _LOG.log(Level.WARNING, "Probleme lors de la sauvegarde des donnees", ioe);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                zipStream.close();
            }
            catch (IOException e) {
                _LOG.log(Level.WARNING, "Probleme lors de la fermeture du flux", e);
            }
        }
        return outStream.toByteArray();
    }
}

