/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.plugin;

import com.dassault.cecilia.core.plugin.AbstractPluginModel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.ResPlug;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.ban.BanInputStream;
import com.dassault.cecilia.lib.ban.BanLicenseException;
import com.dassault.cecilia.lib.ban.BanProcessException;
import java.io.File;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.xml.sax.Locator;

public abstract class AbstractPluginModelBan
extends AbstractPluginModel {
    private static Logger _LOG = Logger.getLogger(AbstractPluginModelBan.class.getPackage().getName());
    protected BanEntry _ban = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BanEntry banExecute(Plugable launcher, BanEntry previous, Object ... objects) {
        try {
            this._ban = previous != null ? new BanEntry(previous) : new BanEntry();
        }
        catch (BanLicenseException e) {
            this.showErrorMessage(launcher, "ERR_BAN_LICENSE", e, new Object[0]);
            return this._ban;
        }
        try {
            this.prepareBanEntry(launcher, objects);
            File file = this.getBanScript();
            if (file != null) {
                this._ban.execute(file);
            } else {
                BanInputStream stream = new BanInputStream(this.getStreamOfBanScript(), this.getNameOfBanScript());
                this._ban.execute(stream);
            }
            BanEntry banEntry = this._ban;
            return banEntry;
        }
        catch (BanProcessException e) {
            this.catchBanException(launcher, e, objects);
        }
        catch (Throwable e) {
            this.showErrorMessage(launcher, "ERR_BAN_LAUNCH", e, new Object[0]);
            _LOG.log(Level.INFO, "Soucis dans l'execution de la tache Ban", e);
        }
        finally {
            this._ban = null;
        }
        return null;
    }

    protected BanEntry getBanEntry() {
        return this._ban;
    }

    protected void catchBanException(Plugable launcher, BanProcessException e, Object ... objects) {
        Locator loc;
        Throwable exc = e;
        if (e.getException() != null) {
            exc = e.getException();
        }
        if ((loc = e.getLocator()) != null) {
            StringBuffer sb = new StringBuffer(128);
            sb.append("BanScript exception : localise=\"");
            String sys = loc.getSystemId();
            if (sys != null) {
                int pos = sys.lastIndexOf("/");
                if (pos == -1) {
                    pos = sys.lastIndexOf("\\");
                }
                if (pos == sys.length()) {
                    pos = -1;
                }
                sb.append(sys.substring(pos + 1));
                sb.append(":");
            }
            sb.append(loc.getLineNumber());
            sb.append("\"");
            _LOG.log(Level.INFO, sb.toString(), exc);
        }
        this.showErrorMessage(launcher, "ERR_BAN_LAUNCH", exc, new Object[0]);
    }

    protected abstract void prepareBanEntry(Plugable var1, Object ... var2);

    protected abstract InputStream getStreamOfBanScript();

    protected abstract String getNameOfBanScript();

    protected abstract File getBanScript();

    protected void showErrorMessage(Plugable launcher, String key, Throwable e, Object ... objects) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("<html>");
        sb.append("<b>").append(ResPlug.getString(key)).append("</b><br>");
        if (e != null) {
            sb.append("<i>");
            sb.append(e.getClass().getName());
            sb.append("</i><ul style=\"list-style-type: none;\">");
            String emsg = e.getMessage();
            if (emsg == null) {
                emsg = e.getClass().getName();
            }
            StringTokenizer st = new StringTokenizer(emsg, "\n");
            while (st.hasMoreTokens()) {
                sb.append("<li>");
                String msg = st.nextToken();
                boolean first = true;
                while (msg.length() > 160) {
                    if (!first) {
                        sb.append("<li>");
                    }
                    sb.append(msg.substring(0, 160));
                    msg = msg.substring(160);
                    if (first) {
                        first = false;
                        sb.append(" ...<ul style=\"list-style-type: none;\">");
                        continue;
                    }
                    sb.append("    ...");
                }
                if (!first) {
                    sb.append("    ...<li>");
                }
                sb.append(msg);
                if (first) continue;
                sb.append("</ul>");
            }
            sb.append("</ul>");
        }
        for (int i = 0; i < objects.length; ++i) {
            sb.append("<br>").append(objects[i].toString());
        }
        sb.append("</html>");
        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(launcher.getWindow()), sb.toString(), ResPlug.getString("DEF_TITLE"), 0);
    }
}

