/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.plugin;

import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.lib.util.logging.LogUtility;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DefaultIOParameters
implements IOParameters {
    public static final String KEY_DEFAULT = "params";
    private static final String CODE_STR = "String";
    private static final String CODE_BYT = "Byte";
    private static final String CODE_DBL = "Double";
    private static final String CODE_FLT = "Float";
    private static final String CODE_INT = "Integer";
    private static final String CODE_LNG = "Long";
    private static final String CODE_SHT = "Short";
    private static final String CODE_LST = "List";
    protected static DefaultIOParameters _instance = null;

    private Object readParam(String txt) {
        int beg = txt.indexOf(91);
        int end = txt.lastIndexOf(93);
        if (beg == -1 || end == -1) {
            return null;
        }
        String key = txt.substring(0, beg);
        String value = txt.substring(beg + 1, end);
        if (CODE_STR.equals(key)) {
            return DefaultIOParameters.fromXML(value);
        }
        if (CODE_BYT.equals(key)) {
            return Byte.valueOf(value);
        }
        if (CODE_DBL.equals(key)) {
            return Double.valueOf(value);
        }
        if (CODE_FLT.equals(key)) {
            return Float.valueOf(value);
        }
        if (CODE_INT.equals(key)) {
            return Integer.valueOf(value);
        }
        if (CODE_LNG.equals(key)) {
            return Long.valueOf(value);
        }
        if (CODE_SHT.equals(key)) {
            return Short.valueOf(value);
        }
        if (CODE_LST.equals(key)) {
            ArrayList<Object> lst = new ArrayList<Object>();
            if (value.length() > 0) {
                Object res;
                int pos = value.indexOf(58);
                while (pos != -1) {
                    res = this.readParam(value.substring(0, pos));
                    if (res != null) {
                        lst.add(res);
                    }
                    value = value.substring(pos + 1);
                    pos = value.indexOf(58);
                }
                res = this.readParam(value);
                if (res != null) {
                    lst.add(res);
                }
            }
            return lst;
        }
        return null;
    }

    @Override
    public Object readXML(Node node, PluginManager launcher) {
        if (node.getNodeType() != 1) {
            return null;
        }
        Element root = (Element)node;
        if (!root.getNodeName().equals(KEY_DEFAULT)) {
            return null;
        }
        String txt = root.getTextContent();
        return this.readParam(txt);
    }

    @Override
    public void writeXML(Writer out, Object parameters, PluginManager launcher) throws IOException {
        out.write("<");
        out.write(KEY_DEFAULT);
        out.write(">");
        this.defWriteXML(out, parameters);
        out.write("</");
        out.write(KEY_DEFAULT);
        out.write(">");
    }

    private void defWriteXML(Writer out, Object parameters) throws IOException {
        if (parameters instanceof String) {
            out.write("String[");
            out.write(DefaultIOParameters.toXML((String)parameters));
            out.write("]");
        } else if (parameters instanceof Number) {
            if (parameters instanceof Byte) {
                out.write(CODE_BYT);
            } else if (parameters instanceof Double) {
                out.write(CODE_DBL);
            } else if (parameters instanceof Float) {
                out.write(CODE_FLT);
            } else if (parameters instanceof Integer) {
                out.write(CODE_INT);
            } else if (parameters instanceof Long) {
                out.write(CODE_LNG);
            } else if (parameters instanceof Short) {
                out.write(CODE_SHT);
            } else {
                throw new IOException("Unsupported object for DefaultIOParameter");
            }
            out.write("[");
            out.write(parameters.toString());
            out.write("]");
        } else if (parameters instanceof List) {
            out.write("List[");
            Iterator i = ((List)parameters).iterator();
            while (i.hasNext()) {
                this.defWriteXML(out, i.next());
                if (!i.hasNext()) continue;
                out.write(":");
            }
            out.write("]");
        } else {
            throw new IOException("Unsupported object for DefaultIOParameter");
        }
    }

    public static String toXML(String st) {
        StringBuffer xmlString = new StringBuffer("");
        char curCar = ' ';
        block13: for (int i = 0; i < st.length(); ++i) {
            curCar = st.charAt(i);
            switch (curCar) {
                case '&': {
                    xmlString.append("&amp;");
                    continue block13;
                }
                case '<': {
                    xmlString.append("&lt;");
                    continue block13;
                }
                case '>': {
                    xmlString.append("&gt;");
                    continue block13;
                }
                case '\'': {
                    xmlString.append("&apos;");
                    continue block13;
                }
                case '\"': {
                    xmlString.append("&quot;");
                    continue block13;
                }
                case ':': {
                    xmlString.append("&#x003A;");
                    continue block13;
                }
                case '[': {
                    xmlString.append("&#x005B;");
                    continue block13;
                }
                case ']': {
                    xmlString.append("&#x005D;");
                    continue block13;
                }
                case '\\': {
                    xmlString.append("\\\\");
                    continue block13;
                }
                case '\n': {
                    xmlString.append("\\n");
                    continue block13;
                }
                case '\t': {
                    xmlString.append("\\t");
                    continue block13;
                }
                default: {
                    xmlString.append(curCar);
                }
            }
        }
        return xmlString.toString();
    }

    private static void replace(StringBuffer buf, String find, String repl) {
        int pos = buf.indexOf(find);
        while (pos != -1) {
            buf.replace(pos, pos + find.length(), repl);
            pos = buf.indexOf(find);
        }
    }

    public static String fromXML(String st) {
        StringBuffer strBuf = new StringBuffer(st);
        DefaultIOParameters.replace(strBuf, "&lt;", "<");
        DefaultIOParameters.replace(strBuf, "&gt;", ">");
        DefaultIOParameters.replace(strBuf, "&apos;", "'");
        DefaultIOParameters.replace(strBuf, "&quot;", "\"");
        DefaultIOParameters.replace(strBuf, "&#x003A;", ":");
        DefaultIOParameters.replace(strBuf, "&#x005B;", "[");
        DefaultIOParameters.replace(strBuf, "&#x005D;", "]");
        DefaultIOParameters.replace(strBuf, "&amp;", "&");
        int pos = strBuf.indexOf("\\");
        while (pos != -1) {
            char car = strBuf.charAt(pos + 1);
            switch (car) {
                case 'n': {
                    strBuf.replace(pos, pos + 2, "\n");
                    break;
                }
                case 't': {
                    strBuf.replace(pos, pos + 2, "\t");
                    break;
                }
                case '\\': {
                    strBuf.replace(pos, pos + 2, "\\");
                    break;
                }
                default: {
                    LogUtility.logStackTrace((Logger)LogUtility.getLog(DefaultIOParameters.class), (Level)Level.FINER, (String)("XMLEscape unknow : " + car));
                    strBuf.replace(pos, pos + 1, "");
                }
            }
            if (pos + 1 < strBuf.length()) {
                pos = strBuf.indexOf("\\", pos + 1);
                continue;
            }
            pos = -1;
        }
        return strBuf.toString();
    }

    public static DefaultIOParameters getInstance() {
        if (_instance == null) {
            _instance = new DefaultIOParameters();
        }
        return _instance;
    }
}

