/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.pluginmanager;

import com.dassault.cecilia.core.pluginmanager.Messages;
import com.dassault.cecilia.core.pluginmanager.PluginManager;
import com.dassault.cecilia.core.pluginmanager.PluginManagerPanel;
import com.dassault.cecilia.core.pluginmanager.ResourceAccessor;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.util.io.FileUtility;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.filechooser.FileFilter;

public class EditMenuDlg
extends JDialog {
    private JLabel _lblLabel = new JLabel(Messages.getString("EditMenuDlg.0"));
    private JLabel _lblIconPath = new JLabel(Messages.getString("EditMenuDlg.1"));
    private JTextField _tfLabel = new JTextField(30);
    private JLabel _lblIcon = new JLabel();
    private JTextField _tfIconPath = new JTextField();
    private JButton _bIconPath = new JButton(Messages.getString("EditMenuDlg.2"));
    private JButton _bOk = new JButton(Messages.getString("EditMenuDlg.3"));
    private JButton _bCancel = new JButton(Messages.getString("EditMenuDlg.4"));
    private boolean _ok = false;
    private PluginManager _pluginManager;
    private PluginManagerPanel _pluginMgrPnl;
    private String _currentLabel;

    EditMenuDlg(Frame owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.init();
    }

    public EditMenuDlg(Dialog owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.init();
    }

    public boolean isOk() {
        return this._ok;
    }

    public void setData(PluginManager pluginManager, String label, String iconPath, PluginManagerPanel pluginMgrPnl) {
        this._pluginManager = pluginManager;
        this._pluginMgrPnl = pluginMgrPnl;
        this.setLabel(label == null ? "" : label);
        this.setIconPath(iconPath);
        this.setIcon(this.getIcon(iconPath));
        this._currentLabel = label;
        this._bOk.setEnabled(this._currentLabel != null);
    }

    private Icon getIcon(String iconPath) {
        ImageIcon icon;
        if (iconPath != null && (icon = new ImageIcon(iconPath)) != null && icon.getIconWidth() != -1 && icon.getIconHeight() != -1) {
            return icon;
        }
        URL url = ResourceAccessor.getInstance().getResource("vide_pi");
        ImageIcon icon2 = url == null ? null : new ImageIcon(url);
        return icon2;
    }

    public String getIconPath() {
        return this._tfIconPath.getText();
    }

    public void setIconPath(String iconPath) {
        this._tfIconPath.setText(iconPath);
    }

    public void setIcon(Icon icon) {
        if (icon != null) {
            this._lblIcon.setIcon(icon);
        }
    }

    public Icon getIcon() {
        return this._lblIcon.getIcon();
    }

    public String getLabel() {
        return this._tfLabel.getText();
    }

    public void setLabel(String label) {
        this._tfLabel.setText(label);
    }

    public void setVisibleInFrame() {
        this.pack();
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
        this.dispose();
    }

    private void init() {
        this.make();
        this.defineListeners();
        this.pack();
    }

    private void make() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.makeItemPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 5, 0), 0, 0));
        panel.add((Component)new JSeparator(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 5, 10), 0, 0));
        panel.add((Component)this.makeButtonPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        panel.getActionMap().put("CLOSE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditMenuDlg.this._bCancel.doClick();
            }
        });
        panel.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "CLOSE");
        panel.getActionMap().put("VALIDATE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditMenuDlg.this._bOk.isEnabled()) {
                    EditMenuDlg.this._bOk.doClick();
                }
            }
        });
        panel.getInputMap(2).put(KeyStroke.getKeyStroke("ENTER"), "VALIDATE");
        this.getContentPane().add(panel);
    }

    private JPanel makeItemPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this._lblLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 5, 10), 0, 0));
        panel.add((Component)this._lblIconPath, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0));
        panel.add((Component)this._tfLabel, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 5, 10), 0, 0));
        panel.add((Component)this._lblIcon, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 0), 0, 0));
        panel.add((Component)this._tfIconPath, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 10), 0, 0));
        panel.add((Component)this._bIconPath, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0));
        this._lblIcon.setPreferredSize(new Dimension(25, 20));
        this._lblIcon.setMaximumSize(new Dimension(25, 20));
        this._lblIcon.setMinimumSize(new Dimension(25, 20));
        return panel;
    }

    private JPanel makeButtonPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this._bOk, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 10, 10, 10), 0, 0));
        panel.add((Component)this._bCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 10, 10), 0, 0));
        return panel;
    }

    private void defineListeners() {
        this._bIconPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final String[] ext = new String[]{"bmp", "gif", "jpg", "jpeg", "wav"};
                File selectFile = null;
                if (EditMenuDlg.this.getIconPath().length() == 0 || !(selectFile = new File(EditMenuDlg.this.getIconPath())).exists()) {
                    selectFile = new File(".");
                }
                JFileChooser chooser = new JFileChooser(selectFile);
                chooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        if (file.isDirectory()) {
                            return true;
                        }
                        if (file.isHidden()) {
                            return false;
                        }
                        String path = file.getAbsolutePath();
                        int idx = path.lastIndexOf(".");
                        if (idx == -1) {
                            return true;
                        }
                        String extension = path.substring(idx + 1);
                        for (int i = 0; i < ext.length; ++i) {
                            if (!extension.equalsIgnoreCase(ext[i])) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public String getDescription() {
                        StringBuffer b = new StringBuffer();
                        b.append(Messages.getString("EditMenuDlg.5") + " (");
                        for (int i = 0; i < ext.length; ++i) {
                            b.append("*.").append(ext[i]).append(", ");
                        }
                        b.deleteCharAt(b.length() - 1);
                        b.deleteCharAt(b.length() - 1);
                        b.append(")");
                        return b.toString();
                    }
                });
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 1) {
                    return;
                }
                String pluginPath = EditMenuDlg.this._pluginManager.getPluginPath();
                String path = FileUtility.getDiffPath((String)pluginPath, (String)chooser.getSelectedFile().getAbsolutePath());
                EditMenuDlg.this.setIconPath(path);
                EditMenuDlg.this.setIcon(EditMenuDlg.this.getIcon(path));
            }
        });
        this._bOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditMenuDlg.this._ok = true;
                EditMenuDlg.this.setVisible(false);
            }
        });
        this._bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditMenuDlg.this._ok = false;
                EditMenuDlg.this.setVisible(false);
            }
        });
        this._tfLabel.addCaretListener(new ValidateListener());
        this._tfLabel.addKeyListener(new ValidateListener());
        this._tfIconPath.addCaretListener(new UpdateIconPathListener());
        this._tfIconPath.addKeyListener(new UpdateIconPathListener());
    }

    class ValidateListener
    implements KeyListener,
    CaretListener {
        ValidateListener() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            this.validate();
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.validate();
        }

        public void validate() {
            EditMenuDlg.this._bOk.setEnabled(true);
            if (EditMenuDlg.this._tfLabel.getText().length() == 0) {
                EditMenuDlg.this._bOk.setEnabled(false);
            } else if (EditMenuDlg.this._currentLabel == null && EditMenuDlg.this._pluginMgrPnl.isMenuNameAlreadyExit(EditMenuDlg.this._tfLabel.getText())) {
                EditMenuDlg.this._bOk.setEnabled(false);
            } else if (!EditMenuDlg.this._tfLabel.getText().equals(EditMenuDlg.this._currentLabel) && EditMenuDlg.this._pluginMgrPnl.isMenuNameAlreadyExit(EditMenuDlg.this._tfLabel.getText())) {
                EditMenuDlg.this._bOk.setEnabled(false);
            }
        }
    }

    class UpdateIconPathListener
    implements CaretListener,
    KeyListener {
        UpdateIconPathListener() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            EditMenuDlg.this.setIcon(EditMenuDlg.this.getIcon(EditMenuDlg.this._tfIconPath.getText()));
        }

        @Override
        public void keyReleased(KeyEvent e) {
            EditMenuDlg.this.setIcon(EditMenuDlg.this.getIcon(EditMenuDlg.this._tfIconPath.getText()));
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }
    }
}

