/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.pluginmanager;

import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.core.pluginmanager.Messages;
import com.dassault.cecilia.core.pluginmanager.PluginAction;
import com.dassault.cecilia.core.pluginmanager.PluginDescriptor;
import com.dassault.cecilia.core.pluginmanager.PluginManager;
import com.dassault.cecilia.core.pluginmanager.ResourceAccessor;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.util.io.FileUtility;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.filechooser.FileFilter;

class EditPluginActionDlg
extends JDialog
implements com.dassault.cecilia.core.plugin.PluginManager {
    private static final Logger _LOG = Logger.getLogger(PluginManager.class.getPackage().getName());
    private JLabel _lblLabel = new JLabel(Messages.getString("EditPluginActionDlg.0"));
    private JLabel _lblIconPath = new JLabel(Messages.getString("EditPluginActionDlg.1"));
    private JLabel _lblTooltip = new JLabel(Messages.getString("EditPluginActionDlg.2"));
    private JLabel _lblShortcut = new JLabel(Messages.getString("EditPluginActionDlg.3"));
    private JTextField _tfLabel = new JTextField(30);
    private JLabel _lblIcon = new JLabel();
    private JTextField _tfIconPath = new JTextField();
    private JButton _bIconPath = new JButton(Messages.getString("EditPluginActionDlg.4"));
    private JTextField _tfTooltip = new JTextField();
    private JTextField _tfShortcut = new JTextField();
    private JButton _bParameters = new JButton(Messages.getString("EditPluginActionDlg.5"));
    private JButton _bOk = new JButton(Messages.getString("EditPluginActionDlg.6"));
    private JButton _bCancel = new JButton(Messages.getString("EditPluginActionDlg.7"));
    private boolean _ok = false;
    private PluginAction _action;
    private Object _parameters;
    private PluginManager _pluginManager;
    private Set _alreadyUsedNames = new TreeSet();

    EditPluginActionDlg(Frame owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.init();
    }

    public EditPluginActionDlg(Dialog owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.init();
    }

    public boolean isOk() {
        return this._ok;
    }

    public void setData(PluginManager pluginManager, PluginAction action, Set alreadyUsedNames) {
        this._pluginManager = pluginManager;
        this._action = action;
        this._alreadyUsedNames = alreadyUsedNames;
        this._parameters = action.getParameters();
        PluginModel plugin = pluginManager.getPlugin(action.getPluginKey());
        this.setLabel(action.getName());
        this.setShortcut(action.getShortcut());
        this.setTooltip(action.getTooltip());
        this.setIconPath(action.getIconPath());
        this.setIcon(this.getIcon(action.getIconPath()));
        this._bParameters.setEnabled(plugin.withParameters());
    }

    Icon getIcon(String iconPath) {
        Icon icon = new ImageIcon(iconPath);
        if (icon != null && icon.getIconWidth() != -1 && icon.getIconHeight() != -1) {
            return icon;
        }
        PluginModel plugin = this._pluginManager.getPlugin(this._action.getPluginKey());
        icon = this.getPluginIcon(plugin, "plugin.default");
        if (icon != null && icon.getIconWidth() != -1 && icon.getIconHeight() != -1) {
            return icon;
        }
        if (icon != null && icon.getIconWidth() != -1 && icon.getIconHeight() != -1) {
            return icon;
        }
        URL url = ResourceAccessor.getInstance().getResource("vide_pi");
        icon = url == null ? null : new ImageIcon(url);
        return icon;
    }

    private Icon getPluginIcon(PluginModel plugin, String iconName) {
        try {
            return plugin.getIcon(iconName);
        }
        catch (Exception e) {
            PluginDescriptor pluginDescriptor = this._pluginManager.getPluginDescriptor(this._action.getPluginKey());
            _LOG.log(Level.INFO, "Error in method getPluginIcon with arguments " + pluginDescriptor.getKey() + ", " + iconName, e);
            return null;
        }
    }

    public String getIconPath() {
        return this._tfIconPath.getText();
    }

    public void setIconPath(String iconPath) {
        this._tfIconPath.setText(iconPath);
    }

    public void setIcon(Icon icon) {
        if (icon != null) {
            this._lblIcon.setIcon(icon);
        }
    }

    public Icon getIcon() {
        return this._lblIcon.getIcon();
    }

    public String getLabel() {
        return this._tfLabel.getText();
    }

    public void setLabel(String label) {
        this._tfLabel.setText(label);
    }

    public String getShortcut() {
        return this._tfShortcut.getText();
    }

    public void setShortcut(String shortcut) {
        this._tfShortcut.setText(shortcut);
    }

    public String getTooltip() {
        return this._tfTooltip.getText();
    }

    public void setTooltip(String tooltip) {
        this._tfTooltip.setText(tooltip);
    }

    public void setVisibleInFrame() {
        this.pack();
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
        this.dispose();
    }

    private void init() {
        this.make();
        this.defineListeners();
        this.pack();
    }

    private void make() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.makeItemPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 5, 0), 0, 0));
        panel.add((Component)new JSeparator(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 5, 10), 0, 0));
        panel.add((Component)this.makeButtonPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        panel.getActionMap().put("CLOSE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditPluginActionDlg.this._bCancel.doClick();
            }
        });
        panel.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "CLOSE");
        panel.getActionMap().put("VALIDATE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditPluginActionDlg.this._bOk.isEnabled()) {
                    EditPluginActionDlg.this._bOk.doClick();
                }
            }
        });
        panel.getInputMap(2).put(KeyStroke.getKeyStroke("ENTER"), "VALIDATE");
        this.getContentPane().add(panel);
    }

    private JPanel makeItemPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this._lblLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 5, 10), 0, 0));
        panel.add((Component)this._lblIconPath, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0));
        panel.add((Component)this._lblShortcut, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0));
        panel.add((Component)this._lblTooltip, new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 10, 10, 10), 0, 0));
        panel.add((Component)this._tfLabel, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 5, 10), 0, 0));
        panel.add((Component)this._lblIcon, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 0), 0, 0));
        panel.add((Component)this._tfIconPath, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
        panel.add((Component)this._bIconPath, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 10), 0, 0));
        panel.add((Component)this._tfShortcut, new GridBagConstraints(1, 2, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 10, 10), 0, 0));
        panel.add((Component)this._tfTooltip, new GridBagConstraints(1, 3, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 10, 10), 0, 0));
        panel.add((Component)this._bParameters, new GridBagConstraints(0, 4, 4, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 10, 10), 0, 0));
        this._lblIcon.setPreferredSize(new Dimension(25, 20));
        this._lblIcon.setMaximumSize(new Dimension(25, 20));
        this._lblIcon.setMinimumSize(new Dimension(25, 20));
        return panel;
    }

    private JPanel makeButtonPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this._bOk, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 10, 10, 10), 0, 0));
        panel.add((Component)this._bCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 10, 10), 0, 0));
        this._bOk.setEnabled(false);
        return panel;
    }

    private void defineListeners() {
        this._bIconPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final String[] ext = new String[]{"bmp", "gif", "jpg", "jpeg", "wav"};
                File selectFile = null;
                if (EditPluginActionDlg.this._tfIconPath.getText().length() == 0 || !(selectFile = new File(EditPluginActionDlg.this._tfIconPath.getText())).exists()) {
                    selectFile = new File(".");
                }
                JFileChooser chooser = new JFileChooser(selectFile);
                chooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        if (file.isDirectory()) {
                            return true;
                        }
                        if (file.isHidden()) {
                            return false;
                        }
                        String path = file.getAbsolutePath();
                        int idx = path.lastIndexOf(".");
                        if (idx == -1) {
                            return true;
                        }
                        String extension = path.substring(idx + 1);
                        for (int i = 0; i < ext.length; ++i) {
                            if (!extension.equalsIgnoreCase(ext[i])) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public String getDescription() {
                        StringBuffer b = new StringBuffer();
                        b.append(Messages.getString("EditPluginActionDlg.17") + " (");
                        for (int i = 0; i < ext.length; ++i) {
                            b.append("*.").append(ext[i]).append(", ");
                        }
                        b.deleteCharAt(b.length() - 1);
                        b.deleteCharAt(b.length() - 1);
                        b.append(")");
                        return b.toString();
                    }
                });
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 1) {
                    return;
                }
                String pluginPath = EditPluginActionDlg.this._pluginManager.getPluginPath();
                String path = FileUtility.getDiffPath((String)pluginPath, (String)chooser.getSelectedFile().getAbsolutePath());
                EditPluginActionDlg.this.setIconPath(path);
                EditPluginActionDlg.this.setIcon(EditPluginActionDlg.this.getIcon(path));
            }
        });
        this._bParameters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginModel plugin = EditPluginActionDlg.this._pluginManager.getPlugin(EditPluginActionDlg.this._action.getPluginKey());
                if (plugin.withParameters()) {
                    EditPluginActionDlg.this._parameters = plugin.changeParameters(EditPluginActionDlg.this, EditPluginActionDlg.this._parameters);
                }
            }
        });
        this._bOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditPluginActionDlg.this._ok = true;
                EditPluginActionDlg.this.setVisible(false);
            }
        });
        this._bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditPluginActionDlg.this._ok = false;
                EditPluginActionDlg.this.setVisible(false);
            }
        });
        ValidateListener vListener = new ValidateListener();
        this._tfLabel.addCaretListener(vListener);
        this._tfLabel.addKeyListener(vListener);
        UpdateIconListener uListener = new UpdateIconListener();
        this._tfIconPath.addKeyListener(uListener);
        this._tfIconPath.addCaretListener(uListener);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EditPluginActionDlg dialog = new EditPluginActionDlg((Frame)null, Messages.getString("EditPluginActionDlg.23"), true);
        dialog.setVisibleInFrame();
    }

    @Override
    public Window getWindow() {
        return this;
    }

    @Override
    public List getPlugins(String typeKey) {
        return this._pluginManager.getPlugins(typeKey);
    }

    @Override
    public PluginModel getPlugin(String pluginKey) {
        return this._pluginManager.getPlugin(pluginKey);
    }

    @Override
    public String getInfo(String key) {
        return null;
    }

    public Object getParameters() {
        return this._parameters;
    }

    class ValidateListener
    implements CaretListener,
    KeyListener {
        ValidateListener() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            this.validate();
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.validate();
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        public void validate() {
            EditPluginActionDlg.this._bOk.setEnabled(true);
            if (EditPluginActionDlg.this._tfLabel.getText().length() == 0) {
                EditPluginActionDlg.this._bOk.setEnabled(false);
            }
            if (EditPluginActionDlg.this._alreadyUsedNames.contains(EditPluginActionDlg.this._tfLabel.getText())) {
                EditPluginActionDlg.this._bOk.setEnabled(false);
            }
        }
    }

    class UpdateIconListener
    implements CaretListener,
    KeyListener {
        UpdateIconListener() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            EditPluginActionDlg.this.setIcon(EditPluginActionDlg.this.getIcon(EditPluginActionDlg.this._tfIconPath.getText()));
        }

        @Override
        public void keyReleased(KeyEvent e) {
            EditPluginActionDlg.this.setIcon(EditPluginActionDlg.this.getIcon(EditPluginActionDlg.this._tfIconPath.getText()));
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }
    }
}

