/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.pluginmanager;

import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.core.pluginmanager.PluginAction;
import com.dassault.cecilia.core.pluginmanager.PluginManager;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PluginDescriptor {
    String _key;
    String _path;

    public PluginDescriptor() {
    }

    public PluginDescriptor(String key, String name, String path) {
        this._key = key;
        this._path = path;
    }

    public PluginModel readNode(Node node, PluginManager pluginManager) {
        NamedNodeMap attributes = node.getAttributes();
        this._key = attributes.getNamedItem("KEY").getNodeValue();
        PluginModel plugin = pluginManager.loadPluginModelClass(this._key);
        if (plugin == null) {
            return null;
        }
        this._path = pluginManager.getJarPathOfClass(this._key);
        NodeList childs = node.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node child = childs.item(i);
            if (!child.getNodeName().equals("PLUGIN_ACTION")) continue;
            PluginAction action = new PluginAction(this._key, plugin, pluginManager);
            action.readNode(child, plugin, pluginManager);
            pluginManager.loadPluginAction(action);
        }
        return plugin;
    }

    public void write(BufferedWriter writer, PluginModel plugin, PluginManager pluginManager) throws IOException {
        writer.write("  <PLUGIN ");
        writer.write("KEY=\"" + this.getKey() + "\" ");
        List actions = pluginManager.getPluginActions(this._key);
        if (actions == null || actions.size() == 0) {
            writer.write("/>");
        } else {
            writer.write(">");
            writer.newLine();
            for (PluginAction action : actions) {
                action.write(writer, plugin, pluginManager);
            }
            writer.write("  </PLUGIN>");
        }
        writer.newLine();
    }

    public String getKey() {
        return this._key;
    }

    public String getPath() {
        return this._path;
    }
}

