/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.pluginmanager;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.plugin.PluginMTreatment;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.core.pluginmanager.Messages;
import com.dassault.cecilia.core.pluginmanager.PluginManager;
import com.dassault.cecilia.core.pluginmanager.PostProcess;
import com.dassault.cecilia.core.pluginmanager.PostProcessChangeListener;
import com.dassault.cecilia.core.pluginmanager.PostProcessItem;
import com.dassault.cecilia.core.pluginmanager.PostProcessSelectorListener;
import com.dassault.cecilia.core.pluginmanager.PostProcessStore;
import com.dassault.cecilia.core.pluginmanager.PostProcessStoreChangeListener;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.list.ArrayListModel;
import com.dassault.cecilia.core.swing.table.CeciliaTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;

public class PostProcessPluginsPanel
extends JPanel {
    static final Logger __logger = Logger.getLogger(PostProcessPluginsPanel.class.getPackage().getName());
    PluginManager _manager;
    PostProcessStore _store;
    List<PostProcessStoreChangeListener> _storeListeners = new ArrayList<PostProcessStoreChangeListener>();

    public PostProcessPluginsPanel(PluginManager manager) {
        super(new BorderLayout());
        this._manager = manager;
        this._store = manager.getPostProcessStore();
        PostProcessListPanel leftPanel = new PostProcessListPanel(this._store);
        PostProcessPanel rightPanel = new PostProcessPanel(this._store);
        leftPanel.addPostProcessSelectorListener(rightPanel);
        rightPanel.addPostProcessChangeListener(leftPanel);
        JSplitPane splitPanel = new JSplitPane(1, false, leftPanel, rightPanel);
        splitPanel.setResizeWeight(0.2);
        this.add((Component)splitPanel, "Center");
    }

    public void addPostProcessStoreChangeListener(PostProcessStoreChangeListener listener) {
        this._storeListeners.add(listener);
    }

    public void removePostProcessStoreChangeListener(PostProcessStoreChangeListener listener) {
        this._storeListeners.remove(listener);
    }

    protected void fireChangePostProcessStore() {
        for (PostProcessStoreChangeListener listener : this._storeListeners) {
            listener.changePostProcessStore(this._store);
        }
    }

    PostProcessItem editTreatment(PostProcessItem item) {
        Window win = SwingUtilities.getWindowAncestor(this);
        DlgDefineTreatment dlg = new DlgDefineTreatment(win, this._manager);
        return dlg.doModal(item);
    }

    class PostProcessListPanel
    extends JPanel
    implements PostProcessChangeListener {
        JTable _ctrlTable;
        PostProcessListModel _modelTable;
        CeciliaAction _ctrlAdd;
        CeciliaAction _ctrlDel;
        CeciliaAction _ctrlUp;
        CeciliaAction _ctrlDown;
        JPopupMenu _popupList;
        List<PostProcessSelectorListener> _listeners = new ArrayList<PostProcessSelectorListener>();

        PostProcessListPanel(PostProcessStore store) {
            this._modelTable = new PostProcessListModel(store);
            this.initialise();
        }

        @Override
        public void changePostProcess(PostProcess pp) {
            this._modelTable.changeData(pp);
        }

        protected void addPostProcessSelectorListener(PostProcessSelectorListener listener) {
            this._listeners.add(listener);
        }

        protected void removePostProcessSelectorListener(PostProcessSelectorListener listener) {
            this._listeners.remove(listener);
        }

        protected void fireSelectPostProcess(PostProcess pp) {
            for (PostProcessSelectorListener ppl : this._listeners) {
                ppl.selectPostProcess(pp);
            }
        }

        protected void initialise() {
            this._ctrlAdd = new CeciliaAction(ResIcoCore.getImageIcon("BUT_ADD"), ResMsgVoc.getString("VOC_ADD"), Messages.getString("PostProcessPluginsPanel.1")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int idx = PostProcessListPanel.this._ctrlTable.getSelectedRow();
                    if (idx == -1) {
                        PostProcessListPanel.this._modelTable.insertData(-1);
                        idx = PostProcessListPanel.this._modelTable.getRowCount() - 1;
                    } else {
                        PostProcessListPanel.this._modelTable.insertData(idx);
                    }
                    PostProcessListPanel.this.refreshCtrl();
                }
            };
            this._ctrlDel = new CeciliaAction(ResIcoCore.getImageIcon("BUT_DEL"), ResMsgVoc.getString("VOC_REMOVE"), Messages.getString("PostProcessPluginsPanel.2")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int idx = PostProcessListPanel.this._ctrlTable.getSelectedRow();
                    if (idx != -1) {
                        PostProcessListPanel.this._modelTable.removeData(idx);
                        PostProcessListPanel.this.refreshCtrl();
                    } else {
                        __logger.info("Bad index");
                    }
                }
            };
            this._ctrlUp = new CeciliaAction(ResIcoCore.getImageIcon("BUT_UP"), ResMsgVoc.getString("VOC_UP"), Messages.getString("PostProcessPluginsPanel.3")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int idx = PostProcessListPanel.this._ctrlTable.getSelectedRow();
                    if (idx != -1 && idx > 0) {
                        PostProcessListPanel.this._modelTable.down(idx);
                        PostProcessListPanel.this._ctrlTable.setRowSelectionInterval(idx - 1, idx - 1);
                        PostProcessListPanel.this.refreshCtrl();
                    } else {
                        __logger.info("Bad index");
                    }
                }
            };
            this._ctrlDown = new CeciliaAction(ResIcoCore.getImageIcon("BUT_DOWN"), ResMsgVoc.getString("VOC_DOWN"), Messages.getString("PostProcessPluginsPanel.4")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int idx = PostProcessListPanel.this._ctrlTable.getSelectedRow();
                    if (idx != -1 && idx < PostProcessListPanel.this._modelTable.getRowCount() - 1) {
                        PostProcessListPanel.this._modelTable.up(idx);
                        PostProcessListPanel.this._ctrlTable.setRowSelectionInterval(idx + 1, idx + 1);
                        PostProcessListPanel.this.refreshCtrl();
                    } else {
                        __logger.info("Bad index");
                    }
                }
            };
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JToolBar aPanel = new JToolBar();
            aPanel.setBorder(CeciliaAction.STANDARD_BORDER);
            aPanel.add(Box.createHorizontalGlue());
            aPanel.add(this._ctrlAdd.createButton(CeciliaAction.BorderStyle.LIGHT));
            aPanel.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
            aPanel.add(this._ctrlDel.createButton(CeciliaAction.BorderStyle.LIGHT));
            aPanel.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
            aPanel.add(this._ctrlUp.createButton(CeciliaAction.BorderStyle.LIGHT));
            aPanel.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
            aPanel.add(this._ctrlDown.createButton(CeciliaAction.BorderStyle.LIGHT));
            aPanel.setFloatable(false);
            this.add((Component)aPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._popupList = new JPopupMenu();
            this._popupList.add(this._ctrlAdd);
            this._popupList.add(this._ctrlDel);
            this._popupList.addSeparator();
            this._popupList.add(this._ctrlUp);
            this._popupList.add(this._ctrlDown);
            this._ctrlTable = new JTable(this._modelTable);
            this._ctrlTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
            JScrollPane scrTable = new JScrollPane(this._ctrlTable);
            this._ctrlTable.setComponentPopupMenu(this._popupList);
            ListSelectionModel selMod = this._ctrlTable.getSelectionModel();
            selMod.setSelectionMode(0);
            selMod.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    Object obj;
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    int idx = PostProcessListPanel.this._ctrlTable.getSelectedRow();
                    Object object = obj = idx == -1 ? null : PostProcessListPanel.this._ctrlTable.getValueAt(idx, -1);
                    if (obj == null || obj instanceof PostProcess) {
                        PostProcessListPanel.this.fireSelectPostProcess((PostProcess)obj);
                    }
                    PostProcessListPanel.this.refreshCtrl();
                }
            });
            this._modelTable.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    PostProcessListPanel.this.refreshCtrl();
                }
            });
            this.add((Component)scrTable, new GridBagConstraints(0, 1, 1, 1, 10.0, 10.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.refreshCtrl();
        }

        protected void refreshCtrl() {
            int idx = this._ctrlTable.getSelectedRow();
            int nbr = this._ctrlTable.getRowCount();
            this._ctrlDel.setEnabled(idx != -1);
            this._ctrlUp.setEnabled(idx != -1 && idx > 0);
            this._ctrlDown.setEnabled(idx != -1 && idx < nbr - 1);
        }

        class PostProcessListModel
        extends AbstractTableModel {
            protected PostProcessStore _array;

            PostProcessListModel(PostProcessStore array) {
                this._array = array;
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return null;
            }

            @Override
            public int getRowCount() {
                return this._array.size();
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (columnIndex == -1) {
                    return this._array.get(rowIndex);
                }
                return this._array.get(rowIndex).getName();
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            public void insertData(int idx) {
                if (idx == -1) {
                    idx = this._array.size();
                }
                PostProcess pProcess = this._array.createNewProcess();
                this._array.add(idx, pProcess);
                this.fireTableRowsInserted(idx, idx);
                PostProcessPluginsPanel.this.fireChangePostProcessStore();
            }

            public void removeData(int idx) {
                this.fireTableRowsDeleted(idx, idx);
                this._array.remove(idx);
                PostProcessPluginsPanel.this.fireChangePostProcessStore();
            }

            public void changeData(PostProcess obj) {
                int idx = this._array.remove(obj);
                if (idx >= 0) {
                    this._array.add(idx, obj);
                    this.fireTableRowsUpdated(idx, idx);
                }
                PostProcessPluginsPanel.this.fireChangePostProcessStore();
            }

            public void down(int idx) {
                assert (idx > 0 && idx <= this._array.size() - 1) : Integer.toString(idx);
                PostProcess obj = this._array.remove(idx);
                this._array.add(idx - 1, obj);
                this.fireTableRowsUpdated(idx - 1, idx);
                PostProcessPluginsPanel.this.fireChangePostProcessStore();
            }

            public void up(int idx) {
                assert (idx >= 0 && idx < this._array.size() - 1) : Integer.toString(idx);
                PostProcess obj = this._array.remove(idx);
                this._array.add(idx + 1, obj);
                this.fireTableRowsUpdated(idx, idx + 1);
                PostProcessPluginsPanel.this.fireChangePostProcessStore();
            }
        }
    }

    class PostProcessPanel
    extends JPanel
    implements PostProcessSelectorListener {
        JLabel _lblName;
        JTextField _ctrlName;
        JLabel _lblFilter;
        JTextField _ctrlFilter;
        JLabel _lblRemark;
        JTextArea _ctrlRemark;
        JTable _ctrlTable;
        PostProcessModel _modelTable;
        CeciliaAction _ctrlAdd;
        CeciliaAction _ctrlDel;
        CeciliaAction _ctrlEdit;
        CeciliaAction _ctrlUp;
        CeciliaAction _ctrlDown;
        JPopupMenu _popupList;
        List<PostProcessChangeListener> _listeners = new ArrayList<PostProcessChangeListener>();
        PostProcessStore _postProcesss;

        PostProcessPanel(PostProcessStore ppl) {
            this._postProcesss = ppl;
            this.initialise();
        }

        @Override
        public void selectPostProcess(PostProcess pp) {
            this._modelTable.setModel(pp);
            if (pp != null) {
                this._ctrlName.setText(pp.getName());
                this._ctrlFilter.setText(pp.getFilter());
                this._ctrlRemark.setText(pp.getRemark());
            } else {
                this._ctrlName.setText("");
                this._ctrlFilter.setText("");
                this._ctrlRemark.setText("");
            }
            this._ctrlRemark.setCaretPosition(0);
            boolean model = this._modelTable.getModel() != null;
            this._lblName.setEnabled(model);
            this._ctrlName.setEnabled(model);
            this._lblFilter.setEnabled(model);
            this._ctrlFilter.setEnabled(model);
            this._lblRemark.setEnabled(model);
            this._ctrlRemark.setEnabled(model);
            this._ctrlTable.setEnabled(model);
            this.refreshCtrl();
        }

        protected void addPostProcessChangeListener(PostProcessChangeListener listener) {
            this._listeners.add(listener);
        }

        protected void removePostProcessChangeListener(PostProcessChangeListener listener) {
            this._listeners.remove(listener);
        }

        protected void fireChangePostProcess(PostProcess pp) {
            for (PostProcessChangeListener ppcl : this._listeners) {
                ppcl.changePostProcess(pp);
            }
        }

        protected void initialise() {
            this._ctrlAdd = new CeciliaAction(ResIcoCore.getImageIcon("BUT_ADD"), ResMsgVoc.getString("VOC_ADD"), Messages.getString("PostProcessPluginsPanel.11")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int idx = PostProcessPanel.this._ctrlTable.getSelectedRow();
                    PostProcessItem item = PostProcessPluginsPanel.this.editTreatment(null);
                    if (item == null) {
                        return;
                    }
                    if (idx == -1) {
                        PostProcessPanel.this._modelTable.insertData(-1, item);
                        idx = PostProcessPanel.this._modelTable.getRowCount() - 1;
                    } else {
                        PostProcessPanel.this._modelTable.insertData(idx, item);
                    }
                    PostProcessPanel.this.refreshCtrl();
                }
            };
            this._ctrlEdit = new CeciliaAction(ResIcoCore.getImageIcon("BUT_EDIT"), ResMsgVoc.getString("VOC_EDIT"), Messages.getString("PostProcessPluginsPanel.15")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int idx = PostProcessPanel.this._ctrlTable.getSelectedRow();
                    if (idx == -1) {
                        return;
                    }
                    PostProcessItem item = PostProcessPanel.this._modelTable.getModel().get(idx);
                    if ((item = PostProcessPluginsPanel.this.editTreatment(item)) != null) {
                        PostProcessPanel.this._modelTable.getModel().set(idx, item);
                        PostProcessPanel.this._modelTable.changeData(item);
                    }
                }
            };
            this._ctrlDel = new CeciliaAction(ResIcoCore.getImageIcon("BUT_DEL"), ResMsgVoc.getString("VOC_REMOVE"), Messages.getString("PostProcessPluginsPanel.12")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int idx = PostProcessPanel.this._ctrlTable.getSelectedRow();
                    if (idx != -1) {
                        PostProcessPanel.this._modelTable.removeData(idx);
                        PostProcessPanel.this.refreshCtrl();
                    } else {
                        __logger.info("Bad index");
                    }
                }
            };
            this._ctrlUp = new CeciliaAction(ResIcoCore.getImageIcon("BUT_UP"), ResMsgVoc.getString("VOC_UP"), Messages.getString("PostProcessPluginsPanel.13")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int idx = PostProcessPanel.this._ctrlTable.getSelectedRow();
                    if (idx != -1 && idx > 0) {
                        PostProcessPanel.this._modelTable.down(idx);
                        PostProcessPanel.this._ctrlTable.setRowSelectionInterval(idx - 1, idx - 1);
                        PostProcessPanel.this.refreshCtrl();
                    } else {
                        __logger.info("Bad index");
                    }
                }
            };
            this._ctrlDown = new CeciliaAction(ResIcoCore.getImageIcon("BUT_DOWN"), ResMsgVoc.getString("VOC_DOWN"), Messages.getString("PostProcessPluginsPanel.14")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int idx = PostProcessPanel.this._ctrlTable.getSelectedRow();
                    if (idx != -1 && idx < PostProcessPanel.this._modelTable.getRowCount() - 1) {
                        PostProcessPanel.this._modelTable.up(idx);
                        PostProcessPanel.this._ctrlTable.setRowSelectionInterval(idx + 1, idx + 1);
                        PostProcessPanel.this.refreshCtrl();
                    } else {
                        __logger.info("Bad index");
                    }
                }
            };
            this.setLayout(new GridBagLayout());
            int line = 0;
            this._lblName = new JLabel(ResMsgVoc.getString("VOC_NAME"));
            this.add((Component)this._lblName, new GridBagConstraints(0, line, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this._ctrlName = new JTextField(20);
            this._ctrlName.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    String oldName;
                    PostProcess pp = PostProcessPanel.this._modelTable.getModel();
                    if (pp == null) {
                        return;
                    }
                    String name = PostProcessPanel.this._ctrlName.getText();
                    if (!name.equals(oldName = pp.getName())) {
                        if (PostProcessPanel.this._postProcesss.get(name) != null) {
                            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(PostProcessPanel.this._ctrlName), Messages.getString("PostProcessPluginsPanel.20"), ResMsgVoc.getString("VOC_ERROR"), 0);
                            PostProcessPanel.this._ctrlName.setText(oldName);
                            PostProcessPanel.this._ctrlName.requestFocus();
                        } else if (!pp.setName(name)) {
                            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(PostProcessPanel.this._ctrlName), Messages.getString("PostProcessPluginsPanel.21"), ResMsgVoc.getString("VOC_ERROR"), 0);
                            PostProcessPanel.this._ctrlName.setText(oldName);
                            PostProcessPanel.this._ctrlName.requestFocus();
                        } else {
                            PostProcessPanel.this.fireChangePostProcess(pp);
                        }
                    }
                }
            });
            this.add((Component)this._ctrlName, new GridBagConstraints(1, line++, 1, 1, 10.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
            this._lblRemark = new JLabel(ResMsgVoc.getString("VOC_REMARK"));
            this.add((Component)this._lblRemark, new GridBagConstraints(0, line, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this._ctrlRemark = new JTextArea(3, 20);
            this._ctrlRemark.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    String oldRemark;
                    PostProcess pp = PostProcessPanel.this._modelTable.getModel();
                    if (pp == null) {
                        return;
                    }
                    String remark = PostProcessPanel.this._ctrlRemark.getText();
                    if (!remark.equals(oldRemark = pp.getRemark())) {
                        pp.setRemark(remark);
                        PostProcessPanel.this.fireChangePostProcess(pp);
                    }
                }
            });
            this.add((Component)new JScrollPane(this._ctrlRemark), new GridBagConstraints(1, line++, 1, 1, 10.0, 1.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
            this._lblFilter = new JLabel(Messages.getString("PostProcessPluginsPanel.32"));
            this.add((Component)this._lblFilter, new GridBagConstraints(0, line, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this._ctrlFilter = new JTextField(20);
            this._ctrlFilter.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    String oldFilter;
                    PostProcess pp = PostProcessPanel.this._modelTable.getModel();
                    if (pp == null) {
                        return;
                    }
                    String filter = PostProcessPanel.this._ctrlFilter.getText();
                    if (!filter.equals(oldFilter = pp.getFilter())) {
                        if (!pp.setFilter(filter)) {
                            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(PostProcessPanel.this._ctrlName), Messages.getString("PostProcessPluginsPanel.22"), ResMsgVoc.getString("VOC_ERROR"), 0);
                            PostProcessPanel.this._ctrlFilter.requestFocus();
                            PostProcessPanel.this._ctrlFilter.setText(oldFilter);
                        } else {
                            PostProcessPanel.this.fireChangePostProcess(pp);
                        }
                    }
                }
            });
            this.add((Component)this._ctrlFilter, new GridBagConstraints(1, line++, 1, 1, 10.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
            JPanel root = new JPanel(new GridBagLayout());
            root.setBorder(CeciliaAction.STANDARD_BORDER);
            JToolBar aPanel = new JToolBar();
            aPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            aPanel.add(Box.createHorizontalGlue());
            aPanel.add(this._ctrlAdd.createButton(CeciliaAction.BorderStyle.LIGHT));
            aPanel.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
            aPanel.add(this._ctrlEdit.createButton(CeciliaAction.BorderStyle.LIGHT));
            aPanel.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
            aPanel.add(this._ctrlDel.createButton(CeciliaAction.BorderStyle.LIGHT));
            aPanel.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
            aPanel.add(this._ctrlUp.createButton(CeciliaAction.BorderStyle.LIGHT));
            aPanel.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
            aPanel.add(this._ctrlDown.createButton(CeciliaAction.BorderStyle.LIGHT));
            aPanel.setFloatable(false);
            root.add((Component)aPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._popupList = new JPopupMenu();
            this._popupList.add(this._ctrlAdd);
            this._popupList.add(this._ctrlEdit);
            this._popupList.add(this._ctrlDel);
            this._popupList.addSeparator();
            this._popupList.add(this._ctrlUp);
            this._popupList.add(this._ctrlDown);
            this._modelTable = new PostProcessModel();
            this._ctrlTable = new CeciliaTable(this._modelTable){

                @Override
                protected void doubleClickLeft(MouseEvent e) {
                    PostProcessPanel.this._ctrlEdit.actionPerformed(new ActionEvent(PostProcessPanel.this._ctrlTable, 0, "Double-clic"));
                }
            };
            this._ctrlTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
            JScrollPane scrollTable = new JScrollPane(this._ctrlTable);
            scrollTable.setComponentPopupMenu(this._popupList);
            this._ctrlTable.setRowHeight(25);
            TableColumnModel colModel = this._ctrlTable.getColumnModel();
            colModel.getColumn(0).setPreferredWidth(500);
            colModel.getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JLabel result = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    PluginMTreatment plugin = (PluginMTreatment)value;
                    Icon icon = plugin.getIcon("plugin.default");
                    if (icon != null) {
                        result.setIcon(icon);
                    }
                    result.setText(plugin.getInfo("plugin.name"));
                    return result;
                }
            });
            colModel.getColumn(1).setPreferredWidth(350);
            colModel.getColumn(2).setPreferredWidth(1000);
            colModel.getColumn(2).setCellRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    int preferredHeight = this.getPreferredSize().height;
                    preferredHeight = Math.max(preferredHeight, 25);
                    if (table.getRowHeight(row) != preferredHeight) {
                        table.setRowHeight(row, preferredHeight);
                    }
                    return this;
                }
            });
            ListSelectionModel selMod = this._ctrlTable.getSelectionModel();
            selMod.setSelectionMode(0);
            selMod.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    PostProcessPanel.this.refreshCtrl();
                }
            });
            this._modelTable.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    PostProcessPanel.this.refreshCtrl();
                }
            });
            root.add((Component)scrollTable, new GridBagConstraints(0, 1, 1, 1, 10.0, 10.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)root, new GridBagConstraints(0, line, 2, 1, 10.0, 7.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.refreshCtrl();
        }

        protected void refreshCtrl() {
            boolean model = this._modelTable.getModel() != null;
            int idx = this._ctrlTable.getSelectedRow();
            int nbr = this._ctrlTable.getRowCount();
            this._ctrlAdd.setEnabled(model);
            this._ctrlEdit.setEnabled(model && idx != -1);
            this._ctrlDel.setEnabled(model && idx != -1);
            this._ctrlUp.setEnabled(model && idx != -1 && idx > 0);
            this._ctrlDown.setEnabled(model && idx != -1 && idx < nbr - 1);
        }

        class PostProcessModel
        extends AbstractTableModel {
            protected PostProcess _pp;

            PostProcessModel() {
            }

            void setModel(PostProcess pp) {
                this._pp = pp;
                this.fireTableDataChanged();
            }

            PostProcess getModel() {
                return this._pp;
            }

            @Override
            public int getColumnCount() {
                return 3;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 0) {
                    return PluginMTreatment.class;
                }
                return String.class;
            }

            @Override
            public String getColumnName(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return Messages.getString("PostProcessPluginsPanel.33");
                    }
                    case 1: {
                        return ResMsgVoc.getString("VOC_NAME");
                    }
                    case 2: {
                        return Messages.getString("PostProcessPluginsPanel.34");
                    }
                }
                return "Error";
            }

            @Override
            public int getRowCount() {
                if (this._pp == null) {
                    return 0;
                }
                return this._pp.size();
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (this._pp == null) {
                    return "Null";
                }
                PostProcessItem item = this._pp.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return item.getPlugin();
                    }
                    case 1: {
                        return item.getName();
                    }
                    case 2: {
                        Object param = item.getParam();
                        if (param != null) {
                            StringBuffer sb = new StringBuffer(128);
                            sb.append("<html>").append(param.toString()).append("</html>");
                            String result = sb.toString();
                            result = result.replaceAll("\n", "<br>");
                            result = result.replaceAll("\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
                            result = result.replaceAll(" ", "&nbsp;");
                            return result;
                        }
                        return "";
                    }
                }
                return "Error";
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            public void insertData(int idx, PostProcessItem item) {
                if (this._pp == null) {
                    return;
                }
                if (idx == -1) {
                    idx = this._pp.size();
                }
                this._pp.add(idx, item);
                this.fireTableRowsInserted(idx, idx);
                PostProcessPanel.this.fireChangePostProcess(this._pp);
            }

            public void removeData(int idx) {
                if (this._pp == null) {
                    return;
                }
                this.fireTableRowsDeleted(idx, idx);
                this._pp.remove(idx);
                PostProcessPanel.this.fireChangePostProcess(this._pp);
            }

            public void changeData(PostProcessItem obj) {
                if (this._pp == null) {
                    return;
                }
                int idx = this._pp.indexOf(obj);
                if (idx >= 0) {
                    this.fireTableRowsUpdated(idx, idx);
                }
                PostProcessPanel.this.fireChangePostProcess(this._pp);
            }

            public void down(int idx) {
                if (this._pp == null) {
                    return;
                }
                assert (idx > 0 && idx <= this._pp.size() - 1) : Integer.toString(idx);
                PostProcessItem obj = this._pp.remove(idx);
                this._pp.add(idx - 1, obj);
                this.fireTableRowsUpdated(idx - 1, idx);
                PostProcessPanel.this.fireChangePostProcess(this._pp);
            }

            public void up(int idx) {
                if (this._pp == null) {
                    return;
                }
                assert (idx >= 0 && idx < this._pp.size() - 1) : Integer.toString(idx);
                PostProcessItem obj = this._pp.remove(idx);
                this._pp.add(idx + 1, obj);
                this.fireTableRowsUpdated(idx, idx + 1);
                PostProcessPanel.this.fireChangePostProcess(this._pp);
            }
        }
    }

    class DlgDefineTreatment
    extends JDialogCecilia {
        JLabel _lblName;
        JTextField _ctrlName;
        JLabel _lblTreat;
        JComboBox _ctrlTreat;
        JLabel _lblParams;
        JTextArea _ctrlParams;
        JButton _butParams;
        ArrayListModel<PluginMTreatment> _modelTreat;
        PluginManager _pluginManager;
        ArrayList<PluginMTreatment> _treatments;
        ArrayList<Object> _parameters;
        Object _currentParameter;

        public DlgDefineTreatment(Window win, PluginManager manager) {
            super(win);
            this.init(manager);
        }

        protected JComponent createParametersPanel() {
            JPanel root = new JPanel(new GridBagLayout());
            root.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            int line = 0;
            this._lblParams = new JLabel(Messages.getString("PostProcessPluginsPanel.34"));
            root.add((Component)this._lblParams, new GridBagConstraints(0, line, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 2, 5, 0), 0, 0));
            this._butParams = new JButton(Messages.getString("PostProcessPluginsPanel.35"));
            this._butParams.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object param;
                    int idx = DlgDefineTreatment.this._ctrlTreat.getSelectedIndex();
                    if (idx == -1) {
                        return;
                    }
                    PluginModel plugin = (PluginModel)DlgDefineTreatment.this._ctrlTreat.getSelectedItem();
                    if (plugin == null) {
                        return;
                    }
                    if (!plugin.withParameters()) {
                        return;
                    }
                    if (DlgDefineTreatment.this._currentParameter == null) {
                        DlgDefineTreatment.this._currentParameter = plugin.getDefaultParameters(DlgDefineTreatment.this._pluginManager);
                    }
                    if ((param = plugin.changeParameters(DlgDefineTreatment.this._pluginManager, DlgDefineTreatment.this._currentParameter)) != null) {
                        DlgDefineTreatment.this._currentParameter = param;
                        while (DlgDefineTreatment.this._parameters.size() < idx) {
                            DlgDefineTreatment.this._parameters.add(null);
                        }
                        DlgDefineTreatment.this._parameters.set(idx, DlgDefineTreatment.this._currentParameter);
                        DlgDefineTreatment.this._ctrlParams.setText(DlgDefineTreatment.this._currentParameter.toString());
                        DlgDefineTreatment.this._ctrlParams.setCaretPosition(0);
                    }
                }
            });
            root.add((Component)this._butParams, new GridBagConstraints(1, line, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 2), 0, 0));
            this._ctrlParams = new JTextArea(10, 40);
            this._ctrlParams.setEditable(false);
            root.add((Component)new JScrollPane(this._ctrlParams), new GridBagConstraints(0, ++line, 2, 1, 10.0, 10.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            return root;
        }

        protected JComponent createMainPanel() {
            JPanel root = new JPanel(new GridBagLayout());
            int line = 0;
            this._lblName = new JLabel(ResMsgVoc.getString("VOC_NAME"));
            root.add((Component)this._lblName, new GridBagConstraints(0, line, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._ctrlName = new JTextField(20);
            root.add((Component)this._ctrlName, new GridBagConstraints(1, line++, 1, 1, 10.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
            this._lblTreat = new JLabel(Messages.getString("PostProcessPluginsPanel.33"));
            root.add((Component)this._lblTreat, new GridBagConstraints(0, line, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._modelTreat = new ArrayListModel();
            this._modelTreat.setList(this._treatments);
            this._ctrlTreat = new JComboBox<PluginMTreatment>(this._modelTreat);
            this._ctrlTreat.setRenderer(new BasicComboBoxRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel result = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (value instanceof PluginModel) {
                        PluginModel plugin = (PluginModel)value;
                        Icon icon = plugin.getIcon("plugin.default");
                        if (icon != null) {
                            result.setIcon(icon);
                        }
                        result.setText(plugin.getInfo("plugin.name") + "   [" + plugin.getInfo("plugin.key") + "]");
                    } else {
                        result.setIcon(null);
                    }
                    return result;
                }
            });
            this._ctrlTreat.setEditable(false);
            this._ctrlTreat.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int idx = DlgDefineTreatment.this._ctrlTreat.getSelectedIndex();
                    if (idx == -1) {
                        return;
                    }
                    PluginModel plugin = (PluginModel)DlgDefineTreatment.this._ctrlTreat.getSelectedItem();
                    boolean enableParameters = plugin.withParameters();
                    if (enableParameters) {
                        while (DlgDefineTreatment.this._parameters.size() <= idx) {
                            DlgDefineTreatment.this._parameters.add(null);
                        }
                        DlgDefineTreatment.this._currentParameter = DlgDefineTreatment.this._parameters.get(idx);
                        if (DlgDefineTreatment.this._currentParameter == null) {
                            DlgDefineTreatment.this._currentParameter = plugin.getDefaultParameters(DlgDefineTreatment.this._pluginManager);
                            DlgDefineTreatment.this._parameters.set(idx, DlgDefineTreatment.this._currentParameter);
                        }
                        DlgDefineTreatment.this._ctrlParams.setText(DlgDefineTreatment.this._currentParameter.toString());
                    } else {
                        DlgDefineTreatment.this._currentParameter = null;
                        DlgDefineTreatment.this._ctrlParams.setText("");
                    }
                    DlgDefineTreatment.this._ctrlParams.setCaretPosition(0);
                    DlgDefineTreatment.this._lblParams.setEnabled(enableParameters);
                    DlgDefineTreatment.this._butParams.setEnabled(enableParameters);
                    DlgDefineTreatment.this._ctrlParams.setEnabled(enableParameters);
                }
            });
            root.add((Component)this._ctrlTreat, new GridBagConstraints(1, line++, 1, 1, 10.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
            root.add((Component)this.createParametersPanel(), new GridBagConstraints(0, line, 2, 1, 10.0, 10.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            return root;
        }

        protected void init(PluginManager manager) {
            super.init();
            this._pluginManager = manager;
            this._treatments = new ArrayList();
            List keys = manager.getPlugins("PluginTreatment");
            for (int i = 0; i < keys.size(); ++i) {
                PluginModel plugin = manager.getPlugin((String)keys.get(i));
                if (plugin == null || !(plugin instanceof PluginMTreatment)) continue;
                this._treatments.add((PluginMTreatment)plugin);
            }
            JPanel rPanel = new JPanel(new GridBagLayout());
            rPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this._result = false;
            rPanel.add((Component)this.createMainPanel(), new GridBagConstraints(0, 0, 1, 1, 10.0, 10.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            rPanel.add((Component)this.createButPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)rPanel, "Center");
            this.pack();
            this.setLocationRelativeTo(this.getParent());
            this.setTitle(Messages.getString("PostProcessPluginsPanel.36"));
        }

        public PostProcessItem doModal(PostProcessItem item) {
            this._result = false;
            this._parameters = new ArrayList();
            if (item == null) {
                this._ctrlName.setText("");
                this._ctrlTreat.setSelectedItem(null);
                this._currentParameter = null;
            } else {
                this._ctrlName.setText(item.getName());
                this._ctrlTreat.setSelectedItem(item.getPlugin());
                this._currentParameter = item.getParam();
                if (this._currentParameter != null) {
                    this._ctrlParams.setText(this._currentParameter.toString());
                } else {
                    this._ctrlParams.setText("");
                }
                this._ctrlParams.setCaretPosition(0);
            }
            this.setModal(true);
            this.setVisible(true);
            if (this._result) {
                PostProcessItem result = new PostProcessItem((PluginMTreatment)this._ctrlTreat.getSelectedItem(), this._pluginManager);
                result.setName(this._ctrlName.getText());
                result.setParam(this._currentParameter);
                return result;
            }
            return null;
        }

        @Override
        protected boolean verifyParameters() {
            if (this._ctrlName.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlName), Messages.getString("PostProcessPluginsPanel.37"), ResMsgVoc.getString("VOC_ERROR"), 0);
                return false;
            }
            if (this._ctrlTreat.getSelectedItem() == null) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlTreat), Messages.getString("PostProcessPluginsPanel.39"), ResMsgVoc.getString("VOC_ERROR"), 0);
                return false;
            }
            return true;
        }
    }
}

