/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.pluginmanager;

import com.dassault.cecilia.core.plugin.PluginMProcess;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.core.pluginmanager.PostProcess;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PostProcessStore {
    static final String XML_TAG_POST_PROCESS = "POST_PROCESS";
    static final String XML_TAG_POST_PROCESS_ITEM = "TREATMENT";
    static final String XML_ATT_NAME = "NAME";
    static final String XML_ATT_FILTER = "FILTER";
    static final String XML_ATT_REMARK = "REMARK";
    static final String XML_ATT_ID = "ID";
    static final Logger __logger = Logger.getLogger(PostProcessStore.class.getPackage().getName());
    List<PostProcess> _data = new ArrayList<PostProcess>();
    Map<String, PostProcess> _names = new HashMap<String, PostProcess>();

    List<String> getKeyPlugins() {
        int size = this._data.size();
        ArrayList<String> result = new ArrayList<String>(size + 1);
        for (int i = 0; i < size; ++i) {
            result.add(this.getClass().getName() + "." + this.get(i).getName());
        }
        return result;
    }

    PluginMProcess getPlugin(String key) {
        String prefix = this.getClass().getName() + ".";
        if (key.startsWith(prefix)) {
            return this.get(key.substring(prefix.length()));
        }
        return null;
    }

    void load(NodeList childs, PluginManager manager) {
        this._data.clear();
        this._names.clear();
        for (int i = 0; i < childs.getLength(); ++i) {
            PostProcess pp;
            Node child = childs.item(i);
            if (!child.getNodeName().equals(XML_TAG_POST_PROCESS) || !(pp = new PostProcess()).load(child, manager)) continue;
            this.add(pp);
        }
    }

    void save(BufferedWriter out, PluginManager manager) throws IOException {
        int size = this._data.size();
        for (int i = 0; i < size; ++i) {
            this.get(i).save(out, manager);
        }
    }

    List<String> getFilterPostProcessList(String criterium) {
        ArrayList<String> result = new ArrayList<String>(this._data.size());
        for (PostProcess pp : this._data) {
            if (!pp.withCriterium(criterium)) continue;
            result.add(pp.getName());
        }
        return result;
    }

    int size() {
        return this._data.size();
    }

    PostProcess get(int index) {
        return this._data.get(index);
    }

    PostProcess get(String name) {
        return this._names.get(name);
    }

    int indexOf(PostProcess obj) {
        return this._data.indexOf(obj);
    }

    void add(PostProcess obj) {
        this.add(this._data.size(), obj);
    }

    void add(int idx, PostProcess obj) {
        if (this._names.containsKey(obj.getName())) {
            __logger.warning("Already contain a PostProcess naming " + obj.getName());
            return;
        }
        this._data.add(idx, obj);
        this._names.put(obj.getName(), obj);
    }

    PostProcess remove(int index) {
        PostProcess result = this._data.remove(index);
        this._names.remove(result.getName());
        return result;
    }

    int remove(PostProcess pp) {
        int result = -1;
        Iterator<PostProcess> iLst = this._data.iterator();
        int i = 0;
        while (iLst.hasNext() && result == -1) {
            if (iLst.next() == pp) {
                iLst.remove();
                result = i;
            }
            ++i;
        }
        if (result != -1) {
            Iterator<Map.Entry<String, PostProcess>> iter = this._names.entrySet().iterator();
            while (iter.hasNext()) {
                if (iter.next().getValue() != pp) continue;
                iter.remove();
                break;
            }
        }
        return result;
    }

    PostProcess createNewProcess() {
        int cpt = 0;
        Object name = "Default";
        while (this._names.containsKey(name)) {
            name = "Default" + cpt++;
        }
        return new PostProcess((String)name);
    }

    public void clear() {
        this._data.clear();
        this._names.clear();
    }
}

