/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.pluginmanager;

import com.dassault.cecilia.core.swing.JOptionCecilia;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Util {
    private static final Logger _LOG = Logger.getLogger(Util.class.getPackage().getName());

    public static String FormatString(String message, String p) {
        if (message == null) {
            return null;
        }
        if (p == null) {
            return message;
        }
        boolean found = false;
        char[] src = message.toCharArray();
        char[] dest = new char[src.length + p.length() - 1];
        int j = 0;
        for (int i = 0; i < src.length; ++i) {
            if (src[i] == '#' && !found) {
                found = true;
                char[] val = p.toCharArray();
                for (int k = 0; k < val.length; ++k) {
                    dest[j++] = val[k];
                }
                continue;
            }
            dest[j++] = src[i];
        }
        return new String(dest);
    }

    public static String FormatString(String message, String p1, String p2) {
        return Util.FormatString(Util.FormatString(message, p1), p2);
    }

    public static String FormatString(String message, char c, String p) {
        if (message == null) {
            return null;
        }
        if (p == null) {
            return message;
        }
        boolean found = false;
        char[] src = message.toCharArray();
        char[] dest = new char[src.length + p.length() - 1];
        int j = 0;
        for (int i = 0; i < src.length; ++i) {
            if (src[i] == c && !found) {
                found = true;
                char[] val = p.toCharArray();
                for (int k = 0; k < val.length; ++k) {
                    dest[j++] = val[k];
                }
                continue;
            }
            dest[j++] = src[i];
        }
        return new String(dest);
    }

    public static String FormatString(String message, char c, double p) {
        return Util.FormatString(message, c, String.valueOf(p));
    }

    public static boolean copyFile(String src, String dst) {
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(src));
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(dst));
            Util.copyFile(is, os);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean copyFile(InputStream in, OutputStream out) {
        if (in == null || out == null) {
            return false;
        }
        try {
            int b;
            while ((b = in.read()) != -1) {
                out.write(b);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static Document checkXml(File file) {
        try {
            return Util.checkXml(new InputSource(new BufferedInputStream(new FileInputStream(file))));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Document checkXml(InputSource is) {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(is);
        }
        catch (SAXParseException spe) {
            _LOG.log(Level.INFO, "** Parsing error, line " + spe.getLineNumber() + ", uri " + spe.getSystemId() + "\n   " + spe.getMessage(), spe);
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(null), "Parsing error, line " + spe.getLineNumber() + ", uri " + spe.getSystemId() + "\n   " + spe.getMessage(), "Error", 0);
            return null;
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(null), "Parsing error : " + x.getMessage(), "Error", 0);
            x.printStackTrace();
            return null;
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(null), "Parsing error : " + pce.getMessage(), "Error", 0);
            return null;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(null), "Parsing error : " + ioe.getMessage(), "Error", 0);
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(null), "Parsing error : " + e.getMessage(), "Error", 0);
            return null;
        }
        return document;
    }
}

