/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing.list;

import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

public class ArrayListModel<T>
extends AbstractListModel
implements ComboBoxModel {
    ArrayList<T> _array;
    Object _selected;

    public ArrayListModel() {
        this._array = new ArrayList();
        this._selected = null;
    }

    public ArrayListModel(List<T> model) {
        this._array = new ArrayList<T>(model);
        this._selected = null;
    }

    public List<T> getList() {
        return this._array;
    }

    public void setList(List<T> list) {
        if (this._array != null) {
            this.clear();
        }
        this._array = new ArrayList<T>(list);
        this.fireIntervalAdded(this, 0, this._array.size());
    }

    @Override
    public int getSize() {
        return this._array.size();
    }

    @Override
    public T getElementAt(int index) {
        return this._array.get(index);
    }

    public T get(int index) {
        return this._array.get(index);
    }

    public void update(int index) {
        this.fireContentsChanged(this, index, index);
    }

    public void update(T obj) {
        if (obj == null) {
            return;
        }
        int idx = this._array.indexOf(obj);
        if (idx == -1) {
            return;
        }
        this.update(idx);
    }

    public void insertAt(int index, T obj) {
        index = index == -1 ? this._array.size() : ++index;
        this._array.add(index, obj);
        this.fireIntervalAdded(this, index, index);
    }

    public void clear() {
        int size = this._array.size();
        this._array.clear();
        if (size > 0) {
            this.fireIntervalRemoved(this, 0, size);
        }
    }

    public void removeAt(int index) {
        this._array.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    public void down(int idx) {
        assert (idx >= 0 && idx < this._array.size() - 1) : Integer.toString(idx);
        T obj = this._array.remove(idx);
        this._array.add(idx + 1, obj);
        this.fireContentsChanged(this, idx, idx + 1);
    }

    public void up(int idx) {
        assert (idx > 0 && idx <= this._array.size() - 1) : Integer.toString(idx);
        T obj = this._array.remove(idx);
        this._array.add(idx - 1, obj);
        this.fireContentsChanged(this, idx - 1, idx);
    }

    @Override
    public Object getSelectedItem() {
        return this._selected;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this._selected = anItem;
        this.fireContentsChanged(this, 0, this._array.size());
    }
}

