/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

public class ListComboBoxModel<T>
extends AbstractListModel
implements ComboBoxModel {
    ArrayList<T> _list = new ArrayList();
    Comparator<? super T> _comparator;
    Object _selectedObject;

    public ListComboBoxModel(Comparator<? super T> comparator) {
        this._comparator = comparator;
    }

    public void setList(Collection<? super T> list) {
        this.clear();
        for (T obj : list) {
            if (this._list.contains(obj)) continue;
            this._list.add(obj);
        }
        this.update();
    }

    public void clear() {
        this._list.clear();
    }

    public void add(T grp) {
        if (!this._list.contains(grp)) {
            this._list.add(grp);
        }
    }

    public void update() {
        Collections.sort(this._list, this._comparator);
        this.fireContentsChanged(this, -1, -1);
    }

    @Override
    public int getSize() {
        return this._list.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this._list.get(index);
    }

    @Override
    public void setSelectedItem(Object anObject) {
        if (this._selectedObject != null && !this._selectedObject.equals(anObject) || this._selectedObject == null && anObject != null) {
            this._selectedObject = anObject;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    @Override
    public Object getSelectedItem() {
        return this._selectedObject;
    }
}

