/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing.other;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class FileFilterExtention
extends FileFilter {
    String _description;
    ArrayList<String> _extentions;
    boolean _read;
    boolean _write;

    public FileFilterExtention(String description, String ext) {
        this._description = description;
        this._extentions = new ArrayList();
        this.addExtention(ext);
        this._read = false;
        this._write = false;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    public FileFilterExtention verifyRead(boolean read) {
        this._read = read;
        return this;
    }

    public FileFilterExtention verifyWrite(boolean write) {
        this._write = write;
        return this;
    }

    public FileFilterExtention addExtention(String ext) {
        StringTokenizer st = new StringTokenizer(ext, ";");
        while (st.hasMoreTokens()) {
            this._extentions.add(st.nextToken());
        }
        return this;
    }

    public boolean verifyExtention(File f) {
        String pathname = f.getPath().toLowerCase();
        for (int i = this._extentions.size() - 1; i >= 0; --i) {
            if (!pathname.endsWith(this._extentions.get(i))) continue;
            return true;
        }
        return false;
    }

    public boolean verifyReadWrite(File f) {
        if (this._read && !f.canRead()) {
            return false;
        }
        return !this._write || f.canWrite();
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        if (!f.isFile()) {
            return false;
        }
        if (!this.verifyExtention(f)) {
            return false;
        }
        return this.verifyReadWrite(f);
    }

    public File addDefaultExtention(File f) {
        if (!this.verifyExtention(f)) {
            f = new File(f.getAbsolutePath() + this._extentions.get(0));
        }
        return f;
    }

    public String removeDefaultExtention(File f) {
        String pathname = f.getPath().toLowerCase();
        for (int i = this._extentions.size() - 1; i >= 0; --i) {
            if (!pathname.endsWith(this._extentions.get(i))) continue;
            return f.getPath().substring(0, pathname.length() - this._extentions.get(i).length());
        }
        return pathname;
    }

    public static File addDefaultExtention(JFileChooser fileChooser) {
        FileFilter filter = fileChooser.getFileFilter();
        File f = fileChooser.getSelectedFile();
        if (filter instanceof FileFilterExtention) {
            f = ((FileFilterExtention)filter).addDefaultExtention(f);
        }
        return f;
    }
}

