/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing.other;

import com.dassault.cecilia.core.ResMsgVoc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;

public abstract class SplashScreenGui {
    private JWindow _splashWindow = null;
    private JPanel _ctrlContentPane = null;
    private JLabel _ctrlLabelImage = null;
    private JLabel _ctrlLabelInfos = null;
    private JLabel _ctrlLabelVersion = null;
    private JLabel _ctrlLabelCopyright = null;
    private JFrame _owner;
    private long _waitTime;

    public SplashScreenGui(JFrame parentFrame, long waitTime) {
        this._owner = parentFrame;
        this._waitTime = waitTime;
        this.getSplashWindow();
    }

    private JWindow getSplashWindow() {
        if (this._splashWindow == null) {
            this._splashWindow = new JWindow(this._owner);
            this._splashWindow.setContentPane(this.getJContentPane());
            this._splashWindow.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    SplashScreenGui.this._splashWindow.setVisible(false);
                    SplashScreenGui.this._splashWindow.dispose();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    SplashScreenGui.this._splashWindow.setVisible(false);
                    SplashScreenGui.this._splashWindow.dispose();
                }
            });
            this._splashWindow.pack();
            this._splashWindow.setLocationRelativeTo(null);
            if (this._waitTime > 0L) {
                Thread waitThread = new Thread("SplashScreen invalidate"){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(SplashScreenGui.this._waitTime);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        SplashScreenGui.this._splashWindow.setVisible(false);
                        SplashScreenGui.this._splashWindow.dispose();
                    }
                };
                waitThread.start();
            }
        }
        return this._splashWindow;
    }

    private JPanel getJContentPane() {
        if (this._ctrlContentPane == null) {
            Font f;
            String copyright = this.getCopyright();
            if (copyright != null && !copyright.isEmpty()) {
                this._ctrlLabelCopyright = new JLabel(copyright);
                this._ctrlLabelCopyright.setForeground(Color.black);
                this._ctrlLabelCopyright.setOpaque(false);
                f = this._ctrlLabelCopyright.getFont();
                this._ctrlLabelCopyright.setFont(new Font(f.getName(), 1, 10));
            }
            this._ctrlLabelInfos = new JLabel();
            this._ctrlLabelInfos.setForeground(Color.black);
            this._ctrlLabelInfos.setOpaque(false);
            this._ctrlLabelInfos.setText(this.getInfos());
            f = this._ctrlLabelInfos.getFont();
            this._ctrlLabelInfos.setFont(new Font(f.getName(), 0, f.getSize()));
            String version = this.getVersion();
            if (version != null && !version.isEmpty()) {
                this._ctrlLabelVersion = new JLabel(version);
                this._ctrlLabelVersion.setForeground(Color.black);
                this._ctrlLabelVersion.setOpaque(false);
                Font f2 = this._ctrlLabelVersion.getFont();
                this._ctrlLabelInfos.setFont(new Font(f2.getName(), 0, f2.getSize()));
            }
            this._ctrlLabelImage = new JLabel(this.getImageIcon());
            this._ctrlContentPane = new JPanel(new GridBagLayout());
            this._ctrlContentPane.setBackground(Color.white);
            if (this._ctrlLabelCopyright != null) {
                this._ctrlContentPane.add((Component)this._ctrlLabelCopyright, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 15, 0, new Insets(0, 0, 80, 0), 0, 0));
            }
            if (this._ctrlLabelVersion != null) {
                this._ctrlContentPane.add((Component)this._ctrlLabelVersion, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 0, 40, 20), 0, 0));
            }
            this._ctrlContentPane.add((Component)this._ctrlLabelInfos, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 0, 20, 20), 0, 0));
            this._ctrlContentPane.add((Component)this._ctrlLabelImage, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        }
        return this._ctrlContentPane;
    }

    protected abstract ImageIcon getImageIcon();

    protected String getInfos() {
        return ResMsgVoc.getString("VOC_VERSION") + " 6.3.1";
    }

    protected String getCopyright() {
        return null;
    }

    protected String getVersion() {
        return null;
    }

    public void setVisible(boolean isVisible) {
        this._splashWindow.setVisible(isVisible);
        if (!isVisible) {
            this._splashWindow.dispose();
        }
    }
}

