/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing.other;

import java.awt.Graphics;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JTextField;

public class ValueTextField
extends JTextField {
    public static final int _FORMAT_STRING = 1;
    public static final int _FORMAT_DATE = 2;
    public static final int _FORMAT_INTEGER = 3;
    public static final int _FORMAT_DOUBLE = 4;
    public static final int _FORMAT_JOUR = 5;
    private int _maxLength;
    private int _indexMois;
    private int _format;
    private String _oldString;
    private int _nbDecimale;
    private SimpleDateFormat _dateFormat;

    @Override
    public String getText() {
        return super.getText();
    }

    public int getIndexMois() {
        return this._indexMois;
    }

    @Override
    public void setText(String chaine) {
        if (chaine == null) {
            chaine = new String("");
        }
        if (this._format == 2) {
            super.setText(chaine.toUpperCase());
            this._oldString = new String(chaine.toUpperCase());
        } else {
            if (!ValueTextField.isValid(chaine)) {
                chaine = ValueTextField.convertTextValie(chaine);
            }
            super.setText(chaine);
            this._oldString = new String(chaine);
        }
    }

    public void setStringFormat(int maxLength) {
        this._format = 1;
        this._maxLength = maxLength;
    }

    public void setStringFormat() {
        this._format = 1;
        this._maxLength = -1;
    }

    public void setJourFormat(int index) {
        this._format = 5;
        this._indexMois = index;
        this._maxLength = 2;
    }

    public void setIntegerFormat(int maxLength) {
        this._format = 3;
        this._maxLength = maxLength;
    }

    public void setIntegerFormat() {
        this._format = 3;
        this._maxLength = -1;
    }

    public void setDoubleFormat(int maxLength, int nbDecimale) {
        this._format = 4;
        this._maxLength = maxLength;
        this._nbDecimale = nbDecimale;
    }

    public void setDoubleFormat() {
        this._format = 4;
        this._maxLength = -1;
        this._nbDecimale = -1;
    }

    public void setDateFormat() {
        this._format = 2;
        this._maxLength = 10;
        this._dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    }

    public void setDDMMYYYYDateFormat() {
        this._format = 2;
        this._maxLength = 10;
    }

    public boolean checkDDMMYYYYDateFormat() {
        StringTokenizer tokenizer = new StringTokenizer(this.getText(), "/");
        String year = "";
        String month = "";
        String day = "";
        try {
            day = tokenizer.nextToken();
            month = tokenizer.nextToken();
            year = tokenizer.nextToken();
            if (day.length() != 2) {
                return false;
            }
            if (month.length() != 2) {
                return false;
            }
            if (year.length() != 4) {
                return false;
            }
        }
        catch (NoSuchElementException ex) {
            return false;
        }
        return true;
    }

    public boolean checkDateFormat() {
        try {
            Date date = this._dateFormat.parse(this.getText());
            String dateString = this._dateFormat.format(date);
            if (!dateString.equals(this.getText())) {
                return false;
            }
        }
        catch (ParseException ex) {
            return false;
        }
        return true;
    }

    public ValueTextField(String valeur, int taille, int maxLength) {
        super(valeur, taille);
        this._oldString = valeur;
        this._maxLength = maxLength;
        this._format = 1;
    }

    public ValueTextField(String valeur) {
        super(valeur);
        this._oldString = valeur;
        this._maxLength = -1;
        this._format = 1;
    }

    public int getMaxLength() {
        return this._maxLength;
    }

    public static boolean isValid(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c != '&' && c != '\n' && c != '\t' && c >= ' ' && (c < '\u007f' || c > '\u00a0') && c <= '\u00ff' && c != '/' && c != '\'' && c != '\u00b5' && c != ',') continue;
            return false;
        }
        return true;
    }

    public static String convertTextValie(String value) {
        StringBuffer sb = new StringBuffer(value.length() + 1);
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '&' || c == '\n' || c == '\t' || c < ' ' || c >= '\u007f' && c <= '\u00a0' || c > '\u00ff' || c == '/' || c == '\'' || c == '\u00b5' || c == ',') {
                sb.append("_");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public void paint(Graphics g) {
        switch (this._format) {
            case 3: {
                try {
                    if (!this.getText().equals("")) {
                        Integer.parseInt(this.getText());
                    }
                    if (this._maxLength != -1) {
                        if (this.getText().length() > this._maxLength) {
                            this.setText(this._oldString);
                            break;
                        }
                        this._oldString = this.getText();
                        break;
                    }
                    this._oldString = this.getText();
                }
                catch (NumberFormatException excep) {
                    this.setText(this._oldString);
                }
                break;
            }
            case 5: {
                try {
                    if (!this.getText().equals("")) {
                        int valeur = Integer.parseInt(this.getText());
                        boolean fin = false;
                        switch (this._indexMois) {
                            case 1: 
                            case 3: 
                            case 5: 
                            case 7: 
                            case 8: 
                            case 10: 
                            case 12: {
                                if (valeur >= 1 && valeur <= 31) break;
                                fin = true;
                                break;
                            }
                            case 2: {
                                if (valeur >= 1 && valeur <= 28) break;
                                fin = true;
                                break;
                            }
                            case 4: 
                            case 6: 
                            case 9: 
                            case 11: {
                                if (valeur >= 1 && valeur <= 30) break;
                                fin = true;
                            }
                        }
                        if (fin) {
                            this.setText(this._oldString);
                            break;
                        }
                    }
                    if (this._maxLength != -1) {
                        if (this.getText().length() > this._maxLength) {
                            this.setText(this._oldString);
                            break;
                        }
                        this._oldString = this.getText();
                        break;
                    }
                    this._oldString = this.getText();
                }
                catch (NumberFormatException excep) {
                    this.setText(this._oldString);
                }
                break;
            }
            case 1: {
                if (this._maxLength != -1) {
                    if (this.getText().length() > this._maxLength || !ValueTextField.isValid(this.getText())) {
                        this.setText(this._oldString);
                        break;
                    }
                    this._oldString = this.getText();
                    break;
                }
                this._oldString = this.getText();
                break;
            }
            case 2: {
                if (this._maxLength != -1) {
                    if (this.getText().length() > this._maxLength || this.getText().indexOf("[") != -1 || this.getText().indexOf("]") != -1 || this.getText().indexOf("'") != -1) {
                        this.setText(this._oldString);
                        break;
                    }
                    this._oldString = this.getText().toUpperCase();
                    break;
                }
                this._oldString = this.getText();
                break;
            }
            case 4: {
                if (this.getText().equals("")) break;
                int positionPoint = this.getText().indexOf(".");
                if (this._maxLength != -1 && this.getText().length() > this._maxLength) {
                    this.setText(this._oldString);
                    break;
                }
                if (positionPoint != -1) {
                    if (positionPoint != 0) {
                        String partieEntiere = this.getText().substring(0, positionPoint);
                        try {
                            Integer.parseInt(partieEntiere);
                        }
                        catch (NumberFormatException excep) {
                            this.setText(this._oldString);
                            break;
                        }
                    }
                    if (positionPoint != this.getText().length() - 1) {
                        String partieDecimale = this.getText().substring(positionPoint + 1);
                        try {
                            Integer.parseInt(partieDecimale);
                        }
                        catch (NumberFormatException excep) {
                            this.setText(this._oldString);
                            break;
                        }
                        if (partieDecimale.length() > this._nbDecimale) {
                            this.setText(this._oldString);
                            break;
                        }
                    }
                    this._oldString = this.getText();
                    break;
                }
                String partieEntiere = this.getText();
                try {
                    Integer.parseInt(partieEntiere);
                }
                catch (NumberFormatException excep) {
                    this.setText(this._oldString);
                    break;
                }
                this._oldString = this.getText();
            }
        }
        super.paint(g);
    }
}

