/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing.table;

import com.dassault.cecilia.core.swing.HtmlTransferable;
import com.dassault.cecilia.lib.util.format.Convertable;
import com.dassault.cecilia.lib.util.format.HtmlConverter;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.TransferHandler;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class JTableTransfertHandler
extends TransferHandler
implements UIResource {
    @Override
    protected Transferable createTransferable(JComponent c) {
        if (c instanceof JTable) {
            int[] cols;
            int counter;
            int[] rows;
            HelperConvert helper = null;
            JTable table = (JTable)c;
            if (c instanceof HelperConvert) {
                helper = (HelperConvert)((Object)c);
            }
            if (!table.getRowSelectionAllowed() && !table.getColumnSelectionAllowed()) {
                return null;
            }
            if (!table.getRowSelectionAllowed()) {
                int rowCount = table.getRowCount();
                rows = new int[rowCount];
                for (counter = 0; counter < rowCount; ++counter) {
                    rows[counter] = counter;
                }
            } else {
                rows = table.getSelectedRows();
            }
            if (!table.getColumnSelectionAllowed()) {
                int colCount = table.getColumnCount();
                cols = new int[colCount];
                for (counter = 0; counter < colCount; ++counter) {
                    cols[counter] = counter;
                }
            } else {
                cols = table.getSelectedColumns();
            }
            if (rows == null || cols == null || rows.length == 0 || cols.length == 0) {
                return null;
            }
            StringBuilder plainBuf = new StringBuilder();
            StringBuilder htmlBuf = new StringBuilder();
            HtmlConverter htmlConverter = new HtmlConverter();
            htmlBuf.append("<HTML>\n\n<BODY TEXT=\"#000000\">\n<TABLE FRAME=VOID CELLSPACING=0 RULES=NONE");
            htmlBuf.append(" COLS=").append(cols.length).append(" BORDER=0>\n");
            htmlBuf.append("  <COLGROUP>");
            for (int col = 0; col < cols.length; ++col) {
                htmlBuf.append("<COL WIDTH=").append(table.getColumnModel().getColumn(col).getWidth()).append(">");
            }
            htmlBuf.append("</COLGROUP>\n");
            htmlBuf.append("  <TBODY>\n");
            for (int row = 0; row < rows.length; ++row) {
                htmlBuf.append("    <TR>\n");
                for (int col = 0; col < cols.length; ++col) {
                    Object obj = table.getValueAt(rows[row], cols[col]);
                    String humanValue = "";
                    String htmlValue = null;
                    if (helper != null) {
                        humanValue = helper.convertToString(obj, rows[row], cols[col]);
                    } else if (obj != null && obj instanceof Convertable) {
                        humanValue = ((Convertable)obj).convertToString();
                        htmlValue = ((Convertable)obj).convertToHTML();
                    } else {
                        humanValue = obj == null ? "" : obj.toString();
                    }
                    plainBuf.append(humanValue).append("\t");
                    if (htmlValue == null) {
                        htmlValue = htmlConverter.toHTML(humanValue);
                    }
                    htmlBuf.append("      <TD WIDTH=").append(table.getColumnModel().getColumn(col).getWidth());
                    if (col == 0) {
                        htmlBuf.append(" HEIGHT=").append(table.getRowHeight(row));
                    }
                    htmlBuf.append(">");
                    htmlBuf.append(htmlValue).append("</TD>\n");
                }
                plainBuf.deleteCharAt(plainBuf.length() - 1).append("\n");
                htmlBuf.append("    </TR>\n");
            }
            plainBuf.deleteCharAt(plainBuf.length() - 1);
            htmlBuf.append("  </TBODY>\n");
            htmlBuf.append("</TABLE>\n</BODY>\n\n</HTML>");
            return new HtmlTransferable(htmlBuf.toString(), plainBuf.toString());
        }
        return null;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    public static interface HelperConvert {
        public String convertToString(Object var1, int var2, int var3);
    }

    public static class JListTransferHandler
    extends JTableTransfertHandler {
        @Override
        protected Transferable createTransferable(JComponent c) {
            if (c instanceof JList) {
                final JList list = (JList)c;
                if (!(list instanceof HelperConvert)) {
                    return super.createTransferable(c);
                }
                ListModel listModel = list.getModel();
                int[] selectedIdxs = list.getSelectedIndices();
                Object[] valuesList = new Object[selectedIdxs.length];
                for (int i = 0; i < selectedIdxs.length; ++i) {
                    valuesList[i] = listModel.getElementAt(selectedIdxs[i]);
                }
                DefaultTableModel model = new DefaultTableModel(new Object[][]{valuesList}, new Object[]{"null"});
                JTableConvertString table = new JTableConvertString(model){

                    @Override
                    public String convertToString(Object obj, int row, int col) {
                        return ((HelperConvert)((Object)list)).convertToString(obj, row, col);
                    }
                };
                table.setRowSelectionInterval(0, table.getRowCount() - 1);
                table.setColumnSelectionInterval(0, 0);
                return super.createTransferable(table);
            }
            return super.createTransferable(c);
        }

        private static abstract class JTableConvertString
        extends JTable
        implements HelperConvert {
            public JTableConvertString(TableModel model) {
                super(model);
            }
        }
    }
}

