/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing.table;

import com.dassault.cecilia.core.swing.table.TableDecoredItem;
import com.dassault.cecilia.core.swing.table.TableModelWithError;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class TableDecoredModel<E extends TableDecoredItem>
extends AbstractTableModel
implements TableModelWithError {
    protected List<E> _array = new ArrayList();
    protected E _defTgt;
    boolean _editable = true;

    public TableDecoredModel(E defTgt) {
        this._defTgt = defTgt;
    }

    @Override
    public int getRowCount() {
        return this._array.size();
    }

    @Override
    public int getColumnCount() {
        return this._defTgt.getColumnCount();
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return this._defTgt.getColumnClass(c);
    }

    @Override
    public String getColumnName(int c) {
        return this._defTgt.getColumnName(c);
    }

    @Override
    public Object getValueAt(int r, int c) {
        E tgt = this.getData(r);
        return tgt.getValueAt(c);
    }

    @Override
    public void setValueAt(Object item, int r, int c) {
        E tgt = this.getData(r);
        if (tgt.setValueAt(item, c)) {
            this.fireTableRowsUpdated(r, r);
        }
    }

    public void setEditable(boolean b) {
        this._editable = b;
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        if (!this._editable) {
            return false;
        }
        E tgt = this.getData(r);
        return tgt.isCellEditable(c);
    }

    @Override
    public boolean withError(int r, int c) {
        E tgt = this.getData(r);
        return tgt.withError(c);
    }

    public boolean withError() {
        Iterator<E> i = this._array.iterator();
        while (i.hasNext()) {
            if (!((TableDecoredItem)i.next()).withError(-1)) continue;
            return true;
        }
        return false;
    }

    protected E createTarget(E obj) {
        if (obj != null) {
            return obj;
        }
        return (E)this._defTgt.getCopy();
    }

    public void setDatum(List<E> datum) {
        this._array = datum;
        this.fireTableDataChanged();
    }

    public E getData(int idx) {
        TableDecoredItem obj = (TableDecoredItem)this._array.get(idx);
        return (E)obj;
    }

    public void addData(E obj) {
        obj = this.createTarget(obj);
        int idx = this._array.size();
        this._array.add(obj);
        this.fireTableRowsInserted(idx, idx);
    }

    public void insertData(E obj, int idx) {
        obj = this.createTarget(obj);
        this._array.add(idx, obj);
        this.fireTableRowsInserted(idx, idx);
    }

    public void removeData(int idx) {
        this.fireTableRowsDeleted(idx, idx);
        this._array.remove(idx);
    }

    public void changeData(E obj) {
        int idx = this._array.indexOf(obj);
        if (idx >= 0) {
            this.fireTableRowsUpdated(idx, idx);
        }
    }

    public void down(int idx) {
        assert (idx > 0 && idx <= this._array.size() - 1) : Integer.toString(idx);
        TableDecoredItem obj = (TableDecoredItem)this._array.remove(idx);
        this._array.add(idx - 1, obj);
        this.fireTableRowsUpdated(idx - 1, idx);
    }

    public void up(int idx) {
        assert (idx >= 0 && idx < this._array.size() - 1) : Integer.toString(idx);
        TableDecoredItem obj = (TableDecoredItem)this._array.remove(idx);
        this._array.add(idx + 1, obj);
        this.fireTableRowsUpdated(idx, idx + 1);
    }
}

