/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing.tablesplit;

import com.dassault.cecilia.core.swing.tablesplit.CellAttribute;
import com.dassault.cecilia.core.swing.tablesplit.CellSpan;
import java.awt.Dimension;

public class DefaultCellAttribute
implements CellAttribute,
CellSpan {
    protected int _rowSize;
    protected int _columnSize;
    protected int[][][] _span;

    public DefaultCellAttribute() {
        this(1, 1);
    }

    public DefaultCellAttribute(int numRows, int numColumns) {
        this.setSize(new Dimension(numColumns, numRows));
    }

    protected void initValue() {
        for (int i = 0; i < this._span.length; ++i) {
            for (int j = 0; j < this._span[i].length; ++j) {
                this._span[i][j][1] = 1;
                this._span[i][j][0] = 1;
            }
        }
    }

    @Override
    public int[] getSpan(int row, int column) {
        if (this.isOutOfBounds(row, column)) {
            int[] ret_code = new int[]{1, 1};
            return ret_code;
        }
        return this._span[row][column];
    }

    @Override
    public void setSpan(int[] span, int row, int column) {
        if (this.isOutOfBounds(row, column)) {
            return;
        }
        this._span[row][column] = span;
    }

    @Override
    public boolean isVisible(int row, int column) {
        if (this.isOutOfBounds(row, column)) {
            return false;
        }
        return this._span[row][column][1] >= 1 && this._span[row][column][0] >= 1;
    }

    @Override
    public void combine(int[] rows, int[] columns) {
        int i;
        if (this.isOutOfBounds(rows, columns)) {
            return;
        }
        int rowSpan = rows.length;
        int columnSpan = columns.length;
        int startRow = rows[0];
        int startColumn = columns[0];
        for (i = 0; i < rowSpan; ++i) {
            for (int j = 0; j < columnSpan; ++j) {
                if (this._span[startRow + i][startColumn + j][1] == 1 && this._span[startRow + i][startColumn + j][0] == 1) continue;
                return;
            }
        }
        i = 0;
        int ii = 0;
        while (i < rowSpan) {
            int jj = 0;
            for (int j = 0; j < columnSpan; ++j) {
                this._span[startRow + i][startColumn + j][1] = jj--;
                this._span[startRow + i][startColumn + j][0] = ii;
            }
            ++i;
            --ii;
        }
        this._span[startRow][startColumn][1] = columnSpan;
        this._span[startRow][startColumn][0] = rowSpan;
    }

    @Override
    public void split(int row, int column) {
        if (this.isOutOfBounds(row, column)) {
            return;
        }
        int columnSpan = this._span[row][column][1];
        int rowSpan = this._span[row][column][0];
        for (int i = 0; i < rowSpan; ++i) {
            for (int j = 0; j < columnSpan; ++j) {
                this._span[row + i][column + j][1] = 1;
                this._span[row + i][column + j][0] = 1;
            }
        }
    }

    @Override
    public void addColumn() {
        int[][][] oldSpan = this._span;
        int numRows = oldSpan.length;
        int numColumns = oldSpan[0].length;
        this._span = new int[numRows][numColumns + 1][2];
        System.arraycopy(oldSpan, 0, this._span, 0, numRows);
        for (int i = 0; i < numRows; ++i) {
            this._span[i][numColumns][1] = 1;
            this._span[i][numColumns][0] = 1;
        }
    }

    @Override
    public void addRow() {
        int[][][] oldSpan = this._span;
        int numRows = oldSpan.length;
        int numColumns = oldSpan[0].length;
        this._span = new int[numRows + 1][numColumns][2];
        System.arraycopy(oldSpan, 0, this._span, 0, numRows);
        for (int i = 0; i < numColumns; ++i) {
            this._span[numRows][i][1] = 1;
            this._span[numRows][i][0] = 1;
        }
    }

    @Override
    public void insertRow(int row) {
        int[][][] oldSpan = this._span;
        int numRows = oldSpan.length;
        int numColumns = oldSpan[0].length;
        this._span = new int[numRows + 1][numColumns][2];
        if (0 < row) {
            System.arraycopy(oldSpan, 0, this._span, 0, row - 1);
        }
        System.arraycopy(oldSpan, 0, this._span, row, numRows - row);
        for (int i = 0; i < numColumns; ++i) {
            this._span[row][i][1] = 1;
            this._span[row][i][0] = 1;
        }
    }

    @Override
    public Dimension getSize() {
        return new Dimension(this._rowSize, this._columnSize);
    }

    @Override
    public void setSize(Dimension size) {
        this._columnSize = size.width;
        this._rowSize = size.height;
        this._span = new int[this._rowSize][this._columnSize][2];
        this.initValue();
    }

    protected boolean isOutOfBounds(int row, int column) {
        return row < 0 || this._rowSize <= row || column < 0 || this._columnSize <= column;
    }

    protected boolean isOutOfBounds(int[] rows, int[] columns) {
        int i;
        for (i = 0; i < rows.length; ++i) {
            if (rows[i] >= 0 && this._rowSize > rows[i]) continue;
            return true;
        }
        for (i = 0; i < columns.length; ++i) {
            if (columns[i] >= 0 && this._columnSize > columns[i]) continue;
            return true;
        }
        return false;
    }

    protected void setValues(Object[][] target, Object value, int[] rows, int[] columns) {
        for (int i = 0; i < rows.length; ++i) {
            int row = rows[i];
            for (int j = 0; j < columns.length; ++j) {
                int column = columns[j];
                target[row][column] = value;
            }
        }
    }
}

