/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing.tablesplit;

import com.dassault.cecilia.core.swing.tablesplit.AttributiveCellTableModel;
import com.dassault.cecilia.core.swing.tablesplit.CellSpan;
import com.dassault.cecilia.core.swing.tablesplit.MultiSpanCellTable;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;

public class MultiSpanCellTableExample
extends JFrame {
    MultiSpanCellTableExample() {
        super("Multi-Span Cell Example");
        AttributiveCellTableModel ml = new AttributiveCellTableModel(10, 6);
        final CellSpan cellAtt = (CellSpan)((Object)ml.getCellAttribute());
        final MultiSpanCellTable table = new MultiSpanCellTable(ml);
        JScrollPane scroll = new JScrollPane(table);
        JButton b_one = new JButton("Combine");
        b_one.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] columns = table.getSelectedColumns();
                int[] rows = table.getSelectedRows();
                cellAtt.combine(rows, columns);
                table.clearSelection();
                table.revalidate();
                table.repaint();
            }
        });
        JButton b_split = new JButton("Split");
        b_split.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int column = table.getSelectedColumn();
                int row = table.getSelectedRow();
                cellAtt.split(row, column);
                table.clearSelection();
                table.revalidate();
                table.repaint();
            }
        });
        JPanel p_buttons = new JPanel();
        p_buttons.setLayout(new GridLayout(2, 1));
        p_buttons.add(b_one);
        p_buttons.add(b_split);
        Box box = new Box(0);
        box.add(scroll);
        box.add(new JSeparator(0));
        box.add(p_buttons);
        this.getContentPane().add(box);
        this.setSize(400, 200);
        this.setVisible(true);
    }

    public static void main(String[] args) {
        MultiSpanCellTableExample frame = new MultiSpanCellTableExample();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }
}

