/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing.tree;

import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class JTreeUtility {
    protected static void findExpandedPath_rec(Configuration config, JTree tree, TreePath current) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)current.getLastPathComponent();
        if (node.isLeaf()) {
            return;
        }
        if (tree.isExpanded(current)) {
            config.addExpandedPath(current);
        }
        for (int i = node.getChildCount() - 1; i >= 0; --i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            if (child.isLeaf()) continue;
            JTreeUtility.findExpandedPath_rec(config, tree, current.pathByAddingChild(child));
        }
    }

    public static Configuration saveConfiguration(JTree tree) {
        if (!(tree.getModel().getRoot() instanceof DefaultMutableTreeNode)) {
            throw new IllegalArgumentException();
        }
        Configuration config = new Configuration(tree.getSelectionPaths());
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getModel().getRoot();
        JTreeUtility.findExpandedPath_rec(config, tree, new TreePath(node));
        return config;
    }

    protected static TreePath convertTreePathDefaultMutableTreeNode(JTree tree, TreePath src) {
        Object userObj = ((DefaultMutableTreeNode)src.getLastPathComponent()).getUserObject();
        if (src.getParentPath() == null) {
            DefaultMutableTreeNode dstRoot = (DefaultMutableTreeNode)tree.getModel().getRoot();
            if (dstRoot.getUserObject() == userObj) {
                return new TreePath(dstRoot);
            }
            return null;
        }
        TreePath dstTreeParent = JTreeUtility.convertTreePathDefaultMutableTreeNode(tree, src.getParentPath());
        if (dstTreeParent == null) {
            return null;
        }
        DefaultMutableTreeNode dstNodeParent = (DefaultMutableTreeNode)dstTreeParent.getLastPathComponent();
        for (int i = dstNodeParent.getChildCount() - 1; i >= 0; --i) {
            DefaultMutableTreeNode dstNode = (DefaultMutableTreeNode)dstNodeParent.getChildAt(i);
            if (dstNode.getUserObject() != userObj) continue;
            return dstTreeParent.pathByAddingChild(dstNode);
        }
        return dstTreeParent;
    }

    public static void loadConfiguration(JTree tree, Configuration config) {
        if (config._expandedPath.size() > 0) {
            for (int i = 0; i < config._expandedPath.size(); ++i) {
                TreePath expand = JTreeUtility.convertTreePathDefaultMutableTreeNode(tree, config._expandedPath.get(i));
                if (expand == null) continue;
                tree.expandPath(expand);
            }
        }
        if (config._selectedPath != null) {
            ArrayList<TreePath> selects = new ArrayList<TreePath>(config._selectedPath.length + 1);
            for (int i = 0; i < config._selectedPath.length; ++i) {
                TreePath select = JTreeUtility.convertTreePathDefaultMutableTreeNode(tree, config._selectedPath[i]);
                if (select == null) continue;
                selects.add(select);
            }
            if (selects.size() > 0) {
                TreePath[] pathSelects = new TreePath[selects.size()];
                tree.setSelectionPaths(selects.toArray(pathSelects));
            }
        }
    }

    public static class Configuration {
        TreePath[] _selectedPath;
        ArrayList<TreePath> _expandedPath = new ArrayList();

        Configuration(TreePath[] selectedPath) {
            this._selectedPath = selectedPath;
        }

        void addExpandedPath(TreePath path) {
            this._expandedPath.add(path);
        }
    }
}

