/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing.tree;

import com.dassault.cecilia.core.swing.table.JTableTransfertHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeTable<T>
extends JTable
implements JTableTransfertHandler.HelperConvert {
    protected CustomJTree _tree;
    protected TreeTableModel _model;
    protected TreeTableModelAdapter _modelTableAdapter;

    public TreeTable(TreeTableModel model) {
        this._model = model;
        this.setTransferHandler(new JTableTransfertHandler());
        this._tree = new CustomJTree();
        this._tree.setModel(this._model);
        this._tree.setEditable(false);
        this._modelTableAdapter = new TreeTableModelAdapter(this._model);
        super.setModel(this._modelTableAdapter);
        this._tree.setSelectionModel(new DefaultTreeSelectionModel(){
            {
                TreeTable.this.setSelectionModel(this.listSelectionModel);
            }
        });
        this.setAutoCreateColumnsFromModel(false);
        this.getColumnModel().getColumn(0).setCellRenderer(new TreeTableCellRenderer());
        this.getColumnModel().getColumn(0).setCellEditor(new TreeTableCellEditor());
        this.setShowGrid(false);
        this.setRowMargin(0);
        this.addMouseListener(new MouseHandler());
        this.addKeyListener(new KeyHandler());
        this.getColumnModel().getColumn(0).addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("width")) {
                    int width = ((Number)e.getNewValue()).intValue();
                    int height = TreeTable.this._tree.getSize().height;
                    TreeTable.this._tree.setSize(width, height);
                }
            }
        });
    }

    @Override
    public String convertToString(Object obj, int row, int col) {
        if (this._model instanceof JTableTransfertHandler.HelperConvert && col == 0) {
            TreePath treePath = this._tree.getPathForRow(row);
            return ((JTableTransfertHandler.HelperConvert)((Object)this._model)).convertToString(treePath.getLastPathComponent(), row, col);
        }
        if (this.getModel() instanceof JTableTransfertHandler.HelperConvert) {
            return ((JTableTransfertHandler.HelperConvert)((Object)this.getModel())).convertToString(obj, row, col);
        }
        return obj == null ? "" : obj.toString();
    }

    public JTree getTree() {
        return this._tree;
    }

    @Override
    public AbstractTableModel getModel() {
        return (AbstractTableModel)super.getModel();
    }

    public T getObjectAtRow(int row) {
        TreePath treePath = this._tree.getPathForRow(row);
        return (T)treePath.getLastPathComponent();
    }

    public void expandPath(TreePath path) {
        this._tree.expandPath(path);
    }

    public void expandRow(int row) {
        this._tree.expandRow(row);
    }

    public static interface TreeTableModel<T>
    extends TreeModel {
        public int getColumnCount();

        public String getColumnName(int var1);

        public Class getColumnClass(int var1);

        public Object getValueAt(T var1, int var2, int var3);

        public boolean isCellEditable(T var1, int var2, int var3);

        public void setValueAt(Object var1, T var2, int var3, int var4);
    }

    class CustomJTree
    extends JTree {
        protected int _visibleRow;

        CustomJTree() {
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setRowHeight(0);
        }

        public void setVisibleRow(int row) {
            this._visibleRow = row;
        }

        @Override
        public void paint(Graphics g) {
            Rectangle rowBounds = this.getRowBounds(this._visibleRow);
            g.translate(0, -rowBounds.y);
            Rectangle oldClip = g.getClipBounds();
            int newY = Math.max(oldClip.y, rowBounds.y);
            int newHeight = Math.min(rowBounds.height - (rowBounds.y - newY), oldClip.height);
            g.setClip(oldClip.x, newY, oldClip.width, newHeight);
            super.paint(g);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(super.getPreferredSize().width, this.getRowBounds((int)this._visibleRow).height);
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
        }

        @Override
        public void repaint(Rectangle r) {
        }

        @Override
        public void setRootVisible(boolean value) {
            boolean oldValue = this.isRootVisible();
            if (oldValue != value) {
                super.setRootVisible(value);
                TreeTable.this._modelTableAdapter.fireTableDataChanged();
            }
        }
    }

    class TreeTableModelAdapter
    extends AbstractTableModel
    implements JTableTransfertHandler.HelperConvert {
        public TreeTableModelAdapter(TreeTableModel treeTableModel) {
            TreeTable.this._tree.addTreeExpansionListener(new TreeExpansionListener(){

                @Override
                public void treeExpanded(TreeExpansionEvent event) {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                    int row = TreeTable.this._tree.getRowForPath(event.getPath());
                    if (row == -1) {
                        return;
                    }
                    TreeTable.this.clearSelection();
                    TreeTable.this.addRowSelectionInterval(row, row);
                }

                @Override
                public void treeCollapsed(TreeExpansionEvent event) {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                    int row = TreeTable.this._tree.getRowForPath(event.getPath());
                    if (row == -1) {
                        return;
                    }
                    TreeTable.this.clearSelection();
                    TreeTable.this.addRowSelectionInterval(row, row);
                }
            });
            TreeTable.this._tree.getModel().addTreeModelListener(new TreeModelListener(){

                @Override
                public void treeNodesChanged(TreeModelEvent e) {
                    int row = TreeTable.this._tree.getRowForPath(e.getTreePath());
                    if (row < 0) {
                        return;
                    }
                    int[] indices = e.getChildIndices();
                    if (indices.length == 0) {
                        return;
                    }
                    TreeTableModelAdapter.this.fireTableRowsUpdated(row + 1 + indices[0], row + 1 + indices[indices.length - 1]);
                }

                @Override
                public void treeNodesInserted(TreeModelEvent e) {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent e) {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }

                @Override
                public void treeStructureChanged(TreeModelEvent e) {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }
            });
        }

        @Override
        public int getColumnCount() {
            return TreeTable.this._model.getColumnCount();
        }

        @Override
        public String getColumnName(int column) {
            return TreeTable.this._model.getColumnName(column);
        }

        public Class getColumnClass(int column) {
            if (column == 0) {
                return TreeTableModel.class;
            }
            return TreeTable.this._model.getColumnClass(column);
        }

        @Override
        public int getRowCount() {
            return TreeTable.this._tree.getRowCount();
        }

        protected Object nodeForRow(int row) {
            TreePath treePath = TreeTable.this._tree.getPathForRow(row);
            return treePath.getLastPathComponent();
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return TreeTable.this._model;
            }
            return TreeTable.this._model.getValueAt(this.nodeForRow(row), row, column);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return TreeTable.this._model.isCellEditable(this.nodeForRow(row), row, column);
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            Object node = this.nodeForRow(row);
            TreeTable.this._model.setValueAt(value, node, row, column);
        }

        @Override
        public String convertToString(Object obj, int row, int col) {
            Object realObj;
            if (TreeTable.this._model instanceof JTableTransfertHandler.HelperConvert) {
                return ((JTableTransfertHandler.HelperConvert)((Object)TreeTable.this._model)).convertToString(obj, row, col);
            }
            Object object = realObj = col == 0 ? this.nodeForRow(row) : obj;
            if (realObj == null) {
                return "";
            }
            return realObj.toString();
        }
    }

    public class TreeTableCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            TreeTable.this._tree.setVisibleRow(row);
            return TreeTable.this._tree;
        }
    }

    class TreeTableCellEditor
    extends DefaultCellEditor {
        TreeCellEditor _editor;
        Component _editorComponent;

        TreeTableCellEditor() {
            super(new JTextField());
            this._editor = TreeTable.this._tree.getCellEditor();
            this.setClickCountToStart(0);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this._editor = TreeTable.this._tree.getCellEditor();
            if (this._editor == null) {
                return null;
            }
            this._editor.addCellEditorListener(new CellEditorListener(){

                @Override
                public void editingStopped(ChangeEvent e) {
                    TreeTableCellEditor.this.fireEditingStopped();
                }

                @Override
                public void editingCanceled(ChangeEvent e) {
                    TreeTableCellEditor.this.fireEditingCanceled();
                }
            });
            this._editorComponent = this._editor.getTreeCellEditorComponent(TreeTable.this._tree, TreeTable.this._tree.getPathForRow(row).getLastPathComponent(), isSelected, TreeTable.this._tree.isExpanded(row), TreeTable.this._tree.getModel().isLeaf(TreeTable.this._tree.getPathForRow(row).getLastPathComponent()), row);
            Box box = Box.createHorizontalBox();
            box.add(Box.createHorizontalStrut(TreeTable.this._tree.getRowBounds((int)row).x));
            box.add(this._editorComponent);
            return box;
        }

        @Override
        public Object getCellEditorValue() {
            return this._editor == null ? null : this._editor.getCellEditorValue();
        }

        @Override
        public boolean stopCellEditing() {
            return this._editor == null ? true : this._editor.stopCellEditing();
        }

        @Override
        public void cancelCellEditing() {
            if (this._editor != null) {
                this._editor.cancelCellEditing();
            }
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (TreeTable.this.columnAtPoint(e.getPoint()) == 0) {
                TreeTable.this._tree.dispatchEvent(this.convertEvent(e));
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (TreeTable.this.columnAtPoint(e.getPoint()) == 0) {
                TreeTable.this._tree.dispatchEvent(this.convertEvent(e));
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (TreeTable.this.columnAtPoint(e.getPoint()) == 0) {
                TreeTable.this._tree.dispatchEvent(this.convertEvent(e));
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (TreeTable.this.columnAtPoint(e.getPoint()) == 0) {
                TreeTable.this._tree.dispatchEvent(this.convertEvent(e));
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (TreeTable.this.columnAtPoint(e.getPoint()) == 0) {
                TreeTable.this._tree.dispatchEvent(this.convertEvent(e));
            }
        }

        protected MouseEvent convertEvent(MouseEvent e) {
            int column = 0;
            int row = TreeTable.this.rowAtPoint(e.getPoint());
            Rectangle tableCellRect = TreeTable.this.getCellRect(row, column, false);
            Rectangle treeCellRect = TreeTable.this._tree.getRowBounds(row);
            int dx = 0;
            if (tableCellRect != null) {
                dx = -tableCellRect.x;
            }
            int dy = 0;
            if (tableCellRect != null && treeCellRect != null) {
                dy = treeCellRect.y - tableCellRect.y;
            }
            e.translatePoint(dx, dy);
            return new MouseEvent(TreeTable.this._tree, e.getID(), e.getWhen(), e.getModifiersEx(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            boolean right = false;
            if (e.getKeyCode() == 39) {
                right = true;
            } else if (e.getKeyCode() != 37) {
                return;
            }
            int row = TreeTable.this.getSelectionModel().getLeadSelectionIndex();
            TreePath path = TreeTable.this._tree.getPathForRow(row);
            if (path == null) {
                return;
            }
            if (right) {
                if (TreeTable.this._tree.isCollapsed(path)) {
                    TreeTable.this._tree.expandPath(path);
                } else {
                    Object userTree = path.getLastPathComponent();
                    if (userTree != null && !TreeTable.this._tree.getModel().isLeaf(userTree) && TreeTable.this._tree.getModel().getChildCount(userTree) > 0) {
                        path = path.pathByAddingChild(TreeTable.this._tree.getModel().getChild(userTree, 0));
                        TreeTable.this._tree.setSelectionPath(path);
                    }
                }
            } else if (!TreeTable.this._tree.isCollapsed(path)) {
                TreeTable.this._tree.collapsePath(path);
            } else {
                TreeTable.this._tree.setSelectionPath(path.getParentPath());
            }
        }
    }
}

