/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.taskmanager;

import com.dassault.cecilia.core.plugin.PlugTask;
import com.dassault.cecilia.core.taskmanager.ProgressPanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class InfiniteProgressPanel
extends ProgressPanel {
    protected Area[] _ticker = null;
    protected Animator _animation = null;
    protected boolean _started = false;
    protected int _alphaLevel = 0;
    protected int _rampDelay = 300;
    protected float _shield = 0.7f;
    protected String _text = "";
    protected int _barsCount = 14;
    protected float _fps = 15.0f;
    protected PlugTask _task = null;
    protected Rectangle _refreshTimeArea = null;
    protected Rectangle _refreshMsgArea = null;
    protected String _refreshMsgTxt = null;
    protected RenderingHints hints = null;

    public InfiniteProgressPanel() {
        this("");
    }

    public InfiniteProgressPanel(String text) {
        this(text, 14);
    }

    public InfiniteProgressPanel(String text, int barsCount) {
        this(text, barsCount, 0.7f);
    }

    public InfiniteProgressPanel(String text, int barsCount, float shield) {
        this(text, barsCount, shield, 15.0f);
    }

    public InfiniteProgressPanel(String text, int barsCount, float shield, float fps) {
        this(text, barsCount, shield, fps, 300);
    }

    public InfiniteProgressPanel(String text, int barsCount, float shield, float fps, int rampDelay) {
        this._text = text;
        this._rampDelay = rampDelay >= 0 ? rampDelay : 0;
        this._shield = shield >= 0.0f ? shield : 0.0f;
        this._fps = fps > 0.0f ? fps : 15.0f;
        this._barsCount = barsCount > 0 ? barsCount : 14;
        this.hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }

    public void setText(String text) {
        this.repaint();
        this._text = text;
    }

    public String getText() {
        return this._text;
    }

    @Override
    public void start(PlugTask task) {
        this.addMouseListener(this);
        this.setVisible(true);
        this._task = task;
        this._ticker = this.buildTicker();
        this._animation = new Animator(0);
        this._animation.start();
    }

    @Override
    public void stop() {
        if (this._animation != null) {
            this._animation.requestState(2);
            this.removeMouseListener(this);
        }
    }

    public void interrupt() {
        if (this._animation != null) {
            this._animation.interrupt();
            this._animation = null;
            this.removeMouseListener(this);
            this.setVisible(false);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this._started) {
            Rectangle2D bounds;
            TextLayout layout;
            FontRenderContext context;
            int width = this.getWidth();
            double maxY = 0.0;
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHints(this.hints);
            g2.setColor(new Color(255, 255, 255, (int)((float)this._alphaLevel * this._shield)));
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            for (int i = 0; i < this._ticker.length; ++i) {
                int channel = 224 - 128 / (i + 1);
                g2.setColor(new Color(channel, channel, channel, this._alphaLevel));
                g2.fill(this._ticker[i]);
                Rectangle2D bounds2 = this._ticker[i].getBounds2D();
                if (!(bounds2.getMaxY() > maxY)) continue;
                maxY = bounds2.getMaxY();
            }
            String msg = this._text;
            String pp = null;
            if (this._task != null) {
                msg = this._task.getInfo("process.msg");
                pp = this._task.getInfo("process.msg.high");
            }
            if (msg != null && msg.length() > 0) {
                context = g2.getFontRenderContext();
                layout = new TextLayout(msg, this.getFont(), context);
                bounds = layout.getBounds();
                g2.setColor(this.getForeground());
                layout.draw(g2, (float)((double)width - bounds.getWidth()) / 2.0f, (float)(maxY + (double)layout.getLeading() + (double)(2.0f * layout.getAscent())));
            }
            if (pp != null && pp.length() > 0) {
                context = g2.getFontRenderContext();
                layout = new TextLayout(pp, this.getFont(), context);
                bounds = layout.getBounds();
                g2.setColor(this.getForeground());
                layout.draw(g2, (float)((double)width - bounds.getWidth()) / 2.0f, (float)((double)this.getHeight() + bounds.getHeight()) / 2.0f);
            }
        }
    }

    private Area[] buildTicker() {
        Area[] ticker = new Area[this._barsCount];
        Point2D.Double center = new Point2D.Double((double)this.getWidth() / 2.0, (double)this.getHeight() / 2.0);
        double fixedAngle = Math.PI * 2 / (double)this._barsCount;
        this._refreshTimeArea = new Rectangle(this.getWidth() / 2 - 100, this.getHeight() / 2 - 100, 200, 200);
        for (double i = 0.0; i < (double)this._barsCount; i += 1.0) {
            Area primitive = this.buildPrimitive();
            AffineTransform toCenter = AffineTransform.getTranslateInstance(center.getX(), center.getY());
            AffineTransform toBorder = AffineTransform.getTranslateInstance(45.0, -6.0);
            AffineTransform toCircle = AffineTransform.getRotateInstance(-i * fixedAngle, center.getX(), center.getY());
            AffineTransform toWheel = new AffineTransform();
            toWheel.concatenate(toCenter);
            toWheel.concatenate(toBorder);
            primitive.transform(toWheel);
            primitive.transform(toCircle);
            ticker[(int)i] = primitive;
        }
        return ticker;
    }

    private Area buildPrimitive() {
        Rectangle2D.Double body = new Rectangle2D.Double(6.0, 0.0, 30.0, 12.0);
        Ellipse2D.Double head = new Ellipse2D.Double(0.0, 0.0, 12.0, 12.0);
        Ellipse2D.Double tail = new Ellipse2D.Double(30.0, 0.0, 12.0, 12.0);
        Area tick = new Area(body);
        tick.add(new Area(head));
        tick.add(new Area(tail));
        return tick;
    }

    protected class Animator
    extends Thread {
        protected int _state;
        protected int _reqState;

        protected Animator(int state) {
            super("Cecilia-StartWait");
            this._state = -1;
            this._reqState = 0;
            this._reqState = state;
        }

        protected void requestState(int state) {
            this._reqState = state;
        }

        @Override
        public void run() {
            Point2D.Double center = new Point2D.Double((double)InfiniteProgressPanel.this.getWidth() / 2.0, (double)InfiniteProgressPanel.this.getHeight() / 2.0);
            double fixedIncrement = Math.PI * 2 / (double)InfiniteProgressPanel.this._barsCount;
            AffineTransform toCircle = AffineTransform.getRotateInstance(fixedIncrement, center.getX(), center.getY());
            long start = System.currentTimeMillis();
            InfiniteProgressPanel.this._started = true;
            while (!Animator.interrupted() && this._state < 3) {
                if (this._reqState > this._state) {
                    this._state = this._reqState;
                    InfiniteProgressPanel.this._alphaLevel = this._state < 2 ? 255 : 0;
                    start = System.currentTimeMillis();
                }
                try {
                    switch (this._state) {
                        case 0: {
                            if (InfiniteProgressPanel.this._rampDelay == 0) {
                                InfiniteProgressPanel.this._alphaLevel = 255;
                                this._reqState = 1;
                                break;
                            }
                            InfiniteProgressPanel.this._alphaLevel = (int)(255L * (System.currentTimeMillis() - start) / (long)InfiniteProgressPanel.this._rampDelay);
                            if (InfiniteProgressPanel.this._alphaLevel >= 255) {
                                InfiniteProgressPanel.this._alphaLevel = 255;
                                this._reqState = 1;
                            }
                            Animator.sleep(100L);
                            break;
                        }
                        case 2: {
                            if (InfiniteProgressPanel.this._rampDelay == 0) {
                                InfiniteProgressPanel.this._alphaLevel = 0;
                                this._reqState = 3;
                                break;
                            }
                            InfiniteProgressPanel.this._alphaLevel = (int)(255L - 255L * (System.currentTimeMillis() - start) / (long)InfiniteProgressPanel.this._rampDelay);
                            if (InfiniteProgressPanel.this._alphaLevel <= 0) {
                                InfiniteProgressPanel.this._alphaLevel = 0;
                                this._reqState = 3;
                            }
                            Animator.sleep(100L);
                            break;
                        }
                        default: {
                            Animator.sleep((int)(1000.0f / InfiniteProgressPanel.this._fps));
                        }
                    }
                    if (this._state != 1) {
                        InfiniteProgressPanel.this.repaint();
                        continue;
                    }
                    for (int i = 0; i < InfiniteProgressPanel.this._ticker.length; ++i) {
                        InfiniteProgressPanel.this._ticker[i].transform(toCircle);
                    }
                    InfiniteProgressPanel.this.repaint(InfiniteProgressPanel.this._refreshTimeArea);
                    boolean updateTxt = false;
                    if (InfiniteProgressPanel.this._task == null) continue;
                    String msg = InfiniteProgressPanel.this._task.getInfo("process.msg");
                    if (msg == null) {
                        msg = InfiniteProgressPanel.this._text;
                    }
                    if (InfiniteProgressPanel.this._refreshMsgTxt == null) {
                        updateTxt = true;
                    } else if (!InfiniteProgressPanel.this._refreshMsgTxt.equals(msg)) {
                        updateTxt = true;
                    }
                    if (updateTxt) {
                        InfiniteProgressPanel.this._refreshMsgTxt = msg;
                    }
                    Graphics2D g2 = (Graphics2D)InfiniteProgressPanel.this.getGraphics();
                    FontRenderContext context = g2.getFontRenderContext();
                    TextLayout layout = new TextLayout(msg, InfiniteProgressPanel.this.getFont(), context);
                    Rectangle2D bounds = layout.getBounds();
                    Rectangle refreshNew = new Rectangle((int)((double)(InfiniteProgressPanel.this._refreshTimeArea.x + InfiniteProgressPanel.this._refreshTimeArea.width / 2) - bounds.getWidth() / 2.0), InfiniteProgressPanel.this._refreshTimeArea.y + InfiniteProgressPanel.this._refreshTimeArea.height, (int)bounds.getWidth(), (int)(bounds.getHeight() + (double)layout.getLeading() + (double)(2.0f * layout.getAscent())));
                    if (InfiniteProgressPanel.this._refreshMsgArea != null && refreshNew.equals(InfiniteProgressPanel.this._refreshMsgArea) && !updateTxt) continue;
                    if (InfiniteProgressPanel.this._refreshMsgArea != null) {
                        InfiniteProgressPanel.this.repaint(refreshNew.union(InfiniteProgressPanel.this._refreshMsgArea));
                    } else {
                        InfiniteProgressPanel.this.repaint(refreshNew);
                    }
                    InfiniteProgressPanel.this._refreshMsgArea = refreshNew;
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            InfiniteProgressPanel.this._started = false;
            InfiniteProgressPanel.this._animation = null;
            InfiniteProgressPanel.this.repaint();
            InfiniteProgressPanel.this.setVisible(false);
        }
    }
}

