/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.taskmanager;

import java.awt.Component;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class TableRenderedTimes
extends DefaultTableCellRenderer {
    static NumberFormat _nf = new DecimalFormat("00");

    public TableRenderedTimes() {
        this.setHorizontalAlignment(4);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof Long) {
            this.setText(TableRenderedTimes.convertTime((Long)value));
        }
        return this;
    }

    static String convertTime(long times) {
        long sec = times / 1000L;
        long min = sec / 60L;
        long hrs = min / 60L;
        long day = hrs / 24L;
        hrs %= 24L;
        min %= 60L;
        sec %= 60L;
        boolean add = false;
        StringBuffer sb = new StringBuffer(10);
        if (day > 0L) {
            boolean bl = add = sb.append(day).append(" - ") != null;
        }
        if (add || hrs > 0L) {
            boolean bl = add = sb.append(_nf.format(hrs)).append(":") != null;
        }
        if (add || min > 0L) {
            add = sb.append(_nf.format(min)).append(":") != null;
        }
        sb.append(_nf.format(sec));
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println(TableRenderedTimes.convertTime(2500L));
        System.out.println(TableRenderedTimes.convertTime(62500L));
        System.out.println(TableRenderedTimes.convertTime(3662500L));
        System.out.println(TableRenderedTimes.convertTime(10243662500L));
        long times = 10243662500L;
        System.out.println(times);
        System.out.println((times /= 1000L) + " => " + times % 60L);
        System.out.println((times /= 60L) + " => " + times % 60L);
        System.out.println((times /= 60L) + " => " + times % 24L);
        System.out.println("" + (times /= 24L));
        System.out.println(TableRenderedTimes.convertTime(10000243662500L));
    }
}

