/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.taskmanager;

import com.dassault.cecilia.core.plugin.PlugTask;
import com.dassault.cecilia.core.taskmanager.ResTask;
import com.dassault.cecilia.core.taskmanager.TaskState;
import com.dassault.cecilia.core.taskmanager.TaskThread;
import com.dassault.cecilia.lib.util.logging.LogUtility;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;

public class TaskList
extends AbstractTableModel {
    List<TaskThread> _tasks = Collections.synchronizedList(new ArrayList());
    Map<Long, List<TaskThread>> _uidTasks = new LinkedHashMap<Long, List<TaskThread>>();

    public void add(TaskThread task) {
        this._tasks.add(task);
        if (task.getUID() != -1L) {
            List<TaskThread> uidTasks = this._uidTasks.get(task.getUID());
            if (uidTasks == null) {
                uidTasks = new ArrayList<TaskThread>();
                this._uidTasks.put(task.getUID(), uidTasks);
            }
            uidTasks.add(task);
        }
        int size = this._tasks.size();
        this.fireTableRowsInserted(size - 1, size - 1);
    }

    public TaskThread get(int idx) {
        return this._tasks.get(idx);
    }

    private void removeFromUID(TaskThread task) {
        List<TaskThread> uidTasks;
        long uid = task.getUID();
        if (uid != -1L && (uidTasks = this._uidTasks.get(uid)) != null && !uidTasks.remove(task)) {
            LogUtility.logStackTrace((Logger)LogUtility.getLog(TaskList.class), (Level)Level.FINE, (String)("Remove task warning : Unknow task (" + uid + ", " + task.getState() + ", " + task.getTask().getInfo("plugin.name") + ")"));
        }
    }

    public void remove(TaskThread task) {
        int idx = this._tasks.indexOf(task);
        if (idx == -1) {
            return;
        }
        this.fireTableRowsDeleted(idx, idx);
        this._tasks.remove(idx);
        this.removeFromUID(task);
    }

    public void remove(int idx) {
        this.fireTableRowsDeleted(idx, idx);
        TaskThread task = this._tasks.remove(idx);
        if (task != null) {
            this.removeFromUID(task);
        }
    }

    public synchronized TaskThread next() {
        int size = this._tasks.size();
        for (int i = 0; i < size; ++i) {
            TaskThread task = this._tasks.get(i);
            switch (task.state()) {
                case INIT: {
                    return task;
                }
                case HPAUSE: {
                    return task;
                }
            }
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this._tasks.size();
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        switch (c) {
            case 0: {
                return TaskState.class;
            }
            case 1: {
                return PlugTask.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return Float.class;
            }
            case 5: {
                return Long.class;
            }
        }
        return super.getColumnClass(c);
    }

    @Override
    public String getColumnName(int c) {
        switch (c) {
            case 0: {
                return ResTask.getString("LST_TASK_STATE");
            }
            case 1: {
                return ResTask.getString("LST_TASK_ID");
            }
            case 2: {
                return ResTask.getString("LST_TASK_DESC");
            }
            case 3: {
                return ResTask.getString("LST_TASK_MSG");
            }
            case 4: {
                return ResTask.getString("LST_TASK_PROGRESS");
            }
            case 5: {
                return ResTask.getString("LST_TASK_CHRONOS");
            }
        }
        return super.getColumnName(c);
    }

    @Override
    public Object getValueAt(int r, int c) {
        TaskThread task = this._tasks.get(r);
        if (task == null) {
            return null;
        }
        switch (c) {
            case 0: {
                return task.state();
            }
            case 1: {
                return task.getTask();
            }
            case 2: {
                return task.getTask().getInfo("ptask.desc");
            }
            case 3: {
                return task.getTask().getInfo("process.msg");
            }
            case 4: {
                int val = -1;
                PlugTask ptask = task.getTask();
                try {
                    val = Integer.parseInt(ptask.getInfo("process.p1000"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (val < 0) {
                    return Float.valueOf(-1.0f);
                }
                return Float.valueOf((float)val / 1000.0f);
            }
            case 5: {
                return task.getChronos();
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return false;
    }

    public void down(int idx) {
        assert (idx > 0 && idx <= this._tasks.size() - 1) : Integer.toString(idx);
        TaskThread obj = this._tasks.remove(idx);
        this._tasks.add(idx - 1, obj);
        this.fireTableRowsUpdated(idx - 1, idx);
    }

    public void up(int idx) {
        assert (idx >= 0 && idx < this._tasks.size() - 1) : Integer.toString(idx);
        TaskThread obj = this._tasks.remove(idx);
        this._tasks.add(idx + 1, obj);
        this.fireTableRowsUpdated(idx, idx + 1);
    }

    public void refresh(TaskThread task) {
        if (task == null) {
            return;
        }
        int idx = this._tasks.indexOf(task);
        if (idx == -1) {
            return;
        }
        EventQueue.invokeLater(new refreshCell(idx, task));
    }

    public void select(TaskThread task) {
        if (task == null) {
            return;
        }
        int idx = this._tasks.indexOf(task);
        if (idx == -1) {
            return;
        }
        EventQueue.invokeLater(new selectCell(idx));
    }

    public List<TaskThread> getTasks(long uid) {
        return this._uidTasks.get(uid);
    }

    class refreshCell
    implements Runnable {
        int _idx;
        TaskThread _task;

        refreshCell(int index, TaskThread task) {
            this._idx = index;
            this._task = task;
        }

        @Override
        public void run() {
            TaskList.this.fireTableCellUpdated(this._idx, -1);
        }
    }

    class selectCell
    implements Runnable {
        int _idx;

        selectCell(int index) {
            this._idx = index;
        }

        @Override
        public void run() {
            TaskList.this.fireTableCellUpdated(this._idx, -2);
        }
    }
}

