/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.taskmanager;

import com.dassault.cecilia.core.plugin.PlugTask;
import com.dassault.cecilia.core.taskmanager.TaskState;
import java.util.Date;

public class TaskThread
extends Thread {
    PlugTask _action;
    private TaskState _state;
    private TaskState _save;
    boolean _start;
    long _chronos;
    long _chronosStartTime;
    long _uid;
    Object _chronosLocker = new Object();

    public TaskThread(PlugTask action, long uid) {
        super("Cecilia-" + action.getInfo("plugin.name"));
        this._action = action;
        this._uid = uid;
        this._start = false;
        this._save = TaskState.INIT;
        this._state = TaskState.INIT;
        this._chronos = 0L;
        this._chronosStartTime = -1L;
    }

    public PlugTask getTask() {
        return this._action;
    }

    public long getUID() {
        return this._uid;
    }

    public TaskState state() {
        return this._state;
    }

    private void setState(TaskState state) {
        if (this._state == state) {
            return;
        }
        this._state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getChronos() {
        long result = this._chronos;
        if (this.state() == TaskState.RUN) {
            Object object = this._chronosLocker;
            synchronized (object) {
                if (this._chronosStartTime == -1L) {
                    this._chronosStartTime = new Date().getTime();
                }
                result += new Date().getTime() - this._chronosStartTime;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start() {
        this.setState(TaskState.RUN);
        Object object = this._chronosLocker;
        synchronized (object) {
            this._chronosStartTime = new Date().getTime();
        }
        if (this._start) {
            this._action.requestResume();
        } else {
            this._start = true;
            super.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this._action.run();
        Object object = this._chronosLocker;
        synchronized (object) {
            if (this._chronosStartTime > 0L) {
                this._chronos += new Date().getTime() - this._chronosStartTime;
                this._chronosStartTime = -1L;
            }
        }
        this.setState(TaskState.FINISH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestSuspend(boolean hight) {
        if (this.state() != TaskState.INIT && this.state() != TaskState.RUN) {
            return;
        }
        if (hight) {
            this._save = this.state();
            this.setState(TaskState.HPAUSE);
        } else {
            this.setState(TaskState.PAUSE);
        }
        if (this._start) {
            Object object = this._chronosLocker;
            synchronized (object) {
                this._chronos += new Date().getTime() - this._chronosStartTime;
                this._chronosStartTime = -1L;
            }
            this._action.requestSuspend(hight);
        }
    }

    public void requestResume(boolean hight) {
        if (this.state() != TaskState.HPAUSE && this.state() != TaskState.PAUSE) {
            return;
        }
        if (hight) {
            this.setState(this._save);
            if (this.state() == TaskState.RUN) {
                this._action.requestResume();
            }
        } else {
            this.setState(TaskState.INIT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestStop() {
        switch (this.state()) {
            case INIT: {
                break;
            }
            case PAUSE: {
                break;
            }
            case RUN: {
                break;
            }
            default: {
                return;
            }
        }
        if (this._start) {
            this.setState(TaskState.STOPPED);
            this._action.requestStop();
            Object object = this._chronosLocker;
            synchronized (object) {
                if (this._chronosStartTime > 0L) {
                    this._chronos += new Date().getTime() - this._chronosStartTime;
                    this._chronosStartTime = new Date().getTime();
                }
            }
        } else {
            this.setState(TaskState.FINISH);
        }
    }
}

