/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db;

import com.dassault.cecilia.db.DBItem;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DBLicense
extends DBItem {
    String _company = "";
    String _module = "";
    String _version = "";
    String _host = "";
    int _token = 0;
    Date _expire = new Date();
    static String __allVersion = "?.?";
    static final Pattern __PATTERN_VERSION = Pattern.compile("([0-9]+)\\.([0-9]+)(.*)");
    static int __unlimitedToken = -1;
    static SimpleDateFormat __dateFormat = new SimpleDateFormat("dd'/'MM'/'yyyy");
    static Date __dateAlways = new Date(0L);

    public DBLicense() {
    }

    public DBLicense(long id) {
        super(id);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof DBLicense;
    }

    @Override
    public String toString() {
        StringBuilder debug = new StringBuilder();
        debug.append("License:").append(this._company);
        debug.append(",").append(this._module);
        return debug.toString();
    }

    public String getCompany() {
        return this._company;
    }

    public DBLicense setCompany(String company) {
        this._company = company;
        return this;
    }

    public String getModule() {
        return this._module;
    }

    public DBLicense setModule(String module) {
        this._module = module;
        return this;
    }

    public static String getAllVersion() {
        return __allVersion;
    }

    public static final boolean isCompatible(String testedVersion, String otherVersion) {
        Matcher otherMatcher;
        Matcher currentMatcher = __PATTERN_VERSION.matcher(testedVersion);
        if (currentMatcher.matches() && (otherMatcher = __PATTERN_VERSION.matcher(otherVersion)).matches() && Integer.valueOf(currentMatcher.group(1)).compareTo(Integer.valueOf(otherMatcher.group(1))) >= 0 && Integer.valueOf(currentMatcher.group(2)).compareTo(Integer.valueOf(otherMatcher.group(2))) >= 0) {
            return true;
        }
        return otherVersion.startsWith(testedVersion);
    }

    public final boolean isCompatible(String otherVersion) {
        return DBLicense.isCompatible(this.getVersion(), otherVersion);
    }

    public String getVersion() {
        return this._version;
    }

    public DBLicense setVersion(String version) {
        this._version = version;
        return this;
    }

    public String getHost() {
        return this._host;
    }

    public DBLicense setHost(String host) {
        this._host = host;
        return this;
    }

    public static int getUnlimitedToken() {
        return __unlimitedToken;
    }

    public static int parseToken(String token) {
        if (token.equalsIgnoreCase("ILLIMITE")) {
            return DBLicense.getUnlimitedToken();
        }
        try {
            return Integer.parseInt(token);
        }
        catch (NumberFormatException e) {
            _LOG.warning("DBLicense::convertToken(" + token + "): not compatible");
            return 0;
        }
    }

    public static String printToken(int token) {
        if (token == DBLicense.getUnlimitedToken()) {
            return "ILLIMITE";
        }
        return Integer.toString(token);
    }

    public int getToken() {
        return this._token;
    }

    public DBLicense setToken(int token) {
        this._token = token;
        return this;
    }

    public static DateFormat getDateFormat() {
        return __dateFormat;
    }

    public static Date getAlwaysDate() {
        return __dateAlways;
    }

    public static Date parseDate(String delay) {
        if (delay.equalsIgnoreCase("ALWAYS")) {
            return DBLicense.getAlwaysDate();
        }
        try {
            return DBLicense.getDateFormat().parse(delay);
        }
        catch (ParseException e) {
            _LOG.warning("DBLicense::convertDateFromDB(" + delay + "): not compatible");
            return null;
        }
    }

    public static String printDate(Date delay) {
        if (delay.equals(DBLicense.getAlwaysDate())) {
            return "ALWAYS";
        }
        return DBLicense.getDateFormat().format(delay);
    }

    public Date getExpire() {
        return this._expire;
    }

    public DBLicense setExpire(Date delay) {
        this._expire = delay;
        return this;
    }
}

