/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db;

import com.dassault.cecilia.db.DBFlagItem;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObjProperty;
import com.dassault.cecilia.db.DBSession;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public class DBObject
extends DBFlagItem {
    private static final Comparator<String> COMPARE_NATURE = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    };
    DBFolder _folder;
    DBSession _lockSession;
    long _timeUpdate;
    Map<String, DBObjProperty> _properties = new LinkedHashMap<String, DBObjProperty>();
    Map<String, DBObjModel> _models = new TreeMap<String, DBObjModel>(COMPARE_NATURE);
    public static final int FLAG_FREEZE = 2;
    public static final int FLAG_TREE_APPLICABLE = 16;
    public static final int FLAG_TREE_WORK = 32;
    public static final int FLAG_NEW = 64;
    public static final int FLAG_GENERATED_BY_ARBOR = 128;

    public DBObject() {
    }

    public DBObject(long id) {
        super(id);
    }

    public DBObject(DBObject src, boolean duplicate) {
        this.copyFrom(src, duplicate);
    }

    public void copyFrom(DBObject src, boolean duplicate) {
        super.copyFrom(src);
        this._lockSession = src._lockSession;
        this._timeUpdate = src._timeUpdate;
        if (duplicate) {
            for (DBObjProperty prop : src._properties.values()) {
                DBObjProperty cpy = new DBObjProperty(prop);
                cpy.setID(-1L);
                this.addProperty(cpy);
            }
            this.setID(-1L);
        } else {
            for (DBObjProperty prop : src._properties.values()) {
                this.addProperty(new DBObjProperty(prop));
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof DBObject;
    }

    @Override
    public String toString() {
        StringBuilder debug = new StringBuilder();
        debug.append("Object:").append(this._id).append(",");
        if (this._folder != null) {
            debug.append(this._folder.getName());
        }
        return debug.toString();
    }

    public DBFolder getFolder() {
        return this._folder;
    }

    public DBObject setFolder(DBFolder folder) {
        this._folder = folder;
        return this;
    }

    public boolean isLocked() {
        return this._lockSession != null;
    }

    public DBSession getLockedSession() {
        return this._lockSession;
    }

    public DBObject setLocked(DBSession session) {
        this._lockSession = session;
        return this;
    }

    public DBObject setUnlocked() {
        this._lockSession = null;
        return this;
    }

    public boolean isFreeze() {
        return (this._flags & 2) != 0;
    }

    public boolean isBinFlag(int binMask) {
        return (this._flags & binMask) != 0;
    }

    public DBObject setBinFlag(int binMask) {
        this._flags |= binMask;
        return this;
    }

    public DBObject unsetBinFlag(int binMask) {
        this._flags &= ~binMask;
        return this;
    }

    public long getTimeUpdate() {
        return this._timeUpdate;
    }

    public DBObject setTimeUpdate(long time) {
        this._timeUpdate = time;
        return this;
    }

    public DBObject addProperty(DBObjProperty prop) {
        this._properties.put(prop.getName(), prop);
        prop.setObject(this);
        return this;
    }

    public void delProperty(DBObjProperty prop) {
        DBObjProperty verifProp = this._properties.remove(prop.getName());
        if (verifProp != prop) {
            _LOG.severe("Tentative de suppresion d'une propriete qui n'existe pas : " + prop.toString());
        } else {
            prop.setObject(null);
        }
    }

    public DBObjProperty getProperty(String key) {
        return this._properties.get(key);
    }

    public Collection<DBObjProperty> getProperties() {
        return this._properties.values();
    }

    public DBObject setProperties(Collection<DBObjProperty> properties) {
        this._properties.clear();
        for (DBObjProperty property : properties) {
            this.addProperty(property);
        }
        return this;
    }

    public DBObject addModel(DBObjModel model) {
        this._models.put(model.getNature(), model);
        model.setObject(this);
        return this;
    }

    public void delModel(DBObjModel model) {
        if (model.getObject() != this) {
            _LOG.info("Appel de la methode delModel avec un modele invalide");
            return;
        }
        if (!this._models.containsKey(model.getNature())) {
            _LOG.info("Appel de la methode delModel avec un modele qui n'appartient pas (ou plus) a l'objet");
            return;
        }
        this._models.remove(model.getNature());
        model.setObject(null);
    }

    public DBObjModel getModel(String nature) {
        if (nature == null) {
            throw new NullPointerException();
        }
        return this._models.get(nature);
    }

    public Collection<DBObjModel> getModels() {
        return this._models.values();
    }

    public DBObject setModels(Collection<DBObjModel> models) {
        this.clearModels();
        for (DBObjModel model : models) {
            this.addModel(model);
        }
        return this;
    }

    public void clearModels() {
        this._models.clear();
    }
}

