/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db;

import com.dassault.cecilia.db.DBFlagItem;
import com.dassault.cecilia.db.IUser;
import java.util.Date;

public class DBSession
extends DBFlagItem {
    public static final String PROP_SESSION_EXPIRE_DELAY_DEFAULT = "600";
    public static final String PROP_SESSION_EXPIRE_DELAY = "cecilia.db.session.expireDelay";
    private static long __EXPIRE_DELAY = Math.max(60L, Long.getLong("cecilia.db.session.expireDelay", Long.parseLong("600")));
    IUser _user = null;
    String _module = "";
    long _expire = new Date().getTime() / 1000L + __EXPIRE_DELAY;
    boolean _bCurrent = false;
    boolean _bActive = false;

    public DBSession() {
    }

    public DBSession(long id, String module) {
        super(id);
        this._module = module;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof DBSession;
    }

    @Override
    public String toString() {
        StringBuilder debug = new StringBuilder();
        debug.append("Session:").append(this._id);
        debug.append(",").append(this._module);
        debug.append(",");
        debug.append("{").append(this._user.getID()).append(",").append(this._user.getLogin()).append("}");
        debug.append(",").append(this._flags);
        debug.append(",").append(this._expire);
        return debug.toString();
    }

    public IUser getUser() {
        return this._user;
    }

    public DBSession setUser(IUser user) {
        this._user = user;
        return this;
    }

    public String getModule() {
        return this._module;
    }

    public DBSession setModule(String module) {
        this._module = module;
        return this;
    }

    public boolean isCurrent() {
        return this._bCurrent;
    }

    public void setCurrent() {
        this._bCurrent = true;
    }

    public boolean isActive() {
        return this._bActive;
    }

    public DBSession setActive(boolean isActive) {
        this._bActive = isActive;
        return this;
    }

    public long getExpire() {
        return this._expire;
    }

    public DBSession setExpire(long expire) {
        this._expire = expire;
        this.setActive(new Date().getTime() / 1000L <= expire);
        return this;
    }

    public void updateExpire() {
        this._expire = new Date().getTime() / 1000L + __EXPIRE_DELAY;
    }

    public Date getExpireDate() {
        return new Date(this._expire * 1000L);
    }
}

