/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db;

import com.dassault.cecilia.db.DBFlagItem;

public interface IUser {
    public static final int FLAG_MASTER = 0x800000;

    public long getID();

    public String getLogin();

    public boolean isReal();

    public boolean isMasterAdmin();

    public static class MinimalUser
    extends DBFlagItem
    implements IUser {
        String _login;

        public MinimalUser(long id, String login, int flags) {
            super(id, flags);
            this._login = login;
        }

        @Override
        public String getLogin() {
            return this._login;
        }

        @Override
        public boolean isReal() {
            return false;
        }

        @Override
        public boolean isMasterAdmin() {
            return (this._flags & 0x800000) != 0;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            return obj instanceof IUser;
        }

        @Override
        public String toString() {
            return this._login;
        }
    }
}

