/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao;

import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.sql.SQLConnection;
import com.dassault.cecilia.db.dao.sql.h2.H2Factory;
import com.dassault.cecilia.db.dao.sql.mysql.MySQLFactory;
import com.dassault.cecilia.db.dao.sql.oracle.OracleFactory;
import com.dassault.cecilia.db.dao.sql.postgres.PostgresFactory;

public class DAOBuilder {
    boolean _sqlVersion51 = false;
    SQLConnection _sqlConnect = null;

    public DAOBuilder setSQLConnection(SQLConnection sqlConnect) {
        this._sqlConnect = sqlConnect;
        return this;
    }

    public DAOBuilder setSQLVersion51(boolean value) {
        this._sqlVersion51 = value;
        return this;
    }

    public DAOFactory createFactory() {
        DAOFactory result = null;
        if (this._sqlConnect != null && !this._sqlVersion51) {
            switch (this._sqlConnect.getType()) {
                case H2: {
                    result = new H2Factory(this._sqlConnect);
                    break;
                }
                case MySQL: {
                    result = new MySQLFactory(this._sqlConnect);
                    break;
                }
                case Oracle: {
                    result = new OracleFactory(this._sqlConnect);
                    break;
                }
                case Postgres: {
                    result = new PostgresFactory(this._sqlConnect);
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        if (result != null) {
            result.initConnection();
        }
        return result;
    }
}

