/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao.sql;

import com.dassault.cecilia.lib.util.io.LogOutputStream;
import com.dassault.cecilia.lib.util.io.ProcessLauncher;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SQLConnection {
    private static Logger _LOG = Logger.getLogger(SQLConnection.class.getPackage().getName());
    public static final String TYPE = "db.product";
    public static final String NAME = "db.name";
    public static final String DRIVER = "db.driver";
    public static final String CONNECT_SET = "db.connect.set";
    public static final String CONNECT = "db.connect";
    public static final String CONNECT_DIRECT = "db.connect.direct";
    public static final String TEXT_DIR = "db.text.dir";
    public static final String ACCESS_FILE = "db.access.file";
    public static final String SQLITE_FILE = "db.sqlite.file";
    public static final String H2_FILE = "db.h2.file";
    public static final String ODBC_DATA = "db.odbc.data";
    public static final String SRV_HOST = "db.srv.host";
    public static final String SRV_PORT = "db.srv.port";
    public static final String SRV_NAME = "db.srv.name";
    public static final String SRV_USER = "db.srv.user";
    public static final String SRV_PASSWD = "db.srv.password";
    public static final String IDENTIFY = "db.identify";
    private DBType _type;
    private Connection _connection;
    private String _driver = "";
    private String _connectString = "";
    private String _login = "";
    private String _passwd = "";
    private Map<String, String> _properties = null;
    boolean _bUnique = false;
    public static final String PROP_DEF_DB_H2_DRIVER_1X = "./core/lib/jdbc/h2-1.3.175.jar";
    public static final String PROP_DB_H2_DRIVER_1X = "cecilia.db.H2.Drivers1X";
    public static final String PROP_DEF_DB_H2_DRIVER_2X = "./core/lib/jdbc/h2-2.1.214.jar";
    public static final String PROP_DB_H2_DRIVER_2X = "cecilia.db.H2.Drivers2X";

    private String createDefaultConnectString() {
        String connect = this._properties.get(CONNECT_SET);
        if (connect != null) {
            return connect;
        }
        switch (this._type) {
            case Access: {
                String path = this._properties.get(ACCESS_FILE);
                return "jdbc:odbc:Driver={Microsoft Access Driver (*.mdb)};DBQ=" + path;
            }
            case H2: {
                String path = this._properties.get(H2_FILE);
                if (path.toLowerCase().endsWith(".mv.db")) {
                    path = path.substring(0, path.length() - ".mv.db".length());
                } else if (path.toLowerCase().endsWith(".h2.db")) {
                    path = path.substring(0, path.length() - ".h2.db".length());
                }
                return "jdbc:h2:file:" + path + ";IFEXISTS=TRUE";
            }
            case ODBC: {
                String name = this._properties.get(ODBC_DATA);
                return "jdbc:odbc:" + name;
            }
            case Oracle: {
                String direct = this._properties.get(CONNECT_DIRECT);
                if (direct != null && direct.equalsIgnoreCase("true")) {
                    return this._properties.get(CONNECT);
                }
                String host = this._properties.get(SRV_HOST);
                String port = this._properties.get(SRV_PORT);
                String name = this._properties.get(SRV_NAME);
                return "jdbc:oracle:thin:@" + host + ":" + port + "/" + name;
            }
            case Postgres: {
                String direct = this._properties.get(CONNECT_DIRECT);
                if (direct != null && direct.equalsIgnoreCase("true")) {
                    return this._properties.get(CONNECT);
                }
                String host = this._properties.get(SRV_HOST);
                String port = this._properties.get(SRV_PORT);
                String name = this._properties.get(SRV_NAME);
                return "jdbc:postgresql://" + host + ":" + port + "/" + name;
            }
            case MySQL: {
                String direct = this._properties.get(CONNECT_DIRECT);
                if (direct != null && direct.equalsIgnoreCase("true")) {
                    return this._properties.get(CONNECT);
                }
                String host = this._properties.get(SRV_HOST);
                String port = this._properties.get(SRV_PORT);
                String name = this._properties.get(SRV_NAME);
                String login = this._properties.get(SRV_USER);
                return "jdbc:mysql://" + host + ":" + port + "/" + name + "?user=" + login + "&password=";
            }
        }
        return null;
    }

    public static DBType findDBType(String connect) {
        if (connect == null) {
            return null;
        }
        if (connect.trim().length() == 0) {
            return null;
        }
        if (connect.startsWith("jdbc:odbc:Driver={Microsoft Access Driver (*.mdb)}")) {
            return DBType.Access;
        }
        if (connect.startsWith("jdbc:odbc")) {
            return DBType.ODBC;
        }
        if (connect.startsWith("jdbc:h2:file")) {
            return DBType.H2;
        }
        if (connect.startsWith("jdbc:oracle")) {
            return DBType.Oracle;
        }
        if (connect.startsWith("jdbc:postgresql")) {
            return DBType.Postgres;
        }
        if (connect.startsWith("jdbc:mysql")) {
            return DBType.MySQL;
        }
        return null;
    }

    public SQLConnection(DBType type, Map<String, String> properties) {
        this._properties = new HashMap<String, String>(properties);
        this._type = type;
        switch (this._type) {
            case Access: {
                this._driver = "sun.jdbc.odbc.JdbcOdbcDriver";
                this._connectString = this.createDefaultConnectString();
                break;
            }
            case Sqlite: {
                this._driver = "org.sqlite.JDBC";
                this._connectString = this.createDefaultConnectString();
                break;
            }
            case H2: {
                this._driver = "org.h2.Driver";
                this._connectString = this.createDefaultConnectString();
                break;
            }
            case ODBC: {
                this._driver = "sun.jdbc.odbc.JdbcOdbcDriver";
                this._connectString = this.createDefaultConnectString();
                break;
            }
            case Oracle: {
                this._driver = "oracle.jdbc.driver.OracleDriver";
                this._connectString = this.createDefaultConnectString();
                this._login = this._properties.get(SRV_USER);
                this._passwd = this._properties.get(SRV_PASSWD);
                break;
            }
            case Postgres: {
                this._driver = "org.postgresql.Driver";
                this._connectString = this.createDefaultConnectString();
                this._login = this._properties.get(SRV_USER);
                this._passwd = this._properties.get(SRV_PASSWD);
                break;
            }
            case MySQL: {
                this._login = this._properties.get(SRV_USER);
                this._passwd = this._properties.get(SRV_PASSWD);
                this._driver = "com.mysql.jdbc.Driver";
                this._connectString = this.createDefaultConnectString();
            }
        }
        this._properties.put(TYPE, this._type.toString());
        this._properties.put(DRIVER, this._driver);
        this._properties.put(CONNECT, this._connectString);
    }

    public final boolean isDataBaseNode() {
        switch (this._type) {
            case Access: {
                return true;
            }
            case Sqlite: {
                return true;
            }
            case H2: {
                return true;
            }
            case ODBC: {
                return true;
            }
        }
        return false;
    }

    public final DBType getType() {
        return this._type;
    }

    final Map<String, String> getProperties() {
        return this._properties;
    }

    public final Connection getConnection() {
        if (this._connection == null) {
            _LOG.severe("Connection not created");
        } else {
            try {
                if (this._connection.isClosed()) {
                    _LOG.severe("Connection already closed");
                }
            }
            catch (SQLException e) {
                _LOG.log(Level.SEVERE, "Test if is closed connection", e);
            }
        }
        return this._connection;
    }

    public void setName(String name) {
        this._properties.put(NAME, name);
    }

    public String getName() {
        String name = this._properties.get(NAME);
        if (name == null) {
            return "";
        }
        return name;
    }

    public final String getConnectionUrl() {
        return this._connectString;
    }

    public final String getLogin() {
        return this._login;
    }

    public final String getPasswd() {
        return this._passwd;
    }

    public final String getData(String key) {
        return this._properties.get(key);
    }

    public final void createConnection() throws SQLException {
        if (this._connection != null) {
            if (!this._connection.isClosed()) {
                return;
            }
            _LOG.fine("Connection exist but is closed");
        }
        Class<?> clDrivers = null;
        try {
            clDrivers = Class.forName(this._driver);
        }
        catch (ClassNotFoundException ex) {
            throw new SQLException("Cannot find the database driver classes.\n" + ex.getMessage());
        }
        if (_LOG.isLoggable(Level.INFO)) {
            _LOG.info("JDBC drivers version: " + this.readVersionDriver(clDrivers));
        }
        if (this._type == DBType.H2 && this._properties.get(H2_FILE).toLowerCase().endsWith(".h2.db")) {
            this.changeBeforeUse();
        }
        this._connection = DriverManager.getConnection(this._connectString, this._login, this._passwd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readVersionDriver(Class clDrivers) {
        String nameRes = clDrivers.getName().replace('.', '/') + ".class";
        try {
            URL url = clDrivers.getClassLoader().getResource(nameRes);
            String urlStr = URLDecoder.decode(url.toString(), "UTF-8");
            int pos = urlStr.lastIndexOf(33);
            if (!urlStr.startsWith("jar:file:/")) return null;
            if (pos == -1) return null;
            String jarPath = urlStr.substring("jar:file:/".length(), pos);
            try (JarFile jarFile = new JarFile(jarPath);){
                String version;
                Manifest man = jarFile.getManifest();
                if (man == null) return null;
                String string = version = man.getMainAttributes().getValue("Implementation-Version");
                return string;
            }
        }
        catch (Exception e) {
            _LOG.log(Level.FINER, "Erreur durant la lecture de la version du drivers", e);
        }
        return null;
    }

    public void close() throws SQLException {
        if (this._connection != null) {
            this._connection.close();
        }
    }

    public String getAbstract() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("Type : ").append(this._type.toString()).append("\n");
        switch (this._type) {
            case Access: {
                sb.append("File : ").append(this._properties.get(ACCESS_FILE));
                break;
            }
            case Sqlite: {
                sb.append("File : ").append(this._properties.get(SQLITE_FILE));
                break;
            }
            case H2: {
                sb.append("File : ").append(this._properties.get(H2_FILE));
                break;
            }
            case ODBC: {
                sb.append("Connector : ").append(this._properties.get(ODBC_DATA));
                break;
            }
            default: {
                String direct = this._properties.get(CONNECT_DIRECT);
                if (direct != null && direct.equalsIgnoreCase("true")) {
                    sb.append("Connect : ").append(this._properties.get(CONNECT)).append("\n");
                } else {
                    sb.append("\tHost : ").append(this._properties.get(SRV_HOST)).append("\n");
                    sb.append("\tPort : ").append(this._properties.get(SRV_PORT)).append("\n");
                    sb.append("\tName : ").append(this._properties.get(SRV_NAME)).append("\n");
                }
                sb.append("User : ").append(this._properties.get(SRV_USER));
            }
        }
        return sb.toString();
    }

    public SQLConnection setUnique(boolean value) {
        this._bUnique = value;
        return this;
    }

    public boolean isUnique() {
        return this._bUnique;
    }

    boolean changeBeforeUse() {
        if (this._type != DBType.H2) {
            return false;
        }
        String h2FilePath = this._properties.get(H2_FILE);
        if (!h2FilePath.toLowerCase().endsWith(".h2.db")) {
            return false;
        }
        File fileMVDB = new File((h2FilePath = h2FilePath.substring(0, h2FilePath.length() - ".h2.db".length())) + ".mv.db");
        if (fileMVDB.exists()) {
            _LOG.warning("H2File already convert to new format 2.X: " + fileMVDB);
            return false;
        }
        _LOG.info("H2File Convert to new format 2.X: " + this._connectString);
        String javaHome = System.getProperty("java.home");
        File tmpSQLFile = null;
        try {
            tmpSQLFile = File.createTempFile("H2-1.3.175", ".sql");
        }
        catch (IOException e) {
            return false;
        }
        tmpSQLFile.deleteOnExit();
        ProcessLauncher launcher = new ProcessLauncher((OutputStream)new LogOutputStream(_LOG, Level.FINEST, "H2-Script-OutputStream"), (OutputStream)new LogOutputStream(_LOG, Level.INFO, "H2-Script-ErrorStream"));
        String[] cmd = new String[10];
        int i = 0;
        cmd[i++] = javaHome + "./bin/java";
        cmd[i++] = "-cp";
        cmd[i++] = System.getProperty(PROP_DB_H2_DRIVER_1X, PROP_DEF_DB_H2_DRIVER_1X);
        cmd[i++] = "org.h2.tools.Script";
        cmd[i++] = "-url";
        cmd[i++] = this._connectString;
        cmd[i++] = "-user";
        cmd[i++] = "";
        cmd[i++] = "-script";
        cmd[i++] = tmpSQLFile.getAbsolutePath();
        try {
            int result = launcher.exec(cmd);
            if (result != 0) {
                _LOG.log(Level.INFO, "Return error during H2-Script: " + result);
                return false;
            }
        }
        catch (IOException e) {
            _LOG.log(Level.INFO, "Exception during H2-Script", e);
            return false;
        }
        String h2FilePathTmp = h2FilePath + "-" + Long.toString(new Date().getTime()) + "-" + Integer.toString(new Random().nextInt());
        ProcessLauncher launcher2 = new ProcessLauncher((OutputStream)new LogOutputStream(_LOG, Level.FINEST, "H2-RunScript-OutputStream"), (OutputStream)new LogOutputStream(_LOG, Level.INFO, "H2-RunScript-ErrorStream"));
        String[] cmd2 = new String[12];
        int i2 = 0;
        cmd2[i2++] = javaHome + "./bin/java";
        cmd2[i2++] = "-cp";
        cmd2[i2++] = System.getProperty(PROP_DB_H2_DRIVER_2X, PROP_DEF_DB_H2_DRIVER_2X);
        cmd2[i2++] = "org.h2.tools.RunScript";
        cmd2[i2++] = "-url";
        cmd2[i2++] = "jdbc:h2:file:" + h2FilePathTmp;
        cmd2[i2++] = "-user";
        cmd2[i2++] = "";
        cmd2[i2++] = "-script";
        cmd2[i2++] = tmpSQLFile.getAbsolutePath();
        cmd2[i2++] = "-options";
        cmd2[i2++] = "FROM_1X";
        try {
            int result = launcher2.exec(cmd2);
            if (result != 0) {
                _LOG.log(Level.INFO, "Return error during H2-RunScript: " + result);
                return false;
            }
        }
        catch (IOException e) {
            _LOG.log(Level.INFO, "Exception during H2-RunScript", e);
            return false;
        }
        File tmpFile = new File(h2FilePathTmp + ".mv.db");
        if (!tmpFile.renameTo(fileMVDB)) {
            _LOG.log(Level.INFO, "Error during rename H2 file");
            return false;
        }
        this._properties.put(H2_FILE, fileMVDB.getAbsolutePath());
        return true;
    }

    public static enum DBType {
        Access("access", "sun.jdbc.odbc.JdbcOdbcDriver"),
        ODBC("ODBC", "sun.jdbc.odbc.JdbcOdbcDriver"),
        Oracle("server", "oracle.jdbc.driver.OracleDriver"),
        MySQL("server", "com.mysql.jdbc.Driver"),
        Sqlite("sqlite", "org.sqlite.JDBC"),
        H2("h2", "org.h2.Driver"),
        Postgres("server", "org.postgresql.Driver");

        String _key;
        String _driver;

        private DBType(String key, String driver) {
            this._key = key;
            this._driver = driver;
        }

        public String getKey() {
            return this._key;
        }

        public String getDriver() {
            return this._driver;
        }
    }
}

